/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.p2p;

import android.net.MacAddress;
import android.os.Build;
import android.os.Parcelable;

/**
 * A class representing a Wi-Fi P2p configuration for setting up a connection
 *
 * {@see WifiP2pManager}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class WifiP2pConfig implements android.os.Parcelable {

public WifiP2pConfig() { throw new RuntimeException("Stub!"); }

/** copy constructor */

public WifiP2pConfig(android.net.wifi.p2p.WifiP2pConfig source) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Get the IP provisioning mode when joining a group as a group client.
 * The result will be one of the following:
 * {@link #GROUP_CLIENT_IP_PROVISIONING_MODE_IPV4_DHCP},
 * {@link #GROUP_CLIENT_IP_PROVISIONING_MODE_IPV6_LINK_LOCAL}

 * @return Value is {@link android.net.wifi.p2p.WifiP2pConfig#GROUP_CLIENT_IP_PROVISIONING_MODE_IPV4_DHCP}, or {@link android.net.wifi.p2p.WifiP2pConfig#GROUP_CLIENT_IP_PROVISIONING_MODE_IPV6_LINK_LOCAL}
 */

public int getGroupClientIpProvisioningMode() { throw new RuntimeException("Stub!"); }

/**
 * Get the required band for the group owner.
 * The result will be one of the following:
 * {@link #GROUP_OWNER_BAND_AUTO},
 * {@link #GROUP_OWNER_BAND_2GHZ},
 * {@link #GROUP_OWNER_BAND_5GHZ},
 * {@link #GROUP_OWNER_BAND_6GHZ}

 * @return Value is {@link android.net.wifi.p2p.WifiP2pConfig#GROUP_OWNER_BAND_AUTO}, {@link android.net.wifi.p2p.WifiP2pConfig#GROUP_OWNER_BAND_2GHZ}, {@link android.net.wifi.p2p.WifiP2pConfig#GROUP_OWNER_BAND_5GHZ}, or {@link android.net.wifi.p2p.WifiP2pConfig#GROUP_OWNER_BAND_6GHZ}
 */

public int getGroupOwnerBand() { throw new RuntimeException("Stub!"); }

/**
 * Get the P2P Group Owner version.
 * See also {@link #setGroupOwnerVersion(int)}.
 *
 * @return The P2P Group Owner protocol version.

 * Value is android.net.wifi.p2p.WifiP2pConfig.P2P_DEFAULT_VERSION_1, {@link android.net.wifi.p2p.WifiP2pConfig#P2P_VERSION_1}, or {@link android.net.wifi.p2p.WifiP2pConfig#P2P_VERSION_2}
 */

public int getGroupOwnerVersion() { throw new RuntimeException("Stub!"); }

/**
 * Get the network ID of this P2P configuration.
 * @return either a non-negative network ID, or one of
 * {@link android.net.wifi.p2p.WifiP2pGroup#NETWORK_ID_PERSISTENT WifiP2pGroup.NETWORK_ID_PERSISTENT} or {@link android.net.wifi.p2p.WifiP2pGroup#NETWORK_ID_TEMPORARY WifiP2pGroup.NETWORK_ID_TEMPORARY}.
 */

public int getNetworkId() { throw new RuntimeException("Stub!"); }

/** Get the network name of this P2P configuration, or null if unset. */

@android.annotation.Nullable
public java.lang.String getNetworkName() { throw new RuntimeException("Stub!"); }

/**
 * Get the pairing bootstrapping configuration , or null if unset.
 */

@android.annotation.Nullable
public android.net.wifi.p2p.WifiP2pPairingBootstrappingConfig getPairingBootstrappingConfig() { throw new RuntimeException("Stub!"); }

/** Get the passphrase of this P2P configuration, or null if unset. */

@android.annotation.Nullable
public java.lang.String getPassphrase() { throw new RuntimeException("Stub!"); }

/**
 * Get the PCC Mode connection type.
 *
 * @return One of the {@code PCC_MODE_CONNECTION_TYPE_*}.

 * Value is android.net.wifi.p2p.WifiP2pConfig.PCC_MODE_DEFAULT_CONNECTION_TYPE_LEGACY_ONLY, {@link android.net.wifi.p2p.WifiP2pConfig#PCC_MODE_CONNECTION_TYPE_LEGACY_ONLY}, {@link android.net.wifi.p2p.WifiP2pConfig#PCC_MODE_CONNECTION_TYPE_LEGACY_OR_R2}, or {@link android.net.wifi.p2p.WifiP2pConfig#PCC_MODE_CONNECTION_TYPE_R2_ONLY}
 */

public int getPccModeConnectionType() { throw new RuntimeException("Stub!"); }

/**
 * Query to check if the configuration is for authorizing a connection request
 * from the peer device. @see {@link android.net.wifi.p2p.WifiP2pConfig.Builder#setAuthorizeConnectionFromPeerEnabled(boolean) Builder.setAuthorizeConnectionFromPeerEnabled(boolean)}
 *
 * @return true if configured to authorize a connection request from the Peer device,
 * False otherwise.
 */

public boolean isAuthorizeConnectionFromPeerEnabled() { throw new RuntimeException("Stub!"); }

/**
 * Set the P2P Group Owner version.
 *
 * @param version The P2P Group Owner protocol version.

 * Value is android.net.wifi.p2p.WifiP2pConfig.P2P_DEFAULT_VERSION_1, {@link android.net.wifi.p2p.WifiP2pConfig#P2P_VERSION_1}, or {@link android.net.wifi.p2p.WifiP2pConfig#P2P_VERSION_2}
 */

public void setGroupOwnerVersion(int version) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.p2p.WifiP2pConfig> CREATOR;
static { CREATOR = null; }

/**
 * IP provisioning via IPv4 DHCP, when joining a group as a group client.
 */

public static final int GROUP_CLIENT_IP_PROVISIONING_MODE_IPV4_DHCP = 0; // 0x0

/**
 * IP provisioning via IPv6 link-local, when joining a group as a group client.
 */

public static final int GROUP_CLIENT_IP_PROVISIONING_MODE_IPV6_LINK_LOCAL = 1; // 0x1

/**
 * Allow the system to pick the operating frequency from the 2.4 GHz band.
 */

public static final int GROUP_OWNER_BAND_2GHZ = 1; // 0x1

/**
 * Allow the system to pick the operating frequency from the 5 GHz band.
 */

public static final int GROUP_OWNER_BAND_5GHZ = 2; // 0x2

/**
 * Allow the system to pick the operating frequency from the 6 GHz band.
 */

public static final int GROUP_OWNER_BAND_6GHZ = 3; // 0x3

/**
 * Allow the system to pick the operating frequency from all supported bands.
 */

public static final int GROUP_OWNER_BAND_AUTO = 0; // 0x0

/**
 * The system can choose an appropriate owner intent value, to be filled in the field
 * {@link #groupOwnerIntent}.
 */

public static final int GROUP_OWNER_INTENT_AUTO = -1; // 0xffffffff

/**
 * The most inclination to be a group owner, to be filled in the field
 * {@link #groupOwnerIntent}.
 */

public static final int GROUP_OWNER_INTENT_MAX = 15; // 0xf

/**
 * The least inclination to be a group owner, to be filled in the field
 * {@link #groupOwnerIntent}.
 */

public static final int GROUP_OWNER_INTENT_MIN = 0; // 0x0

/**
 * P2P Protocol version 1
 */

public static final int P2P_VERSION_1 = 0; // 0x0

/**
 * P2P Protocol version 2
 */

public static final int P2P_VERSION_2 = 1; // 0x1

/**
 * Legacy connection type.
 * <p>Group Owner: Configured to support WPA2-Personal connections.
 * <p>Group Client: Configured to connect to Group Owner using WPA2-Personal.
 */

public static final int PCC_MODE_CONNECTION_TYPE_LEGACY_ONLY = 0; // 0x0

/**
 * Wi-Fi Direct R1/R2 compatible mode connection type.
 * <p>Group Owner: Configured in WPA3-Personal Compatibility Mode to support WPA3-Personal and
 *              WPA2-Personal connections simultaneously.
 * <p>Group Client: Configured to connect to Group Owner using WPA3-Personal or WPA2-Personal.
 *               The system will choose WPA3-Personal if Group Owner support WPA3-Personal.
 */

public static final int PCC_MODE_CONNECTION_TYPE_LEGACY_OR_R2 = 1; // 0x1

/**
 * This configuration allows only Wi-Fi Direct R2 supported devices to establish connection.
 * <p>Group Owner: Configured to support WPA3-Personal connections.
 * <p>Group Client: Configured to connect to Group Owner using WPA3-Personal.
 */

public static final int PCC_MODE_CONNECTION_TYPE_R2_ONLY = 2; // 0x2

/**
 * The device MAC address uniquely identifies a Wi-Fi p2p device
 */

public java.lang.String deviceAddress = "";

/**
 * This is an integer value between {@link #GROUP_OWNER_INTENT_MIN} and
 * {@link #GROUP_OWNER_INTENT_MAX} where
 * {@link #GROUP_OWNER_INTENT_MIN} indicates the least inclination to be a group owner and
 * {@link #GROUP_OWNER_INTENT_MAX} indicates the highest inclination to be a group owner.
 *
 * A value of {@link #GROUP_OWNER_INTENT_AUTO} indicates the system can choose an appropriate
 * value.
 *
 * By default this field is set to {@link #GROUP_OWNER_INTENT_AUTO}.

 * <br>
 * Value is between 0 and 15 inclusive
 */

public int groupOwnerIntent = -1; // 0xffffffff

/**
 * Wi-Fi Protected Setup information
 */

public android.net.wifi.WpsInfo wps;
/**
 * Builder used to build {@link android.net.wifi.p2p.WifiP2pConfig WifiP2pConfig} objects for
 * creating or joining a group.
 *
 * The WifiP2pConfig can be constructed for two use-cases:
 * <ul>
 * <li>SSID + Passphrase are known: use {@link #setNetworkName(java.lang.String)} and
 *   {@link #setPassphrase(java.lang.String)}.</li>
 * <li>SSID or Passphrase is unknown, in such a case the MAC address must be known and
 *   specified using {@link #setDeviceAddress(android.net.MacAddress)}.</li>
 * </ul>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.net.wifi.p2p.WifiP2pConfig WifiP2pConfig} given the current requests made on the builder.
 * @return {@link android.net.wifi.p2p.WifiP2pConfig WifiP2pConfig} constructed based on builder method calls.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pConfig build() { throw new RuntimeException("Stub!"); }

/**
 * Specify that the group configuration be persisted (i.e. saved).
 * By default the group configuration will not be saved.
 * <p>
 *     Optional. false by default.
 *
 * @param persistent is this group persistent group.
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pConfig.Builder enablePersistentMode(boolean persistent) { throw new RuntimeException("Stub!"); }

/**
 * Specify that the configuration is to authorize a connection request from a peer device.
 * The MAC address of the peer device is specified using
 * {@link android.net.wifi.p2p.WifiP2pConfig.Builder#setDeviceAddress(android.net.MacAddress) WifiP2pConfig.Builder.setDeviceAddress(MacAddress)}.
 * <p>
 * Optional. false by default. The default configuration is to join a group or to initiate
 * a group formation.
 * <p>
 * This configuration is typically used in Bluetooth LE assisted P2P pairing protocol
 * defined in Wi-Fi Direct R2 specification, section 3.9. The collocated Bluetooth Provider
 * sends the pairing password to the peer device (Seeker) and direct the system to
 * authorize the connection request from the peer device using {@link android.net.wifi.p2p.WifiP2pManager#connect(android.net.wifi.p2p.WifiP2pManager.Channel,android.net.wifi.p2p.WifiP2pConfig,android.net.wifi.p2p.WifiP2pManager.ActionListener)  }. The device will then wait for the connection request
 * from the peer device.
 *
 * @param enabled true to authorize a connection request from the peer device, false to
 *                  let the device join a group or form a group.
 * @return The builder to facilitate chaining {@code builder.setXXX(..).setXXX(..)}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pConfig.Builder setAuthorizeConnectionFromPeerEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * Specify the peer's MAC address. If not set, the device will
 * try to find a peer whose SSID matches the network name as
 * specified by {@link #setNetworkName(java.lang.String)}. Specifying null will
 * reset the peer's MAC address to "02:00:00:00:00:00".
 * <p>
 *     Optional. "02:00:00:00:00:00" by default.
 *
 * <p> If the network name is not set, the peer's MAC address is mandatory.
 *
 * @param deviceAddress the peer's MAC address.
 * This value may be {@code null}.
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pConfig.Builder setDeviceAddress(@android.annotation.Nullable android.net.MacAddress deviceAddress) { throw new RuntimeException("Stub!"); }

/**
 * Specify the IP provisioning mode when joining a group as a group client. The IP
 * provisioning mode should be {@link #GROUP_CLIENT_IP_PROVISIONING_MODE_IPV4_DHCP} or
 * {@link #GROUP_CLIENT_IP_PROVISIONING_MODE_IPV6_LINK_LOCAL}.
 * <p>
 * When joining a group as group client using {@link android.net.wifi.p2p.WifiP2pManager#connect(android.net.wifi.p2p.WifiP2pManager.Channel,android.net.wifi.p2p.WifiP2pConfig,android.net.wifi.p2p.WifiP2pManager.ActionListener)  },
 * specifying {@link #GROUP_CLIENT_IP_PROVISIONING_MODE_IPV4_DHCP} directs the system to
 * assign a IPv4 to the group client using DHCP. Specifying
 * {@link #GROUP_CLIENT_IP_PROVISIONING_MODE_IPV6_LINK_LOCAL} directs the system to assign
 * a link-local IPv6 to the group client.
 * <p>
 *     Optional. {@link #GROUP_CLIENT_IP_PROVISIONING_MODE_IPV4_DHCP} by default.
 * <p>
 *
 * If {@link android.net.wifi.p2p.WifiP2pManager#isGroupOwnerIPv6LinkLocalAddressProvided() WifiP2pManager.isGroupOwnerIPv6LinkLocalAddressProvided()} is {@code true} and
 * {@link #GROUP_CLIENT_IP_PROVISIONING_MODE_IPV6_LINK_LOCAL} is used then the system will
 * discover the group owner's IPv6 link-local address and broadcast it using the
 * {@link android.net.wifi.p2p.WifiP2pManager#EXTRA_WIFI_P2P_INFO WifiP2pManager.EXTRA_WIFI_P2P_INFO} extra of the
 * {@link android.net.wifi.p2p.WifiP2pManager#WIFI_P2P_CONNECTION_CHANGED_ACTION WifiP2pManager.WIFI_P2P_CONNECTION_CHANGED_ACTION} broadcast. Otherwise, if
 * {@link android.net.wifi.p2p.WifiP2pManager#isGroupOwnerIPv6LinkLocalAddressProvided() WifiP2pManager.isGroupOwnerIPv6LinkLocalAddressProvided()} is
 * {@code false} then the group owner's IPv6 link-local address is not discovered and it is
 * the responsibility of the caller to obtain it in some other way, e.g. via out-of-band
 * communication.
 *
 * @param groupClientIpProvisioningMode the IP provisioning mode of the group client.
 *             This should be one of {@link #GROUP_CLIENT_IP_PROVISIONING_MODE_IPV4_DHCP},
 *             {@link #GROUP_CLIENT_IP_PROVISIONING_MODE_IPV6_LINK_LOCAL}.
 * Value is {@link android.net.wifi.p2p.WifiP2pConfig#GROUP_CLIENT_IP_PROVISIONING_MODE_IPV4_DHCP}, or {@link android.net.wifi.p2p.WifiP2pConfig#GROUP_CLIENT_IP_PROVISIONING_MODE_IPV6_LINK_LOCAL}
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 * This value cannot be {@code null}.
 * @see android.net.wifi.p2p.WifiP2pManager#isGroupOwnerIPv6LinkLocalAddressProvided()
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pConfig.Builder setGroupClientIpProvisioningMode(int groupClientIpProvisioningMode) { throw new RuntimeException("Stub!"); }

/**
 * Specify the band to use for creating the group or joining the group. The band should
 * be {@link #GROUP_OWNER_BAND_2GHZ}, {@link #GROUP_OWNER_BAND_5GHZ} or
 * {@link #GROUP_OWNER_BAND_6GHZ} or {@link #GROUP_OWNER_BAND_AUTO}.
 * <p>
 * When creating a group as Group Owner using {@link android.net.wifi.p2p.WifiP2pManager#createGroup(android.net.wifi.p2p.WifiP2pManager.Channel,android.net.wifi.p2p.WifiP2pConfig,android.net.wifi.p2p.WifiP2pManager.ActionListener)  },
 * specifying {@link #GROUP_OWNER_BAND_AUTO} allows the system to pick the operating
 * frequency from all supported bands.
 * Specifying {@link #GROUP_OWNER_BAND_2GHZ} or {@link #GROUP_OWNER_BAND_5GHZ} or
 * {@link #GROUP_OWNER_BAND_6GHZ}
 * only allows the system to pick the operating frequency in the specified band.
 * If the Group Owner cannot create a group in the specified band, the operation will fail.
 * <p>
 * When joining a group as Group Client using {@link android.net.wifi.p2p.WifiP2pManager#connect(android.net.wifi.p2p.WifiP2pManager.Channel,android.net.wifi.p2p.WifiP2pConfig,android.net.wifi.p2p.WifiP2pManager.ActionListener)  },
 * specifying {@link #GROUP_OWNER_BAND_AUTO} allows the system to scan all supported
 * frequencies to find the desired group. Specifying {@link #GROUP_OWNER_BAND_2GHZ} or
 * {@link #GROUP_OWNER_BAND_5GHZ} or {@link #GROUP_OWNER_BAND_6GHZ} only allows the
 * system to scan the specified band.
 * <p>
 *     {@link #setGroupOperatingBand(int)} and {@link #setGroupOperatingFrequency(int)} are
 *     mutually exclusive. Setting operating band and frequency both is invalid.
 * <p>
 *     Optional. {@link #GROUP_OWNER_BAND_AUTO} by default.
 *
 * @param band the operating band of the group.
 *             This should be one of {@link #GROUP_OWNER_BAND_AUTO},
 *             {@link #GROUP_OWNER_BAND_2GHZ}, {@link #GROUP_OWNER_BAND_5GHZ},
 *             {@link #GROUP_OWNER_BAND_6GHZ}.
 * Value is {@link android.net.wifi.p2p.WifiP2pConfig#GROUP_OWNER_BAND_AUTO}, {@link android.net.wifi.p2p.WifiP2pConfig#GROUP_OWNER_BAND_2GHZ}, {@link android.net.wifi.p2p.WifiP2pConfig#GROUP_OWNER_BAND_5GHZ}, or {@link android.net.wifi.p2p.WifiP2pConfig#GROUP_OWNER_BAND_6GHZ}
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pConfig.Builder setGroupOperatingBand(int band) { throw new RuntimeException("Stub!"); }

/**
 * Specify the frequency, in MHz, to use for creating the group or joining the group.
 * <p>
 * When creating a group as Group Owner using {@link android.net.wifi.p2p.WifiP2pManager#createGroup(android.net.wifi.p2p.WifiP2pManager.Channel,android.net.wifi.p2p.WifiP2pConfig,android.net.wifi.p2p.WifiP2pManager.ActionListener) WifiP2pManager.createGroup(
 * WifiP2pManager.Channel, WifiP2pConfig, WifiP2pManager.ActionListener)},
 * specifying a frequency only allows the system to pick the specified frequency.
 * If the Group Owner cannot create a group at the specified frequency,
 * the operation will fail.
 * When not specifying a frequency, it allows the system to pick operating frequency
 * from all supported bands.
 * <p>
 * When joining a group as Group Client using {@link android.net.wifi.p2p.WifiP2pManager#connect(android.net.wifi.p2p.WifiP2pManager.Channel,android.net.wifi.p2p.WifiP2pConfig,android.net.wifi.p2p.WifiP2pManager.ActionListener) WifiP2pManager.connect(
 * WifiP2pManager.Channel, WifiP2pConfig, WifiP2pManager.ActionListener)},
 * specifying a frequency only allows the system to scan the specified frequency.
 * If the frequency is not supported or invalid, the operation will fail.
 * When not specifying a frequency, it allows the system to scan all supported
 * frequencies to find the desired group.
 * <p>
 *     {@link #setGroupOperatingBand(int)} and {@link #setGroupOperatingFrequency(int)} are
 *     mutually exclusive. Setting operating band and frequency both is invalid.
 * <p>
 *     Optional. 0 by default.
 *
 * @param frequency the operating frequency of the group.
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pConfig.Builder setGroupOperatingFrequency(int frequency) { throw new RuntimeException("Stub!"); }

/**
 * Specify the network name, a.k.a. group name,
 * for creating or joining a group.
 * <p>
 * A network name shall begin with "DIRECT-xy". x and y are selected
 * from the following character set: upper case letters, lower case
 * letters and numbers. Any byte values allowed for an SSID according to
 * IEEE802.11-2012 [1] may be included after the string "DIRECT-xy"
 * (including none).
 * <p>
 *     Must be called - an empty network name or an network name
 *     not conforming to the P2P Group ID naming rule is not valid.
 *
 * @param networkName network name of a group.
 * This value cannot be {@code null}.
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pConfig.Builder setNetworkName(@android.annotation.NonNull java.lang.String networkName) { throw new RuntimeException("Stub!"); }

/**
 * Set the pairing bootstrapping configuration for connecting using P2P pairing
 * Protocol.
 *
 * @param config See {@link android.net.wifi.p2p.WifiP2pPairingBootstrappingConfig WifiP2pPairingBootstrappingConfig}
 * This value cannot be {@code null}.
 * @return The builder to facilitate chaining {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pConfig.Builder setPairingBootstrappingConfig(@android.annotation.NonNull android.net.wifi.p2p.WifiP2pPairingBootstrappingConfig config) { throw new RuntimeException("Stub!"); }

/**
 * Specify the passphrase for creating or joining a group.
 * <p>
 * The passphrase must be an ASCII string whose length is,
 * 1. Between 8 and 63 for {@link #PCC_MODE_CONNECTION_TYPE_LEGACY_ONLY} and
 *    {@link #PCC_MODE_CONNECTION_TYPE_LEGACY_OR_R2}.
 * 2. Less than 128 for {@link #PCC_MODE_CONNECTION_TYPE_R2_ONLY}.
 *
 * <p>
 *     Must be called - an empty passphrase is not valid.
 *
 * @param passphrase the passphrase of a group.
 * This value cannot be {@code null}.
 * @return The builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pConfig.Builder setPassphrase(@android.annotation.NonNull java.lang.String passphrase) { throw new RuntimeException("Stub!"); }

/**
 * Specifies the PCC Mode connection type.
 *
 * @param connectionType One of the {@code PCC_MODE_CONNECTION_TYPE_*}.
 * Value is android.net.wifi.p2p.WifiP2pConfig.PCC_MODE_DEFAULT_CONNECTION_TYPE_LEGACY_ONLY, {@link android.net.wifi.p2p.WifiP2pConfig#PCC_MODE_CONNECTION_TYPE_LEGACY_ONLY}, {@link android.net.wifi.p2p.WifiP2pConfig#PCC_MODE_CONNECTION_TYPE_LEGACY_OR_R2}, or {@link android.net.wifi.p2p.WifiP2pConfig#PCC_MODE_CONNECTION_TYPE_R2_ONLY}
 * @return Builder for chaining.
 *
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException when the connectionType is invalid.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pConfig.Builder setPccModeConnectionType(int connectionType) { throw new RuntimeException("Stub!"); }
}

}

