/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.p2p;

import android.os.Build;
import android.os.Parcelable;

/**
 * A class representing a Wi-Fi P2P USD based service advertisement configuration for advertising
 * the services.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiP2pUsdBasedLocalServiceAdvertisementConfig implements android.os.Parcelable {

WifiP2pUsdBasedLocalServiceAdvertisementConfig() { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Get the frequency on which the service is advertised.

 * @return Value is 0 or greater
 */

public int getFrequencyMhz() { throw new RuntimeException("Stub!"); }

/**
 * Generates a string of all the defined elements.
 *
 * @return a compiled string representing all elements
 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Implement the Parcelable interface
 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Implement the Parcelable interface */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.p2p.WifiP2pUsdBasedLocalServiceAdvertisementConfig> CREATOR;
static { CREATOR = null; }
/**
 * Builder for {@link android.net.wifi.p2p.WifiP2pUsdBasedLocalServiceAdvertisementConfig WifiP2pUsdBasedLocalServiceAdvertisementConfig}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a Builder with default values.
 */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.net.wifi.p2p.WifiP2pUsdBasedLocalServiceAdvertisementConfig WifiP2pUsdBasedLocalServiceAdvertisementConfig} given the
 * current requests made on the builder.
 * @return {@link android.net.wifi.p2p.WifiP2pUsdBasedLocalServiceAdvertisementConfig WifiP2pUsdBasedLocalServiceAdvertisementConfig} constructed based on
 * builder method calls.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pUsdBasedLocalServiceAdvertisementConfig build() { throw new RuntimeException("Stub!"); }

/**
 * Specifies the frequency requested for advertising the service.
 *
 * @param frequencyMhz The requested frequency on which the service needs to be advertised.
 *                     If not set, the default frequency is
 *                     {@link #USD_DEFAULT_DISCOVERY_CHANNEL_MHZ} MHz.
 *
 * Value is 1 or greater
 * @return The builder to facilitate chaining {@code builder.setXXX(..).setXXX(..)}.
 *
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.p2p.WifiP2pUsdBasedLocalServiceAdvertisementConfig.Builder setFrequencyMhz(int frequencyMhz) { throw new RuntimeException("Stub!"); }
}

}

