/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.rtt;


/**
 * Secure ranging configuration.
 * Refer IEEE Std 802.11az-2022, section 12. Security.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SecureRangingConfig implements android.os.Parcelable {

SecureRangingConfig() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns Pre-association security negotiation (PASN) configuration used for secure
 * ranging.
 *
 * @return {@link android.net.wifi.rtt.PasnConfig PasnConfig} object.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.PasnConfig getPasnConfig() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Returns whether ranging frame protection is enabled or not.
 */

public boolean isRangingFrameProtectionEnabled() { throw new RuntimeException("Stub!"); }

/**
 * Returns whether secure HE-LTF is enabled or not.
 */

public boolean isSecureHeLtfEnabled() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.rtt.SecureRangingConfig> CREATOR;
static { CREATOR = null; }
/**
 * Builder for {@link android.net.wifi.rtt.SecureRangingConfig SecureRangingConfig}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Builder constructor.
 *
 * @param pasnConfig PASN configuration

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.net.wifi.rtt.PasnConfig pasnConfig) { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@code SecureRangingConfig} built from the parameters previously set.
 *
 * @return a {@code SecureRangingConfig} built with parameters of this
 * {@code SecureRangingConfig.Builder}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.SecureRangingConfig build() { throw new RuntimeException("Stub!"); }

/**
 * Enable or disable ranging frame protection  and returns a reference to this Builder
 * enabling method chaining. If not set, ranging frame protection is enabled.
 *
 * @param enableRangingFrameProtection the {@code enableRangingFrameProtection} to set
 * @return a reference to this Builder

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.SecureRangingConfig.Builder setRangingFrameProtectionEnabled(boolean enableRangingFrameProtection) { throw new RuntimeException("Stub!"); }

/**
 * Enable or disable secure HE-LTF and returns a reference to this Builder enabling
 * method chaining. If not set, secure HE-LTF is enabled.
 *
 * @param enableSecureHeLtf the {@code enableSecureHeLtf} to set
 * @return a reference to this Builder

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.SecureRangingConfig.Builder setSecureHeLtfEnabled(boolean enableSecureHeLtf) { throw new RuntimeException("Stub!"); }
}

}

