/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.rtt;

import android.net.wifi.ScanResult;

/**
 * Defines the configuration of an IEEE 802.11mc Responder. The Responder may be an Access Point
 * (AP), a Wi-Fi Aware device, or a manually configured Responder.
 * <p>
 * A Responder configuration may be constructed from a {@link android.net.wifi.ScanResult ScanResult} or manually (with the
 * data obtained out-of-band from a peer).
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ResponderConfig implements android.os.Parcelable {

ResponderConfig() { throw new RuntimeException("Stub!"); }

/**
 * Creates a Responder configuration from a {@link android.net.wifi.ScanResult ScanResult} corresponding to an Access
 * Point (AP), which can be obtained from {@link android.net.wifi.WifiManager#getScanResults()}.
 
 * @param scanResult This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.net.wifi.rtt.ResponderConfig fromScanResult(@android.annotation.NonNull android.net.wifi.ScanResult scanResult) { throw new RuntimeException("Stub!"); }

/**
 * @return the MAC address of the responder

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.MacAddress getMacAddress() { throw new RuntimeException("Stub!"); }

/**
 * @return true if the Responder supports the 802.11mc protocol, false otherwise.
 */

public boolean is80211mcSupported() { throw new RuntimeException("Stub!"); }

/**
 * AP Channel bandwidth; one of {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_20MHZ ScanResult#CHANNEL_WIDTH_20MHZ},
 * {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_40MHZ ScanResult#CHANNEL_WIDTH_40MHZ},
 * {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_80MHZ ScanResult#CHANNEL_WIDTH_80MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_160MHZ ScanResult#CHANNEL_WIDTH_160MHZ},
 * {@link android.net.wifi.ScanResult #CHANNEL_WIDTH_80MHZ_PLUS_MHZ} or {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_320MHZ ScanResult#CHANNEL_WIDTH_320MHZ}.
 *
 * @return the bandwidth repsentation of the Wi-Fi channel

 * Value is {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_20MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_40MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_80MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_160MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_80MHZ_PLUS_MHZ}, or {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_320MHZ}
 */

public int getChannelWidth() { throw new RuntimeException("Stub!"); }

/**
 * @return the frequency in MHz of the Wi-Fi channel

 * Value is 0 or greater
 */

public int getFrequencyMhz() { throw new RuntimeException("Stub!"); }

/**
 * If the Access Point (AP) bandwidth is 20 MHz, 0 MHz is returned.
 * If the AP use 40, 80 or 160 MHz, this is the center frequency (in MHz).
 * if the AP uses 80 + 80 MHz, this is the center frequency of the first segment (in MHz).
 *
 * @return the center frequency in MHz of the first channel segment

 * Value is 0 or greater
 */

public int getCenterFreq0Mhz() { throw new RuntimeException("Stub!"); }

/**
 * If the Access Point (AP) bandwidth is 80 + 80 MHz, this param is not used and returns 0.
 * If the AP uses 80 + 80 MHz, this is the center frequency of the second segment in MHz.
 *
 * @return the center frequency in MHz of the second channel segment (if used)

 * Value is 0 or greater
 */

public int getCenterFreq1Mhz() { throw new RuntimeException("Stub!"); }

/**
 * Get the preamble type of the channel.
 *
 * @return the preamble used for this channel

 * Value is {@link android.net.wifi.ScanResult#PREAMBLE_LEGACY}, {@link android.net.wifi.ScanResult#PREAMBLE_HT}, {@link android.net.wifi.ScanResult#PREAMBLE_VHT}, {@link android.net.wifi.ScanResult#PREAMBLE_HE}, or {@link android.net.wifi.ScanResult#PREAMBLE_EHT}
 */

public int getPreamble() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.rtt.ResponderConfig> CREATOR;
static { CREATOR = null; }
/**
 * Builder class used to construct {@link android.net.wifi.rtt.ResponderConfig ResponderConfig} objects.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the Responder MAC Address.
 *
 * @param macAddress the phyical address of the responder
 * This value cannot be {@code null}.
 * @return the builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder setMacAddress(@android.annotation.NonNull android.net.MacAddress macAddress) { throw new RuntimeException("Stub!"); }

/**
 * Sets an indication the access point can to respond to the two-sided Wi-Fi RTT protocol,
 * but, if false, indicates only one-sided Wi-Fi RTT is possible.
 *
 * @param supports80211mc the ability to support the Wi-Fi RTT protocol
 * @return the builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder set80211mcSupported(boolean supports80211mc) { throw new RuntimeException("Stub!"); }

/**
 * Sets the channel bandwidth in MHz.
 *
 * @param channelWidth the bandwidth of the channel in MHz
 * Value is {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_20MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_40MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_80MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_160MHZ}, {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_80MHZ_PLUS_MHZ}, or {@link android.net.wifi.ScanResult#CHANNEL_WIDTH_320MHZ}
 * @return the builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder setChannelWidth(int channelWidth) { throw new RuntimeException("Stub!"); }

/**
 * Sets the frequency of the channel in MHz.
 * <p>
 * Note: The frequency is used as a hint, and the underlying WiFi subsystem may use it, or
 * select an alternate if its own connectivity scans have determined the frequency of the
 * access point has changed.
 * </p>
 *
 * @param frequency the frequency of the channel in MHz
 * Value is 0 or greater
 * @return the builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder setFrequencyMhz(int frequency) { throw new RuntimeException("Stub!"); }

/**
 * Sets the center frequency in MHz of the first segment of the channel.
 * <p>
 * Note: The frequency is used as a hint, and the underlying WiFi subsystem may use it, or
 * select an alternate if its own connectivity scans have determined the frequency of the
 * access point has changed.
 * </p>
 *
 * @param centerFreq0 the center frequency in MHz of first channel segment
 * Value is 0 or greater
 * @return the builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder setCenterFreq0Mhz(int centerFreq0) { throw new RuntimeException("Stub!"); }

/**
 * Sets the center frequency in MHz of the second segment of the channel, if used.
 * <p>
 * Note: The frequency is used as a hint, and the underlying WiFi subsystem may use it, or
 * select an alternate if its own connectivity scans have determined the frequency of the
 * access point has changed.
 * </p>
 *
 * @param centerFreq1 the center frequency in MHz of second channel segment
 * Value is 0 or greater
 * @return the builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder setCenterFreq1Mhz(int centerFreq1) { throw new RuntimeException("Stub!"); }

/**
 * Sets the preamble encoding for the protocol.
 *
 * @param preamble the preamble encoding
 * Value is {@link android.net.wifi.ScanResult#PREAMBLE_LEGACY}, {@link android.net.wifi.ScanResult#PREAMBLE_HT}, {@link android.net.wifi.ScanResult#PREAMBLE_VHT}, {@link android.net.wifi.ScanResult#PREAMBLE_HE}, or {@link android.net.wifi.ScanResult#PREAMBLE_EHT}
 * @return the builder to facilitate chaining
 *         {@code builder.setXXX(..).setXXX(..)}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder setPreamble(int preamble) { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.net.wifi.rtt.ResponderConfig ResponderConfig} given the current configurations made on the builder.
 * @return an instance of {@link android.net.wifi.rtt.ResponderConfig ResponderConfig}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig build() { throw new RuntimeException("Stub!"); }
}

}

