/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class WifiManager {

WifiManager() { throw new RuntimeException("Stub!"); }

@Deprecated
public java.util.List<android.net.wifi.WifiConfiguration> getConfiguredNetworks() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.wifi.WifiConfiguration> getCallerConfiguredNetworks() { throw new RuntimeException("Stub!"); }

public java.util.List<android.net.wifi.WifiConfiguration> getPrivilegedConfiguredNetworks() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.wifi.WifiConfiguration getPrivilegedConnectedNetwork() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.util.Pair<android.net.wifi.WifiConfiguration,java.util.Map<java.lang.Integer,java.util.List<android.net.wifi.ScanResult>>>> getAllMatchingWifiConfigs(@android.annotation.NonNull java.util.List<android.net.wifi.ScanResult> scanResults) { throw new RuntimeException("Stub!"); }

public void setScreenOnScanSchedule(@android.annotation.Nullable java.util.List<android.net.wifi.WifiManager.ScreenOnScanSchedule> screenOnScanSchedule) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.wifi.WifiConfiguration> getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(@android.annotation.NonNull java.util.List<android.net.wifi.ScanResult> scanResults) { throw new RuntimeException("Stub!"); }

public void setSsidsAllowlist(@android.annotation.NonNull java.util.Set<android.net.wifi.WifiSsid> ssids) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<android.net.wifi.WifiSsid> getSsidsAllowlist() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<android.net.wifi.hotspot2.OsuProvider,java.util.List<android.net.wifi.ScanResult>> getMatchingOsuProviders(@android.annotation.Nullable java.util.List<android.net.wifi.ScanResult> scanResults) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<android.net.wifi.hotspot2.OsuProvider,android.net.wifi.hotspot2.PasspointConfiguration> getMatchingPasspointConfigsForOsuProviders(@android.annotation.NonNull java.util.Set<android.net.wifi.hotspot2.OsuProvider> osuProviders) { throw new RuntimeException("Stub!"); }

@Deprecated
public int addNetwork(android.net.wifi.WifiConfiguration config) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.WifiManager.AddNetworkResult addNetworkPrivileged(@android.annotation.NonNull android.net.wifi.WifiConfiguration config) { throw new RuntimeException("Stub!"); }

@Deprecated
public int updateNetwork(android.net.wifi.WifiConfiguration config) { throw new RuntimeException("Stub!"); }

public void registerNetworkRequestMatchCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.NetworkRequestMatchCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterNetworkRequestMatchCallback(@android.annotation.NonNull android.net.wifi.WifiManager.NetworkRequestMatchCallback callback) { throw new RuntimeException("Stub!"); }

public void removeAppState(int targetAppUid, @android.annotation.NonNull java.lang.String targetAppPackageName) { throw new RuntimeException("Stub!"); }

public int addNetworkSuggestions(@android.annotation.NonNull java.util.List<android.net.wifi.WifiNetworkSuggestion> networkSuggestions) { throw new RuntimeException("Stub!"); }

public int removeNetworkSuggestions(@android.annotation.NonNull java.util.List<android.net.wifi.WifiNetworkSuggestion> networkSuggestions) { throw new RuntimeException("Stub!"); }

public int removeNetworkSuggestions(@android.annotation.NonNull java.util.List<android.net.wifi.WifiNetworkSuggestion> networkSuggestions, int action) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.wifi.WifiNetworkSuggestion> getNetworkSuggestions() { throw new RuntimeException("Stub!"); }

public int getMaxNumberOfNetworkSuggestionsPerApp() { throw new RuntimeException("Stub!"); }

public void addOrUpdatePasspointConfiguration(android.net.wifi.hotspot2.PasspointConfiguration config) { throw new RuntimeException("Stub!"); }

@Deprecated
public void removePasspointConfiguration(java.lang.String fqdn) { throw new RuntimeException("Stub!"); }

@Deprecated
public java.util.List<android.net.wifi.hotspot2.PasspointConfiguration> getPasspointConfigurations() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean removeNetwork(int netId) { throw new RuntimeException("Stub!"); }

public boolean removeNonCallerConfiguredNetworks() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean enableNetwork(int netId, boolean attemptConnect) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean disableNetwork(int netId) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean disconnect() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean reconnect() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean reassociate() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean pingSupplicant() { throw new RuntimeException("Stub!"); }

public boolean isP2pSupported() { throw new RuntimeException("Stub!"); }

public boolean isPortableHotspotSupported() { throw new RuntimeException("Stub!"); }

public boolean isWifiScannerSupported() { throw new RuntimeException("Stub!"); }

public boolean isStaApConcurrencySupported() { throw new RuntimeException("Stub!"); }

public boolean isStaConcurrencyForLocalOnlyConnectionsSupported() { throw new RuntimeException("Stub!"); }

public boolean isMakeBeforeBreakWifiSwitchingSupported() { throw new RuntimeException("Stub!"); }

public boolean isStaConcurrencyForMultiInternetSupported() { throw new RuntimeException("Stub!"); }

public boolean isStaConcurrencyForRestrictedConnectionsSupported() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean isDeviceToDeviceRttSupported() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean isDeviceToApRttSupported() { throw new RuntimeException("Stub!"); }

public boolean isPreferredNetworkOffloadSupported() { throw new RuntimeException("Stub!"); }

public boolean isTdlsSupported() { throw new RuntimeException("Stub!"); }

public boolean isEnhancedPowerReportingSupported() { throw new RuntimeException("Stub!"); }

public boolean isConnectedMacRandomizationSupported() { throw new RuntimeException("Stub!"); }

public boolean isApMacRandomizationSupported() { throw new RuntimeException("Stub!"); }

public boolean is24GHzBandSupported() { throw new RuntimeException("Stub!"); }

public boolean is5GHzBandSupported() { throw new RuntimeException("Stub!"); }

public boolean is60GHzBandSupported() { throw new RuntimeException("Stub!"); }

public boolean is6GHzBandSupported() { throw new RuntimeException("Stub!"); }

public boolean isWifiStandardSupported(int standard) { throw new RuntimeException("Stub!"); }

public boolean isStaBridgedApConcurrencySupported() { throw new RuntimeException("Stub!"); }

public boolean isBridgedApConcurrencySupported() { throw new RuntimeException("Stub!"); }

public void getWifiActivityEnergyInfoAsync(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.OnWifiActivityEnergyInfoListener listener) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean startScan() { throw new RuntimeException("Stub!"); }

public boolean startScan(android.os.WorkSource workSource) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.net.wifi.WifiInfo getConnectionInfo() { throw new RuntimeException("Stub!"); }

public java.util.List<android.net.wifi.ScanResult> getScanResults() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<android.net.wifi.WifiNetworkSuggestion,java.util.List<android.net.wifi.ScanResult>> getMatchingScanResults(@android.annotation.NonNull java.util.List<android.net.wifi.WifiNetworkSuggestion> networkSuggestionsToMatch, @android.annotation.Nullable java.util.List<android.net.wifi.ScanResult> scanResults) { throw new RuntimeException("Stub!"); }

public void setScanAlwaysAvailable(boolean isAvailable) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean isScanAlwaysAvailable() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean saveConfiguration() { throw new RuntimeException("Stub!"); }

public void registerActiveCountryCodeChangedCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.ActiveCountryCodeChangedCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterActiveCountryCodeChangedCallback(@android.annotation.NonNull android.net.wifi.WifiManager.ActiveCountryCodeChangedCallback callback) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getCountryCode() { throw new RuntimeException("Stub!"); }

public void setOverrideCountryCode(@android.annotation.NonNull java.lang.String country) { throw new RuntimeException("Stub!"); }

public void clearOverrideCountryCode() { throw new RuntimeException("Stub!"); }

public void setDefaultCountryCode(@android.annotation.NonNull java.lang.String country) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.net.DhcpInfo getDhcpInfo() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean setWifiEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

public void registerSubsystemRestartTrackingCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.SubsystemRestartTrackingCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterSubsystemRestartTrackingCallback(@android.annotation.NonNull android.net.wifi.WifiManager.SubsystemRestartTrackingCallback callback) { throw new RuntimeException("Stub!"); }

public void restartWifiSubsystem() { throw new RuntimeException("Stub!"); }

public int getWifiState() { throw new RuntimeException("Stub!"); }

public boolean isWifiEnabled() { throw new RuntimeException("Stub!"); }

@Deprecated
public static int calculateSignalLevel(int rssi, int numLevels) { throw new RuntimeException("Stub!"); }

public int calculateSignalLevel(int rssi) { throw new RuntimeException("Stub!"); }

public int getMaxSignalLevel() { throw new RuntimeException("Stub!"); }

public static int compareSignalLevel(int rssiA, int rssiB) { throw new RuntimeException("Stub!"); }

public void updateInterfaceIpState(@android.annotation.Nullable java.lang.String ifaceName, int mode) { throw new RuntimeException("Stub!"); }

public void setCoexUnsafeChannels(@android.annotation.NonNull java.util.List<android.net.wifi.CoexUnsafeChannel> unsafeChannels, int restrictions) { throw new RuntimeException("Stub!"); }

public void registerCoexCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.CoexCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterCoexCallback(@android.annotation.NonNull android.net.wifi.WifiManager.CoexCallback callback) { throw new RuntimeException("Stub!"); }

public boolean startTetheredHotspot(@android.annotation.Nullable android.net.wifi.SoftApConfiguration softApConfig) { throw new RuntimeException("Stub!"); }

public boolean stopSoftAp() { throw new RuntimeException("Stub!"); }

public void startLocalOnlyHotspot(android.net.wifi.WifiManager.LocalOnlyHotspotCallback callback, @android.annotation.Nullable android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void startLocalOnlyHotspot(@android.annotation.NonNull android.net.wifi.SoftApConfiguration config, @android.annotation.Nullable java.util.concurrent.Executor executor, @android.annotation.Nullable android.net.wifi.WifiManager.LocalOnlyHotspotCallback callback) { throw new RuntimeException("Stub!"); }

public void registerLocalOnlyHotspotSoftApCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.SoftApCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterLocalOnlyHotspotSoftApCallback(@android.annotation.NonNull android.net.wifi.WifiManager.SoftApCallback callback) { throw new RuntimeException("Stub!"); }

public int getWifiApState() { throw new RuntimeException("Stub!"); }

public boolean isWifiApEnabled() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public android.net.wifi.WifiConfiguration getWifiApConfiguration() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration getSoftApConfiguration() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean setWifiApConfiguration(android.net.wifi.WifiConfiguration wifiConfig) { throw new RuntimeException("Stub!"); }

public boolean setSoftApConfiguration(@android.annotation.NonNull android.net.wifi.SoftApConfiguration softApConfig) { throw new RuntimeException("Stub!"); }

public void setTdlsEnabled(java.net.InetAddress remoteIPAddress, boolean enable) { throw new RuntimeException("Stub!"); }

public void setTdlsEnabledWithMacAddress(java.lang.String remoteMacAddress, boolean enable) { throw new RuntimeException("Stub!"); }

public void registerSoftApCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.SoftApCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterSoftApCallback(@android.annotation.NonNull android.net.wifi.WifiManager.SoftApCallback callback) { throw new RuntimeException("Stub!"); }

public void connect(@android.annotation.NonNull android.net.wifi.WifiConfiguration config, @android.annotation.Nullable android.net.wifi.WifiManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void connect(int networkId, @android.annotation.Nullable android.net.wifi.WifiManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void startRestrictingAutoJoinToSubscriptionId(int subscriptionId) { throw new RuntimeException("Stub!"); }

public void stopRestrictingAutoJoinToSubscriptionId() { throw new RuntimeException("Stub!"); }

public void save(@android.annotation.NonNull android.net.wifi.WifiConfiguration config, @android.annotation.Nullable android.net.wifi.WifiManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void forget(int netId, @android.annotation.Nullable android.net.wifi.WifiManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

@Deprecated
public void disable(int netId, @android.annotation.Nullable android.net.wifi.WifiManager.ActionListener listener) { throw new RuntimeException("Stub!"); }

public void allowAutojoinGlobal(boolean allowAutojoin) { throw new RuntimeException("Stub!"); }

public void queryAutojoinGlobal(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<java.lang.Boolean> resultsCallback) { throw new RuntimeException("Stub!"); }

public void allowAutojoin(int netId, boolean allowAutojoin) { throw new RuntimeException("Stub!"); }

public void allowAutojoinPasspoint(@android.annotation.NonNull java.lang.String fqdn, boolean allowAutojoin) { throw new RuntimeException("Stub!"); }

public void setMacRandomizationSettingPasspointEnabled(@android.annotation.NonNull java.lang.String fqdn, boolean enable) { throw new RuntimeException("Stub!"); }

public void setPasspointMeteredOverride(@android.annotation.NonNull java.lang.String fqdn, int meteredOverride) { throw new RuntimeException("Stub!"); }

public void disableEphemeralNetwork(@android.annotation.NonNull java.lang.String network) { throw new RuntimeException("Stub!"); }

@Deprecated
public void startWps(android.net.wifi.WpsInfo config, android.net.wifi.WifiManager.WpsCallback listener) { throw new RuntimeException("Stub!"); }

@Deprecated
public void cancelWps(android.net.wifi.WifiManager.WpsCallback listener) { throw new RuntimeException("Stub!"); }

public android.net.wifi.WifiManager.WifiLock createWifiLock(int lockType, java.lang.String tag) { throw new RuntimeException("Stub!"); }

@Deprecated
public android.net.wifi.WifiManager.WifiLock createWifiLock(java.lang.String tag) { throw new RuntimeException("Stub!"); }

public android.net.wifi.WifiManager.MulticastLock createMulticastLock(java.lang.String tag) { throw new RuntimeException("Stub!"); }

public void setVerboseLoggingEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

public void setVerboseLoggingLevel(int verbose) { throw new RuntimeException("Stub!"); }

public boolean isVerboseLoggingEnabled() { throw new RuntimeException("Stub!"); }

public int getVerboseLoggingLevel() { throw new RuntimeException("Stub!"); }

public void factoryReset() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.Network getCurrentNetwork() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] retrieveBackupData() { throw new RuntimeException("Stub!"); }

public void restoreBackupData(@android.annotation.NonNull byte[] data) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] retrieveSoftApBackupData() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.wifi.SoftApConfiguration restoreSoftApBackupData(@android.annotation.NonNull byte[] data) { throw new RuntimeException("Stub!"); }

public void restoreSupplicantBackupData(@android.annotation.NonNull byte[] supplicantData, @android.annotation.NonNull byte[] ipConfigData) { throw new RuntimeException("Stub!"); }

public void startSubscriptionProvisioning(@android.annotation.NonNull android.net.wifi.hotspot2.OsuProvider provider, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.hotspot2.ProvisioningCallback callback) { throw new RuntimeException("Stub!"); }

public void registerTrafficStateCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.TrafficStateCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterTrafficStateCallback(@android.annotation.NonNull android.net.wifi.WifiManager.TrafficStateCallback callback) { throw new RuntimeException("Stub!"); }

public boolean isWpa3SaeSupported() { throw new RuntimeException("Stub!"); }

public boolean isWpa3SuiteBSupported() { throw new RuntimeException("Stub!"); }

public boolean isEnhancedOpenSupported() { throw new RuntimeException("Stub!"); }

public boolean isEasyConnectSupported() { throw new RuntimeException("Stub!"); }

public boolean isEasyConnectEnrolleeResponderModeSupported() { throw new RuntimeException("Stub!"); }

public boolean isWapiSupported() { throw new RuntimeException("Stub!"); }

public boolean isWpa3SaePublicKeySupported() { throw new RuntimeException("Stub!"); }

public boolean isPasspointTermsAndConditionsSupported() { throw new RuntimeException("Stub!"); }

public boolean isWpa3SaeH2eSupported() { throw new RuntimeException("Stub!"); }

public boolean isWifiDisplayR2Supported() { throw new RuntimeException("Stub!"); }

public boolean isDecoratedIdentitySupported() { throw new RuntimeException("Stub!"); }

public boolean isTrustOnFirstUseSupported() { throw new RuntimeException("Stub!"); }

public boolean isEasyConnectDppAkmSupported() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] getFactoryMacAddresses() { throw new RuntimeException("Stub!"); }

public void setDeviceMobilityState(int state) { throw new RuntimeException("Stub!"); }

public void startEasyConnectAsConfiguratorInitiator(@android.annotation.NonNull java.lang.String enrolleeUri, int selectedNetworkId, int enrolleeNetworkRole, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.EasyConnectStatusCallback callback) { throw new RuntimeException("Stub!"); }

public void startEasyConnectAsEnrolleeInitiator(@android.annotation.NonNull java.lang.String configuratorUri, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.EasyConnectStatusCallback callback) { throw new RuntimeException("Stub!"); }

public void startEasyConnectAsEnrolleeResponder(@android.annotation.Nullable java.lang.String deviceInfo, int curve, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.EasyConnectStatusCallback callback) { throw new RuntimeException("Stub!"); }

public static int getEasyConnectMaxAllowedResponderDeviceInfoLength() { throw new RuntimeException("Stub!"); }

public void stopEasyConnectSession() { throw new RuntimeException("Stub!"); }

public void addOnWifiUsabilityStatsListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.OnWifiUsabilityStatsListener listener) { throw new RuntimeException("Stub!"); }

public void removeOnWifiUsabilityStatsListener(@android.annotation.NonNull android.net.wifi.WifiManager.OnWifiUsabilityStatsListener listener) { throw new RuntimeException("Stub!"); }

public void updateWifiUsabilityScore(int seqNum, int score, int predictionHorizonSec) { throw new RuntimeException("Stub!"); }

public void registerScanResultsCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.ScanResultsCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterScanResultsCallback(@android.annotation.NonNull android.net.wifi.WifiManager.ScanResultsCallback callback) { throw new RuntimeException("Stub!"); }

public void addWifiVerboseLoggingStatusChangedListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.WifiVerboseLoggingStatusChangedListener listener) { throw new RuntimeException("Stub!"); }

public void removeWifiVerboseLoggingStatusChangedListener(@android.annotation.NonNull android.net.wifi.WifiManager.WifiVerboseLoggingStatusChangedListener listener) { throw new RuntimeException("Stub!"); }

public void addSuggestionConnectionStatusListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.SuggestionConnectionStatusListener listener) { throw new RuntimeException("Stub!"); }

public void removeSuggestionConnectionStatusListener(@android.annotation.NonNull android.net.wifi.WifiManager.SuggestionConnectionStatusListener listener) { throw new RuntimeException("Stub!"); }

public void setExternalPnoScanRequest(@android.annotation.NonNull java.util.List<android.net.wifi.WifiSsid> ssids, @android.annotation.Nullable int[] frequencies, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.PnoScanResultsCallback callback) { throw new RuntimeException("Stub!"); }

public void clearExternalPnoScanRequest() { throw new RuntimeException("Stub!"); }

public void getLastCallerInfoForApi(int apiType, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.BiConsumer<java.lang.String,java.lang.Boolean> resultsCallback) { throw new RuntimeException("Stub!"); }

public boolean setWifiConnectedNetworkScorer(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.WifiConnectedNetworkScorer scorer) { throw new RuntimeException("Stub!"); }

public void clearWifiConnectedNetworkScorer() { throw new RuntimeException("Stub!"); }

public void setScanThrottleEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

public boolean isScanThrottleEnabled() { throw new RuntimeException("Stub!"); }

public void setAutoWakeupEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

public boolean isAutoWakeupEnabled() { throw new RuntimeException("Stub!"); }

public void setCarrierNetworkOffloadEnabled(int subscriptionId, boolean merged, boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean isCarrierNetworkOffloadEnabled(int subscriptionId, boolean merged) { throw new RuntimeException("Stub!"); }

public void addSuggestionUserApprovalStatusListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.wifi.WifiManager.SuggestionUserApprovalStatusListener listener) { throw new RuntimeException("Stub!"); }

public void removeSuggestionUserApprovalStatusListener(@android.annotation.NonNull android.net.wifi.WifiManager.SuggestionUserApprovalStatusListener listener) { throw new RuntimeException("Stub!"); }

public boolean setWifiScoringEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

public void flushPasspointAnqpCache() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.wifi.WifiAvailableChannel> getAllowedChannels(int band, int mode) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.wifi.WifiAvailableChannel> getUsableChannels(int band, int mode) { throw new RuntimeException("Stub!"); }

public boolean isWifiPasspointEnabled() { throw new RuntimeException("Stub!"); }

public void setWifiPasspointEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

public int getStaConcurrencyForMultiInternetMode() { throw new RuntimeException("Stub!"); }

public void notifyMinimumRequiredWifiSecurityLevelChanged(int level) { throw new RuntimeException("Stub!"); }

public void notifyWifiSsidPolicyChanged(@android.annotation.NonNull android.app.admin.WifiSsidPolicy policy) { throw new RuntimeException("Stub!"); }

public boolean setStaConcurrencyForMultiInternetMode(int mode) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<java.lang.String> getOemPrivilegedWifiAdminPackages() { throw new RuntimeException("Stub!"); }

public void reportCreateInterfaceImpact(int interfaceType, boolean requireNewInterface, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.BiConsumer<java.lang.Boolean,java.util.Set<android.net.wifi.WifiManager.InterfaceCreationImpact>> resultCallback) { throw new RuntimeException("Stub!"); }

public static final java.lang.String ACTION_LINK_CONFIGURATION_CHANGED = "android.net.wifi.LINK_CONFIGURATION_CHANGED";

public static final java.lang.String ACTION_NETWORK_SETTINGS_RESET = "android.net.wifi.action.NETWORK_SETTINGS_RESET";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_PASSPOINT_LAUNCH_OSU_VIEW = "android.net.wifi.action.PASSPOINT_LAUNCH_OSU_VIEW";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_PICK_WIFI_NETWORK = "android.net.wifi.PICK_WIFI_NETWORK";

public static final java.lang.String ACTION_REFRESH_USER_PROVISIONING = "android.net.wifi.action.REFRESH_USER_PROVISIONING";

public static final int ACTION_REMOVE_SUGGESTION_DISCONNECT = 2; // 0x2

public static final int ACTION_REMOVE_SUGGESTION_LINGER = 1; // 0x1

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_REQUEST_DISABLE = "android.net.wifi.action.REQUEST_DISABLE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_REQUEST_ENABLE = "android.net.wifi.action.REQUEST_ENABLE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_REQUEST_SCAN_ALWAYS_AVAILABLE = "android.net.wifi.action.REQUEST_SCAN_ALWAYS_AVAILABLE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_WIFI_NETWORK_SUGGESTION_POST_CONNECTION = "android.net.wifi.action.WIFI_NETWORK_SUGGESTION_POST_CONNECTION";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_WIFI_SCAN_AVAILABILITY_CHANGED = "android.net.wifi.action.WIFI_SCAN_AVAILABILITY_CHANGED";

public static final int API_AUTOJOIN_GLOBAL = 5; // 0x5

public static final int API_SCANNING_ENABLED = 1; // 0x1

public static final int API_SET_SCAN_SCHEDULE = 6; // 0x6

public static final int API_SOFT_AP = 3; // 0x3

public static final int API_TETHERED_HOTSPOT = 4; // 0x4

public static final int API_WIFI_ENABLED = 2; // 0x2

public static final int CHANGE_REASON_ADDED = 0; // 0x0

public static final int CHANGE_REASON_CONFIG_CHANGE = 2; // 0x2

public static final int CHANGE_REASON_REMOVED = 1; // 0x1

public static final int COEX_RESTRICTION_SOFTAP = 2; // 0x2

public static final int COEX_RESTRICTION_WIFI_AWARE = 4; // 0x4

public static final int COEX_RESTRICTION_WIFI_DIRECT = 1; // 0x1

public static final java.lang.String CONFIGURED_NETWORKS_CHANGED_ACTION = "android.net.wifi.CONFIGURED_NETWORKS_CHANGE";

public static final int DEVICE_MOBILITY_STATE_HIGH_MVMT = 1; // 0x1

public static final int DEVICE_MOBILITY_STATE_LOW_MVMT = 2; // 0x2

public static final int DEVICE_MOBILITY_STATE_STATIONARY = 3; // 0x3

public static final int DEVICE_MOBILITY_STATE_UNKNOWN = 0; // 0x0

public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_BRAINPOOLP256R1 = 3; // 0x3

public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_BRAINPOOLP384R1 = 4; // 0x4

public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_BRAINPOOLP512R1 = 5; // 0x5

public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_PRIME256V1 = 0; // 0x0

public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_SECP384R1 = 1; // 0x1

public static final int EASY_CONNECT_CRYPTOGRAPHY_CURVE_SECP521R1 = 2; // 0x2

public static final int EASY_CONNECT_NETWORK_ROLE_AP = 1; // 0x1

public static final int EASY_CONNECT_NETWORK_ROLE_STA = 0; // 0x0

@Deprecated public static final int ERROR_AUTHENTICATING = 1; // 0x1

@Deprecated public static final java.lang.String EXTRA_BSSID = "bssid";

public static final java.lang.String EXTRA_CHANGE_REASON = "changeReason";

@Deprecated public static final java.lang.String EXTRA_LINK_PROPERTIES = "android.net.wifi.extra.LINK_PROPERTIES";

@Deprecated public static final java.lang.String EXTRA_MULTIPLE_NETWORKS_CHANGED = "multipleChanges";

public static final java.lang.String EXTRA_NETWORK_INFO = "networkInfo";

public static final java.lang.String EXTRA_NETWORK_SUGGESTION = "android.net.wifi.extra.NETWORK_SUGGESTION";

public static final java.lang.String EXTRA_NEW_RSSI = "newRssi";

@Deprecated public static final java.lang.String EXTRA_NEW_STATE = "newState";

public static final java.lang.String EXTRA_OSU_NETWORK = "android.net.wifi.extra.OSU_NETWORK";

public static final java.lang.String EXTRA_PREVIOUS_WIFI_AP_STATE = "previous_wifi_state";

public static final java.lang.String EXTRA_PREVIOUS_WIFI_STATE = "previous_wifi_state";

public static final java.lang.String EXTRA_RESULTS_UPDATED = "resultsUpdated";

public static final java.lang.String EXTRA_SCAN_AVAILABLE = "android.net.wifi.extra.SCAN_AVAILABLE";

@Deprecated public static final java.lang.String EXTRA_SUPPLICANT_CONNECTED = "connected";

@Deprecated public static final java.lang.String EXTRA_SUPPLICANT_ERROR = "supplicantError";

public static final java.lang.String EXTRA_URL = "android.net.wifi.extra.URL";

public static final java.lang.String EXTRA_WIFI_AP_FAILURE_REASON = "android.net.wifi.extra.WIFI_AP_FAILURE_REASON";

public static final java.lang.String EXTRA_WIFI_AP_INTERFACE_NAME = "android.net.wifi.extra.WIFI_AP_INTERFACE_NAME";

public static final java.lang.String EXTRA_WIFI_AP_MODE = "android.net.wifi.extra.WIFI_AP_MODE";

public static final java.lang.String EXTRA_WIFI_AP_STATE = "wifi_state";

@Deprecated public static final java.lang.String EXTRA_WIFI_CONFIGURATION = "wifiConfiguration";

public static final java.lang.String EXTRA_WIFI_CREDENTIAL_EVENT_TYPE = "et";

public static final java.lang.String EXTRA_WIFI_CREDENTIAL_SSID = "ssid";

@Deprecated public static final java.lang.String EXTRA_WIFI_INFO = "wifiInfo";

public static final java.lang.String EXTRA_WIFI_STATE = "wifi_state";

public static final int IFACE_IP_MODE_CONFIGURATION_ERROR = 0; // 0x0

public static final int IFACE_IP_MODE_LOCAL_ONLY = 2; // 0x2

public static final int IFACE_IP_MODE_TETHERED = 1; // 0x1

public static final int IFACE_IP_MODE_UNSPECIFIED = -1; // 0xffffffff

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String NETWORK_IDS_CHANGED_ACTION = "android.net.wifi.NETWORK_IDS_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String NETWORK_STATE_CHANGED_ACTION = "android.net.wifi.STATE_CHANGE";

public static final int PASSPOINT_HOME_NETWORK = 0; // 0x0

public static final int PASSPOINT_ROAMING_NETWORK = 1; // 0x1

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String RSSI_CHANGED_ACTION = "android.net.wifi.RSSI_CHANGED";

public static final int SAP_CLIENT_BLOCK_REASON_CODE_BLOCKED_BY_USER = 0; // 0x0

public static final int SAP_CLIENT_BLOCK_REASON_CODE_NO_MORE_STAS = 1; // 0x1

public static final int SAP_START_FAILURE_GENERAL = 0; // 0x0

public static final int SAP_START_FAILURE_NO_CHANNEL = 1; // 0x1

public static final int SAP_START_FAILURE_UNSUPPORTED_CONFIGURATION = 2; // 0x2

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String SCAN_RESULTS_AVAILABLE_ACTION = "android.net.wifi.SCAN_RESULTS";

public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_DUPLICATE = 3; // 0x3

public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_EXCEEDS_MAX_PER_APP = 4; // 0x4

public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_INVALID = 7; // 0x7

public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_ADD_NOT_ALLOWED = 6; // 0x6

public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_APP_DISALLOWED = 2; // 0x2

public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_INTERNAL = 1; // 0x1

public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_REMOVE_INVALID = 5; // 0x5

public static final int STATUS_NETWORK_SUGGESTIONS_ERROR_RESTRICTED_BY_ADMIN = 8; // 0x8

public static final int STATUS_NETWORK_SUGGESTIONS_SUCCESS = 0; // 0x0

public static final int STATUS_SUGGESTION_APPROVAL_APPROVED_BY_CARRIER_PRIVILEGE = 4; // 0x4

public static final int STATUS_SUGGESTION_APPROVAL_APPROVED_BY_USER = 2; // 0x2

public static final int STATUS_SUGGESTION_APPROVAL_PENDING = 1; // 0x1

public static final int STATUS_SUGGESTION_APPROVAL_REJECTED_BY_USER = 3; // 0x3

public static final int STATUS_SUGGESTION_APPROVAL_UNKNOWN = 0; // 0x0

public static final int STATUS_SUGGESTION_CONNECTION_FAILURE_ASSOCIATION = 1; // 0x1

public static final int STATUS_SUGGESTION_CONNECTION_FAILURE_AUTHENTICATION = 2; // 0x2

public static final int STATUS_SUGGESTION_CONNECTION_FAILURE_IP_PROVISIONING = 3; // 0x3

public static final int STATUS_SUGGESTION_CONNECTION_FAILURE_UNKNOWN = 0; // 0x0

@Deprecated @android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String SUPPLICANT_CONNECTION_CHANGE_ACTION = "android.net.wifi.supplicant.CONNECTION_CHANGE";

@Deprecated @android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String SUPPLICANT_STATE_CHANGED_ACTION = "android.net.wifi.supplicant.STATE_CHANGE";

public static final java.lang.String UNKNOWN_SSID = "<unknown ssid>";

public static final int VERBOSE_LOGGING_LEVEL_DISABLED = 0; // 0x0

public static final int VERBOSE_LOGGING_LEVEL_ENABLED = 1; // 0x1

public static final int VERBOSE_LOGGING_LEVEL_ENABLED_SHOW_KEY = 2; // 0x2

public static final java.lang.String WIFI_AP_STATE_CHANGED_ACTION = "android.net.wifi.WIFI_AP_STATE_CHANGED";

public static final int WIFI_AP_STATE_DISABLED = 11; // 0xb

public static final int WIFI_AP_STATE_DISABLING = 10; // 0xa

public static final int WIFI_AP_STATE_ENABLED = 13; // 0xd

public static final int WIFI_AP_STATE_ENABLING = 12; // 0xc

public static final int WIFI_AP_STATE_FAILED = 14; // 0xe

public static final java.lang.String WIFI_CREDENTIAL_CHANGED_ACTION = "android.net.wifi.WIFI_CREDENTIAL_CHANGED";

public static final int WIFI_CREDENTIAL_FORGOT = 1; // 0x1

public static final int WIFI_CREDENTIAL_SAVED = 0; // 0x0

public static final int WIFI_INTERFACE_TYPE_AP = 1; // 0x1

public static final int WIFI_INTERFACE_TYPE_AWARE = 2; // 0x2

public static final int WIFI_INTERFACE_TYPE_DIRECT = 3; // 0x3

public static final int WIFI_INTERFACE_TYPE_STA = 0; // 0x0

@Deprecated public static final int WIFI_MODE_FULL = 1; // 0x1

public static final int WIFI_MODE_FULL_HIGH_PERF = 3; // 0x3

public static final int WIFI_MODE_FULL_LOW_LATENCY = 4; // 0x4

@Deprecated public static final int WIFI_MODE_SCAN_ONLY = 2; // 0x2

public static final int WIFI_MULTI_INTERNET_MODE_DBS_AP = 1; // 0x1

public static final int WIFI_MULTI_INTERNET_MODE_DISABLED = 0; // 0x0

public static final int WIFI_MULTI_INTERNET_MODE_MULTI_AP = 2; // 0x2

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String WIFI_STATE_CHANGED_ACTION = "android.net.wifi.WIFI_STATE_CHANGED";

public static final int WIFI_STATE_DISABLED = 1; // 0x1

public static final int WIFI_STATE_DISABLING = 0; // 0x0

public static final int WIFI_STATE_ENABLED = 3; // 0x3

public static final int WIFI_STATE_ENABLING = 2; // 0x2

public static final int WIFI_STATE_UNKNOWN = 4; // 0x4

@Deprecated public static final int WPS_AUTH_FAILURE = 6; // 0x6

@Deprecated public static final int WPS_OVERLAP_ERROR = 3; // 0x3

@Deprecated public static final int WPS_TIMED_OUT = 7; // 0x7

@Deprecated public static final int WPS_TKIP_ONLY_PROHIBITED = 5; // 0x5

@Deprecated public static final int WPS_WEP_PROHIBITED = 4; // 0x4
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ActionListener {

public void onSuccess();

public void onFailure(int reason);

public static final int FAILURE_BUSY = 2; // 0x2

public static final int FAILURE_INTERNAL_ERROR = 0; // 0x0

public static final int FAILURE_INVALID_ARGS = 3; // 0x3

public static final int FAILURE_IN_PROGRESS = 1; // 0x1

public static final int FAILURE_NOT_AUTHORIZED = 4; // 0x4
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ActiveCountryCodeChangedCallback {

public void onActiveCountryCodeChanged(@android.annotation.NonNull java.lang.String countryCode);

public void onCountryCodeInactive();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class AddNetworkResult implements android.os.Parcelable {

public AddNetworkResult(int statusCode, int networkId) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.WifiManager.AddNetworkResult> CREATOR;
static { CREATOR = null; }

public static final int STATUS_ADD_PASSPOINT_FAILURE = 3; // 0x3

public static final int STATUS_ADD_WIFI_CONFIG_FAILURE = 4; // 0x4

public static final int STATUS_FAILURE_UNKNOWN = 1; // 0x1

public static final int STATUS_FAILURE_UPDATE_NETWORK_KEYS = 9; // 0x9

public static final int STATUS_INVALID_CONFIGURATION = 5; // 0x5

public static final int STATUS_INVALID_CONFIGURATION_ENTERPRISE = 10; // 0xa

public static final int STATUS_NO_PERMISSION = 2; // 0x2

public static final int STATUS_NO_PERMISSION_MODIFY_CONFIG = 6; // 0x6

public static final int STATUS_NO_PERMISSION_MODIFY_MAC_RANDOMIZATION = 8; // 0x8

public static final int STATUS_NO_PERMISSION_MODIFY_PROXY_SETTING = 7; // 0x7

public static final int STATUS_SUCCESS = 0; // 0x0

public final int networkId;
{ networkId = 0; }

public final int statusCode;
{ statusCode = 0; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class CoexCallback {

public CoexCallback() { throw new RuntimeException("Stub!"); }

public abstract void onCoexUnsafeChannelsChanged(@android.annotation.NonNull java.util.List<android.net.wifi.CoexUnsafeChannel> unsafeChannels, int restrictions);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class InterfaceCreationImpact {

public InterfaceCreationImpact(int interfaceType, @android.annotation.NonNull java.util.Set<java.lang.String> packages) { throw new RuntimeException("Stub!"); }

public int getInterfaceType() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<java.lang.String> getPackages() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object that) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class LocalOnlyHotspotCallback {

public LocalOnlyHotspotCallback() { throw new RuntimeException("Stub!"); }

public void onStarted(android.net.wifi.WifiManager.LocalOnlyHotspotReservation reservation) { throw new RuntimeException("Stub!"); }

public void onStopped() { throw new RuntimeException("Stub!"); }

public void onFailed(int reason) { throw new RuntimeException("Stub!"); }

public static final int ERROR_GENERIC = 2; // 0x2

public static final int ERROR_INCOMPATIBLE_MODE = 3; // 0x3

public static final int ERROR_NO_CHANNEL = 1; // 0x1

public static final int ERROR_TETHERING_DISALLOWED = 4; // 0x4
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class LocalOnlyHotspotReservation implements java.lang.AutoCloseable {

LocalOnlyHotspotReservation() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public android.net.wifi.WifiConfiguration getWifiConfiguration() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.SoftApConfiguration getSoftApConfiguration() { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class MulticastLock {

private MulticastLock() { throw new RuntimeException("Stub!"); }

public void acquire() { throw new RuntimeException("Stub!"); }

public void release() { throw new RuntimeException("Stub!"); }

public void setReferenceCounted(boolean refCounted) { throw new RuntimeException("Stub!"); }

public boolean isHeld() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface NetworkRequestMatchCallback {

public default void onUserSelectionCallbackRegistration(@android.annotation.NonNull android.net.wifi.WifiManager.NetworkRequestUserSelectionCallback userSelectionCallback) { throw new RuntimeException("Stub!"); }

public default void onAbort() { throw new RuntimeException("Stub!"); }

public default void onMatch(@android.annotation.NonNull java.util.List<android.net.wifi.ScanResult> scanResults) { throw new RuntimeException("Stub!"); }

public default void onUserSelectionConnectSuccess(@android.annotation.NonNull android.net.wifi.WifiConfiguration wifiConfiguration) { throw new RuntimeException("Stub!"); }

public default void onUserSelectionConnectFailure(@android.annotation.NonNull android.net.wifi.WifiConfiguration wifiConfiguration) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface NetworkRequestUserSelectionCallback {

public default void select(@android.annotation.NonNull android.net.wifi.WifiConfiguration wifiConfiguration) { throw new RuntimeException("Stub!"); }

public default void reject() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnWifiActivityEnergyInfoListener {

public void onWifiActivityEnergyInfo(@android.annotation.Nullable android.os.connectivity.WifiActivityEnergyInfo info);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnWifiUsabilityStatsListener {

public void onWifiUsabilityStats(int seqNum, boolean isSameBssidAndFreq, @android.annotation.NonNull android.net.wifi.WifiUsabilityStatsEntry stats);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface PnoScanResultsCallback {

public void onScanResultsAvailable(@android.annotation.NonNull java.util.List<android.net.wifi.ScanResult> scanResults);

public void onRegisterSuccess();

public void onRegisterFailed(int reason);

public void onRemoved(int reason);

public static final int REGISTER_PNO_CALLBACK_ALREADY_REGISTERED = 1; // 0x1

public static final int REGISTER_PNO_CALLBACK_PNO_NOT_SUPPORTED = 3; // 0x3

public static final int REGISTER_PNO_CALLBACK_RESOURCE_BUSY = 2; // 0x2

public static final int REGISTER_PNO_CALLBACK_UNKNOWN = 0; // 0x0

public static final int REMOVE_PNO_CALLBACK_RESULTS_DELIVERED = 1; // 0x1

public static final int REMOVE_PNO_CALLBACK_UNKNOWN = 0; // 0x0

public static final int REMOVE_PNO_CALLBACK_UNREGISTERED = 2; // 0x2
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class ScanResultsCallback {

public ScanResultsCallback() { throw new RuntimeException("Stub!"); }

public abstract void onScanResultsAvailable();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ScoreUpdateObserver {

public void notifyScoreUpdate(int sessionId, int score);

public void triggerUpdateOfWifiUsabilityStats(int sessionId);

public default void notifyStatusUpdate(int sessionId, boolean isUsable) { throw new RuntimeException("Stub!"); }

public default void requestNudOperation(int sessionId) { throw new RuntimeException("Stub!"); }

public default void blocklistCurrentBssid(int sessionId) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class ScreenOnScanSchedule {

public ScreenOnScanSchedule(@android.annotation.NonNull java.time.Duration scanInterval, int scanType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.time.Duration getScanInterval() { throw new RuntimeException("Stub!"); }

public int getScanType() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface SoftApCallback {

public default void onStateChanged(int state, int failureReason) { throw new RuntimeException("Stub!"); }

@Deprecated
public default void onConnectedClientsChanged(@android.annotation.NonNull java.util.List<android.net.wifi.WifiClient> clients) { throw new RuntimeException("Stub!"); }

public default void onConnectedClientsChanged(@android.annotation.NonNull android.net.wifi.SoftApInfo info, @android.annotation.NonNull java.util.List<android.net.wifi.WifiClient> clients) { throw new RuntimeException("Stub!"); }

@Deprecated
public default void onInfoChanged(@android.annotation.NonNull android.net.wifi.SoftApInfo softApInfo) { throw new RuntimeException("Stub!"); }

public default void onInfoChanged(@android.annotation.NonNull java.util.List<android.net.wifi.SoftApInfo> softApInfoList) { throw new RuntimeException("Stub!"); }

public default void onCapabilityChanged(@android.annotation.NonNull android.net.wifi.SoftApCapability softApCapability) { throw new RuntimeException("Stub!"); }

public default void onBlockedClientConnecting(@android.annotation.NonNull android.net.wifi.WifiClient client, int blockedReason) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class SubsystemRestartTrackingCallback {

public SubsystemRestartTrackingCallback() { throw new RuntimeException("Stub!"); }

public abstract void onSubsystemRestarting();

public abstract void onSubsystemRestarted();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface SuggestionConnectionStatusListener {

public void onConnectionStatus(@android.annotation.NonNull android.net.wifi.WifiNetworkSuggestion wifiNetworkSuggestion, int failureReason);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface SuggestionUserApprovalStatusListener {

public void onUserApprovalStatusChange(int status);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface TrafficStateCallback {

public void onStateChanged(int state);

public static final int DATA_ACTIVITY_IN = 1; // 0x1

public static final int DATA_ACTIVITY_INOUT = 3; // 0x3

public static final int DATA_ACTIVITY_NONE = 0; // 0x0

public static final int DATA_ACTIVITY_OUT = 2; // 0x2
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface WifiConnectedNetworkScorer {

@Deprecated
public default void onStart(int sessionId) { throw new RuntimeException("Stub!"); }

public default void onStart(@android.annotation.NonNull android.net.wifi.WifiConnectedSessionInfo sessionInfo) { throw new RuntimeException("Stub!"); }

public void onStop(int sessionId);

public void onSetScoreUpdateObserver(@android.annotation.NonNull android.net.wifi.WifiManager.ScoreUpdateObserver observerImpl);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class WifiLock {

private WifiLock() { throw new RuntimeException("Stub!"); }

public void acquire() { throw new RuntimeException("Stub!"); }

public void release() { throw new RuntimeException("Stub!"); }

public void setReferenceCounted(boolean refCounted) { throw new RuntimeException("Stub!"); }

public boolean isHeld() { throw new RuntimeException("Stub!"); }

public void setWorkSource(android.os.WorkSource ws) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface WifiVerboseLoggingStatusChangedListener {

public void onWifiVerboseLoggingStatusChanged(boolean enabled);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public abstract static class WpsCallback {

@Deprecated
public WpsCallback() { throw new RuntimeException("Stub!"); }

@Deprecated
public abstract void onStarted(java.lang.String pin);

@Deprecated
public abstract void onSucceeded();

@Deprecated
public abstract void onFailed(int reason);
}

}

