/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.rtt;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RangingResult implements android.os.Parcelable {

RangingResult() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int get80211azInitiatorTxLtfRepetitionsCount() { throw new RuntimeException("Stub!"); }

public int get80211azNumberOfRxSpatialStreams() { throw new RuntimeException("Stub!"); }

public int get80211azNumberOfTxSpatialStreams() { throw new RuntimeException("Stub!"); }

public int get80211azResponderTxLtfRepetitionsCount() { throw new RuntimeException("Stub!"); }

public int getDistanceMm() { throw new RuntimeException("Stub!"); }

public int getDistanceStdDevMm() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] getLci() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] getLcr() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.MacAddress getMacAddress() { throw new RuntimeException("Stub!"); }

public long getMaxTimeBetweenNtbMeasurementsMicros() { throw new RuntimeException("Stub!"); }

public int getMeasurementBandwidth() { throw new RuntimeException("Stub!"); }

public int getMeasurementChannelFrequencyMHz() { throw new RuntimeException("Stub!"); }

public long getMinTimeBetweenNtbMeasurementsMicros() { throw new RuntimeException("Stub!"); }

public int getNumAttemptedMeasurements() { throw new RuntimeException("Stub!"); }

public int getNumSuccessfulMeasurements() { throw new RuntimeException("Stub!"); }

public long getPasnComebackAfterMillis() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public byte[] getPasnComebackCookie() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.wifi.aware.PeerHandle getPeerHandle() { throw new RuntimeException("Stub!"); }

public long getRangingTimestampMillis() { throw new RuntimeException("Stub!"); }

public int getRssi() { throw new RuntimeException("Stub!"); }

public int getSecureHeLtfProtocolVersion() { throw new RuntimeException("Stub!"); }

public int getStatus() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.wifi.rtt.ResponderLocation getUnverifiedResponderLocation() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.wifi.OuiKeyedData> getVendorData() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public boolean is80211azNtbMeasurement() { throw new RuntimeException("Stub!"); }

public boolean is80211mcMeasurement() { throw new RuntimeException("Stub!"); }

public boolean isRangingAuthenticated() { throw new RuntimeException("Stub!"); }

public boolean isRangingFrameProtected() { throw new RuntimeException("Stub!"); }

public boolean isSecureHeLtfEnabled() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.rtt.RangingResult> CREATOR;
static { CREATOR = null; }

public static final int STATUS_FAIL = 1; // 0x1

public static final int STATUS_RESPONDER_DOES_NOT_SUPPORT_IEEE80211MC = 2; // 0x2

public static final int STATUS_SUCCESS = 0; // 0x0

public static final int UNSPECIFIED = -1; // 0xffffffff
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder set80211azInitiatorTxLtfRepetitionsCount(int i2rTxLtfRepetitions) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder set80211azNtbMeasurement(boolean is80211azNtbMeasurement) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder set80211azNumberOfRxSpatialStreams(int numRxSpatialStreams) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder set80211azNumberOfTxSpatialStreams(int numTxSpatialStreams) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder set80211azResponderTxLtfRepetitionsCount(int r2iTxLtfRepetitions) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder set80211mcMeasurement(boolean is80211mcMeasurement) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setDistanceMm(int distanceMm) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setDistanceStdDevMm(int distanceStdDevMm) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setLci(@android.annotation.Nullable byte[] lci) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setLcr(@android.annotation.Nullable byte[] lcr) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setMacAddress(@android.annotation.Nullable android.net.MacAddress macAddress) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setMaxTimeBetweenNtbMeasurementsMicros(long ntbMaxMeasurementTime) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setMeasurementBandwidth(int measurementBandwidth) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setMeasurementChannelFrequencyMHz(int frequencyMHz) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setMinTimeBetweenNtbMeasurementsMicros(long ntbMinMeasurementTime) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setNumAttemptedMeasurements(int numAttemptedMeasurements) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setNumSuccessfulMeasurements(int numSuccessfulMeasurements) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setPasnComebackAfterMillis(long comebackAfterMillis) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setPasnComebackCookie(@android.annotation.NonNull byte[] pasnComebackCookie) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setPeerHandle(@android.annotation.Nullable android.net.wifi.aware.PeerHandle peerHandle) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setRangingAuthenticated(boolean isRangingAuthenticated) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setRangingFrameProtected(boolean isRangingFrameProtected) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setRangingTimestampMillis(long timestamp) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setRssi(int rssi) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setSecureHeLtfEnabled(boolean isSecureHeLtfEnabled) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setSecureHeLtfProtocolVersion(int secureHeLtfProtocolVersion) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setStatus(int status) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setUnverifiedResponderLocation(@android.annotation.Nullable android.net.wifi.rtt.ResponderLocation responderLocation) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.RangingResult.Builder setVendorData(@android.annotation.NonNull java.util.List<android.net.wifi.OuiKeyedData> vendorData) { throw new RuntimeException("Stub!"); }
}

}

