/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.rtt;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ResponderConfig implements android.os.Parcelable {

public ResponderConfig(@android.annotation.NonNull android.net.MacAddress macAddress, int responderType, boolean supports80211mc, int channelWidth, int frequency, int centerFreq0, int centerFreq1, int preamble) { throw new RuntimeException("Stub!"); }

public ResponderConfig(@android.annotation.NonNull android.net.wifi.aware.PeerHandle peerHandle, int responderType, boolean supports80211mc, int channelWidth, int frequency, int centerFreq0, int centerFreq1, int preamble) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.net.wifi.rtt.ResponderConfig fromScanResult(@android.annotation.NonNull android.net.wifi.ScanResult scanResult) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.net.wifi.rtt.ResponderConfig fromWifiAwarePeerHandleWithDefaults(@android.annotation.NonNull android.net.wifi.aware.PeerHandle peerHandle) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.net.wifi.rtt.ResponderConfig fromWifiAwarePeerMacAddressWithDefaults(@android.annotation.NonNull android.net.MacAddress macAddress) { throw new RuntimeException("Stub!"); }

public int getCenterFreq0Mhz() { throw new RuntimeException("Stub!"); }

public int getCenterFreq1Mhz() { throw new RuntimeException("Stub!"); }

public int getChannelWidth() { throw new RuntimeException("Stub!"); }

public int getFrequencyMhz() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.MacAddress getMacAddress() { throw new RuntimeException("Stub!"); }

public int getPreamble() { throw new RuntimeException("Stub!"); }

public int getResponderType() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.wifi.rtt.SecureRangingConfig getSecureRangingConfig() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public boolean is80211azNtbSupported() { throw new RuntimeException("Stub!"); }

public boolean is80211mcSupported() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final int CHANNEL_WIDTH_160MHZ = 3; // 0x3

public static final int CHANNEL_WIDTH_20MHZ = 0; // 0x0

public static final int CHANNEL_WIDTH_320MHZ = 5; // 0x5

public static final int CHANNEL_WIDTH_40MHZ = 1; // 0x1

public static final int CHANNEL_WIDTH_80MHZ = 2; // 0x2

public static final int CHANNEL_WIDTH_80MHZ_PLUS_MHZ = 4; // 0x4

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.rtt.ResponderConfig> CREATOR;
static { CREATOR = null; }

public static final int PREAMBLE_EHT = 4; // 0x4

public static final int PREAMBLE_HE = 3; // 0x3

public static final int PREAMBLE_HT = 1; // 0x1

public static final int PREAMBLE_LEGACY = 0; // 0x0

public static final int PREAMBLE_VHT = 2; // 0x2

public static final int RESPONDER_AP = 0; // 0x0

public static final int RESPONDER_AWARE = 4; // 0x4

public static final int RESPONDER_P2P_CLIENT = 3; // 0x3

public static final int RESPONDER_P2P_GO = 2; // 0x2

public static final int RESPONDER_STA = 1; // 0x1

public final int centerFreq0;
{ centerFreq0 = 0; }

public final int centerFreq1;
{ centerFreq1 = 0; }

public final int channelWidth;
{ channelWidth = 0; }

public final int frequency;
{ frequency = 0; }

@android.annotation.Nullable public final android.net.MacAddress macAddress;
{ macAddress = null; }

@android.annotation.Nullable public final android.net.wifi.aware.PeerHandle peerHandle;
{ peerHandle = null; }

public final int preamble;
{ preamble = 0; }

public final int responderType;
{ responderType = 0; }

public final boolean supports80211azNtb;
{ supports80211azNtb = false; }

public final boolean supports80211mc;
{ supports80211mc = false; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder set80211azNtbSupported(boolean supports80211azNtb) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder set80211mcSupported(boolean supports80211mc) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder setCenterFreq0Mhz(int centerFreq0) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder setCenterFreq1Mhz(int centerFreq1) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder setChannelWidth(int channelWidth) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder setFrequencyMhz(int frequency) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder setMacAddress(@android.annotation.NonNull android.net.MacAddress macAddress) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder setPreamble(int preamble) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder setResponderType(int responderType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.rtt.ResponderConfig.Builder setSecureRangingConfig(@android.annotation.NonNull android.net.wifi.rtt.SecureRangingConfig secureRangingConfig) { throw new RuntimeException("Stub!"); }
}

}

