/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.twt;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface TwtSessionCallback {

public void onCreate(@android.annotation.NonNull android.net.wifi.twt.TwtSession twtSession);

public void onFailure(int errorCode);

public void onTeardown(int reasonCode);

public static final int TWT_ERROR_CODE_AP_NOT_SUPPORTED = 1; // 0x1

public static final int TWT_ERROR_CODE_AP_OUI_BLOCKLISTED = 2; // 0x2

public static final int TWT_ERROR_CODE_AP_REJECTED = 3; // 0x3

public static final int TWT_ERROR_CODE_FAIL = 0; // 0x0

public static final int TWT_ERROR_CODE_INVALID_PARAMS = 4; // 0x4

public static final int TWT_ERROR_CODE_MAX_SESSIONS_REACHED = 5; // 0x5

public static final int TWT_ERROR_CODE_NOT_AVAILABLE = 6; // 0x6

public static final int TWT_ERROR_CODE_NOT_SUPPORTED = 7; // 0x7

public static final int TWT_ERROR_CODE_TIMEOUT = 8; // 0x8

public static final int TWT_REASON_CODE_INTERNALLY_INITIATED = 2; // 0x2

public static final int TWT_REASON_CODE_LOCALLY_REQUESTED = 1; // 0x1

public static final int TWT_REASON_CODE_PEER_INITIATED = 3; // 0x3

public static final int TWT_REASON_CODE_UNKNOWN = 0; // 0x0
}

