/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class QosPolicyParams implements android.os.Parcelable {

QosPolicyParams() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.net.InetAddress getDestinationAddress() { throw new RuntimeException("Stub!"); }

public int getDestinationPort() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public int[] getDestinationPortRange() { throw new RuntimeException("Stub!"); }

public int getDirection() { throw new RuntimeException("Stub!"); }

public int getDscp() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public byte[] getFlowLabel() { throw new RuntimeException("Stub!"); }

public int getIpVersion() { throw new RuntimeException("Stub!"); }

public int getPolicyId() { throw new RuntimeException("Stub!"); }

public int getProtocol() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.wifi.QosCharacteristics getQosCharacteristics() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.net.InetAddress getSourceAddress() { throw new RuntimeException("Stub!"); }

public int getSourcePort() { throw new RuntimeException("Stub!"); }

public int getUserPriority() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.QosPolicyParams> CREATOR;
static { CREATOR = null; }

public static final int DESTINATION_PORT_ANY = -1; // 0xffffffff

public static final int DIRECTION_DOWNLINK = 1; // 0x1

public static final int DIRECTION_UPLINK = 0; // 0x0

public static final int DSCP_ANY = -1; // 0xffffffff

public static final int IP_VERSION_4 = 4; // 0x4

public static final int IP_VERSION_6 = 6; // 0x6

public static final int IP_VERSION_ANY = -1; // 0xffffffff

public static final int PROTOCOL_ANY = -1; // 0xffffffff

public static final int PROTOCOL_ESP = 50; // 0x32

public static final int PROTOCOL_TCP = 6; // 0x6

public static final int PROTOCOL_UDP = 17; // 0x11

public static final int USER_PRIORITY_ANY = -1; // 0xffffffff

public static final int USER_PRIORITY_BACKGROUND_HIGH = 2; // 0x2

public static final int USER_PRIORITY_BACKGROUND_LOW = 1; // 0x1

public static final int USER_PRIORITY_BEST_EFFORT_HIGH = 3; // 0x3

public static final int USER_PRIORITY_BEST_EFFORT_LOW = 0; // 0x0

public static final int USER_PRIORITY_VIDEO_HIGH = 5; // 0x5

public static final int USER_PRIORITY_VIDEO_LOW = 4; // 0x4

public static final int USER_PRIORITY_VOICE_HIGH = 7; // 0x7

public static final int USER_PRIORITY_VOICE_LOW = 6; // 0x6
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(int policyId, int direction) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.QosPolicyParams build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.QosPolicyParams.Builder setDestinationAddress(@android.annotation.Nullable java.net.InetAddress value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.QosPolicyParams.Builder setDestinationPort(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.QosPolicyParams.Builder setDestinationPortRange(int start, int end) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.QosPolicyParams.Builder setDscp(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.QosPolicyParams.Builder setFlowLabel(@android.annotation.Nullable byte[] value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.QosPolicyParams.Builder setIpVersion(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.QosPolicyParams.Builder setProtocol(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.QosPolicyParams.Builder setQosCharacteristics(@android.annotation.Nullable android.net.wifi.QosCharacteristics qosCharacteristics) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.QosPolicyParams.Builder setSourceAddress(@android.annotation.Nullable java.net.InetAddress value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.QosPolicyParams.Builder setSourcePort(int value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.wifi.QosPolicyParams.Builder setUserPriority(int value) { throw new RuntimeException("Stub!"); }
}

}

