/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ScanResult implements android.os.Parcelable {

public ScanResult() { throw new RuntimeException("Stub!"); }

public ScanResult(@android.annotation.NonNull android.net.wifi.ScanResult source) { throw new RuntimeException("Stub!"); }

public static int convertChannelToFrequencyMhzIfSupported(int channel, int band) { throw new RuntimeException("Stub!"); }

public static int convertFrequencyMhzToChannelIfSupported(int freqMhz) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.wifi.MloLink> getAffiliatedMloLinks() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.MacAddress getApMldMacAddress() { throw new RuntimeException("Stub!"); }

public int getApMloLinkId() { throw new RuntimeException("Stub!"); }

public int getBand() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.net.wifi.ScanResult.InformationElement> getInformationElements() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public int[] getSecurityTypes() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.wifi.WifiSsid getWifiSsid() { throw new RuntimeException("Stub!"); }

public int getWifiStandard() { throw new RuntimeException("Stub!"); }

public boolean is80211azNtbResponder() { throw new RuntimeException("Stub!"); }

public boolean is80211mcResponder() { throw new RuntimeException("Stub!"); }

public boolean isPasspointNetwork() { throw new RuntimeException("Stub!"); }

public boolean isRangingFrameProtectionRequired() { throw new RuntimeException("Stub!"); }

public boolean isSecureHeLtfSupported() { throw new RuntimeException("Stub!"); }

public boolean isTwtResponder() { throw new RuntimeException("Stub!"); }

public void setWifiSsid(@android.annotation.NonNull android.net.wifi.WifiSsid ssid) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public java.lang.String BSSID;

public static final int CHANNEL_WIDTH_160MHZ = 3; // 0x3

public static final int CHANNEL_WIDTH_20MHZ = 0; // 0x0

public static final int CHANNEL_WIDTH_320MHZ = 5; // 0x5

public static final int CHANNEL_WIDTH_40MHZ = 1; // 0x1

public static final int CHANNEL_WIDTH_80MHZ = 2; // 0x2

public static final int CHANNEL_WIDTH_80MHZ_PLUS_MHZ = 4; // 0x4

public static final int CIPHER_BIP_CMAC_256 = 9; // 0x9

public static final int CIPHER_BIP_GMAC_128 = 7; // 0x7

public static final int CIPHER_BIP_GMAC_256 = 8; // 0x8

public static final int CIPHER_CCMP = 3; // 0x3

public static final int CIPHER_GCMP_128 = 6; // 0x6

public static final int CIPHER_GCMP_256 = 4; // 0x4

public static final int CIPHER_NONE = 0; // 0x0

public static final int CIPHER_NO_GROUP_ADDRESSED = 1; // 0x1

public static final int CIPHER_SMS4 = 5; // 0x5

public static final int CIPHER_TKIP = 2; // 0x2

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.ScanResult> CREATOR;
static { CREATOR = null; }

public static final int KEY_MGMT_EAP = 2; // 0x2

public static final int KEY_MGMT_EAP_SHA256 = 6; // 0x6

public static final int KEY_MGMT_EAP_SUITE_B_192 = 10; // 0xa

public static final int KEY_MGMT_FT_EAP = 4; // 0x4

public static final int KEY_MGMT_FT_PSK = 3; // 0x3

public static final int KEY_MGMT_FT_SAE = 11; // 0xb

public static final int KEY_MGMT_NONE = 0; // 0x0

public static final int KEY_MGMT_OSEN = 7; // 0x7

public static final int KEY_MGMT_OWE = 9; // 0x9

public static final int KEY_MGMT_OWE_TRANSITION = 12; // 0xc

public static final int KEY_MGMT_PSK = 1; // 0x1

public static final int KEY_MGMT_PSK_SHA256 = 5; // 0x5

public static final int KEY_MGMT_SAE = 8; // 0x8

public static final int KEY_MGMT_WAPI_CERT = 14; // 0xe

public static final int KEY_MGMT_WAPI_PSK = 13; // 0xd

public static final int PREAMBLE_EHT = 4; // 0x4

public static final int PREAMBLE_HE = 3; // 0x3

public static final int PREAMBLE_HT = 1; // 0x1

public static final int PREAMBLE_LEGACY = 0; // 0x0

public static final int PREAMBLE_VHT = 2; // 0x2

public static final int PROTOCOL_NONE = 0; // 0x0

public static final int PROTOCOL_OSEN = 3; // 0x3

public static final int PROTOCOL_RSN = 2; // 0x2

public static final int PROTOCOL_WAPI = 4; // 0x4

public static final int PROTOCOL_WPA = 1; // 0x1

@Deprecated public java.lang.String SSID;

public static final int UNSPECIFIED = -1; // 0xffffffff

public static final int WIFI_BAND_24_GHZ = 1; // 0x1

public static final int WIFI_BAND_5_GHZ = 2; // 0x2

public static final int WIFI_BAND_60_GHZ = 16; // 0x10

public static final int WIFI_BAND_6_GHZ = 8; // 0x8

public static final int WIFI_STANDARD_11AC = 5; // 0x5

public static final int WIFI_STANDARD_11AD = 7; // 0x7

public static final int WIFI_STANDARD_11AX = 6; // 0x6

public static final int WIFI_STANDARD_11BE = 8; // 0x8

public static final int WIFI_STANDARD_11N = 4; // 0x4

public static final int WIFI_STANDARD_LEGACY = 1; // 0x1

public static final int WIFI_STANDARD_UNKNOWN = 0; // 0x0

public java.lang.String capabilities;

public int centerFreq0;

public int centerFreq1;

public int channelWidth;

public int frequency;

public int level;

@Deprecated public java.lang.CharSequence operatorFriendlyName;

public long timestamp;

@Deprecated public java.lang.CharSequence venueName;
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class InformationElement implements android.os.Parcelable {

public InformationElement(@android.annotation.NonNull android.net.wifi.ScanResult.InformationElement rhs) { throw new RuntimeException("Stub!"); }

public InformationElement(int id, int idExt, @android.annotation.NonNull byte[] bytes) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object that) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.nio.ByteBuffer getBytes() { throw new RuntimeException("Stub!"); }

public int getId() { throw new RuntimeException("Stub!"); }

public int getIdExt() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.ScanResult.InformationElement> CREATOR;
static { CREATOR = null; }
}

}

