/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.crypto.hpke;

import java.security.spec.EncodedKeySpec;

/**
 * External Diffie–Hellman (XDH) key spec holding either a public or private key.
 * <p>
 * Subclasses {@code EncodedKeySpec} using the non-Standard "raw" format.  The XdhKeyFactory
 * class utilises this in order to create XDH keys from raw bytes and to return them
 * as an XdhKeySpec allowing the raw key material to be extracted from an XDH key.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class XdhKeySpec extends java.security.spec.EncodedKeySpec {

/**
 * Creates an instance of {@link android.crypto.hpke.XdhKeySpec XdhKeySpec} by passing a public or private key in its raw
 * format.
 */

public XdhKeySpec(@android.annotation.NonNull byte[] encoded) { super((byte[])null); throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getFormat() { throw new RuntimeException("Stub!"); }

/**
 * Returns the public or private key in its raw format.
 *
 * @return key in its raw format.
 */

@android.annotation.NonNull
public byte[] getKey() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

