/*
 * Copyright (C) 2014 The Android Open Source Project
 * Copyright (c) 2000, 2008, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.net;


/**
 * Signals that a timeout has occurred on a socket read or accept.
 *
 * @since   1.4
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class SocketTimeoutException extends java.io.InterruptedIOException {

/**
 * Constructs a new SocketTimeoutException with a detail
 * message.
 * @param msg the detail message
 */

public SocketTimeoutException(java.lang.String msg) { throw new RuntimeException("Stub!"); }

/**
 * Construct a new SocketTimeoutException with no detailed message.
 */

public SocketTimeoutException() { throw new RuntimeException("Stub!"); }
}

