/*
 * Copyright (c) 1994, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.io;


/**
 * A {@code BufferedInputStream} adds
 * functionality to another input stream-namely,
 * the ability to buffer the input and to
 * support the {@code mark} and {@code reset}
 * methods. When  the {@code BufferedInputStream}
 * is created, an internal buffer array is
 * created. As bytes  from the stream are read
 * or skipped, the internal buffer is refilled
 * as necessary  from the contained input stream,
 * many bytes at a time. The {@code mark}
 * operation  remembers a point in the input
 * stream and the {@code reset} operation
 * causes all the  bytes read since the most
 * recent {@code mark} operation to be
 * reread before new bytes are  taken from
 * the contained input stream.
 *
 * @author  Arthur van Hoff
 * @since   1.0
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class BufferedInputStream extends java.io.FilterInputStream {

/**
 * Creates a {@code BufferedInputStream}
 * and saves its  argument, the input stream
 * {@code in}, for later use. An internal
 * buffer array is created and  stored in {@code buf}.
 *
 * @param   in   the underlying input stream.
 */

public BufferedInputStream(java.io.InputStream in) { super((java.io.InputStream)null); throw new RuntimeException("Stub!"); }

/**
 * Creates a {@code BufferedInputStream}
 * with the specified buffer size,
 * and saves its  argument, the input stream
 * {@code in}, for later use.  An internal
 * buffer array of length  {@code size}
 * is created and stored in {@code buf}.
 *
 * @param   in     the underlying input stream.
 * @param   size   the buffer size.
 * @throws  java.lang.IllegalArgumentException if {@code size <= 0}.
 */

public BufferedInputStream(java.io.InputStream in, int size) { super((java.io.InputStream)null); throw new RuntimeException("Stub!"); }

/**
 * Returns an estimate of the number of bytes that can be read (or
 * skipped over) from this input stream without blocking by the next
 * invocation of a method for this input stream. The next invocation might be
 * the same thread or another thread.  A single read or skip of this
 * many bytes will not block, but may read or skip fewer bytes.
 * <p>
 * This method returns the sum of the number of bytes remaining to be read in
 * the buffer ({@code count - pos}) and the result of calling the
 * {@link java.io.FilterInputStream#in in}{@code .available()}.
 *
 * @return     an estimate of the number of bytes that can be read (or skipped
 *             over) from this input stream without blocking.
 * @throws     java.io.IOException  if this input stream has been closed by
 *                          invoking its {@link #close()} method,
 *                          or an I/O error occurs.
 */

public synchronized int available() throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Closes this input stream and releases any system resources
 * associated with the stream.
 * Once the stream has been closed, further read(), available(), reset(),
 * or skip() invocations will throw an IOException.
 * Closing a previously closed stream has no effect.
 *
 * @throws     java.io.IOException  if an I/O error occurs.
 */

public void close() throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * See the general contract of the {@code mark}
 * method of {@code InputStream}.
 *
 * @param   readlimit   the maximum limit of bytes that can be read before
 *                      the mark position becomes invalid.
 * @see     java.io.BufferedInputStream#reset()
 */

public synchronized void mark(int readlimit) { throw new RuntimeException("Stub!"); }

/**
 * Tests if this input stream supports the {@code mark}
 * and {@code reset} methods. The {@code markSupported}
 * method of {@code BufferedInputStream} returns
 * {@code true}.
 *
 * @return  a {@code boolean} indicating if this stream type supports
 *          the {@code mark} and {@code reset} methods.
 * @see     java.io.InputStream#mark(int)
 * @see     java.io.InputStream#reset()
 */

public boolean markSupported() { throw new RuntimeException("Stub!"); }

/**
 * See
 * the general contract of the {@code read}
 * method of {@code InputStream}.
 *
 * @return     the next byte of data, or {@code -1} if the end of the
 *             stream is reached.
 * @throws     java.io.IOException  if this input stream has been closed by
 *                          invoking its {@link #close()} method,
 *                          or an I/O error occurs.
 * @see        java.io.FilterInputStream#in
 */

public synchronized int read() throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Reads bytes from this byte-input stream into the specified byte array,
 * starting at the given offset.
 *
 * <p> This method implements the general contract of the corresponding
 * {@link java.io.InputStream#read(byte[],int,int) read} method of
 * the {@link java.io.InputStream InputStream} class.  As an additional
 * convenience, it attempts to read as many bytes as possible by repeatedly
 * invoking the {@code read} method of the underlying stream.  This
 * iterated {@code read} continues until one of the following
 * conditions becomes true: <ul>
 *
 *   <li> The specified number of bytes have been read,
 *
 *   <li> The {@code read} method of the underlying stream returns
 *   {@code -1}, indicating end-of-file, or
 *
 *   <li> The {@code available} method of the underlying stream
 *   returns zero, indicating that further input requests would block.
 *
 * </ul> If the first {@code read} on the underlying stream returns
 * {@code -1} to indicate end-of-file then this method returns
 * {@code -1}.  Otherwise this method returns the number of bytes
 * actually read.
 *
 * <p> Subclasses of this class are encouraged, but not required, to
 * attempt to read as many bytes as possible in the same fashion.
 *
 * @param      b     destination buffer.
 * @param      off   offset at which to start storing bytes.
 * @param      len   maximum number of bytes to read.
 * @return     the number of bytes read, or {@code -1} if the end of
 *             the stream has been reached.
 * @throws     java.io.IOException  if this input stream has been closed by
 *                          invoking its {@link #close()} method,
 *                          or an I/O error occurs.
 */

public synchronized int read(byte[] b, int off, int len) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * See the general contract of the {@code reset}
 * method of {@code InputStream}.
 * <p>
 * If {@code markpos} is {@code -1}
 * (no mark has been set or the mark has been
 * invalidated), an {@code IOException}
 * is thrown. Otherwise, {@code pos} is
 * set equal to {@code markpos}.
 *
 * @throws     java.io.IOException  if this stream has not been marked or,
 *                  if the mark has been invalidated, or the stream
 *                  has been closed by invoking its {@link #close()}
 *                  method, or an I/O error occurs.
 * @see        java.io.BufferedInputStream#mark(int)
 */

public synchronized void reset() throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * See the general contract of the {@code skip}
 * method of {@code InputStream}.
 *
 * @throws java.io.IOException  if this input stream has been closed by
 *                      invoking its {@link #close()} method,
 *                      {@code in.skip(n)} throws an IOException,
 *                      or an I/O error occurs.
 */

public synchronized long skip(long n) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * The internal buffer array where the data is stored. When necessary,
 * it may be replaced by another array of
 * a different size.
 */

protected volatile byte[] buf;

/**
 * The index one greater than the index of the last valid byte in
 * the buffer.
 * This value is always
 * in the range {@code 0} through {@code buf.length};
 * elements {@code buf[0]} through {@code buf[count-1]}
 * contain buffered input data obtained
 * from the underlying  input stream.
 */

protected int count;

/**
 * The maximum read ahead allowed after a call to the
 * {@code mark} method before subsequent calls to the
 * {@code reset} method fail.
 * Whenever the difference between {@code pos}
 * and {@code markpos} exceeds {@code marklimit},
 * then the  mark may be dropped by setting
 * {@code markpos} to {@code -1}.
 *
 * @see     java.io.BufferedInputStream#mark(int)
 * @see     java.io.BufferedInputStream#reset()
 */

protected int marklimit;

/**
 * The value of the {@code pos} field at the time the last
 * {@code mark} method was called.
 * <p>
 * This value is always
 * in the range {@code -1} through {@code pos}.
 * If there is no marked position in  the input
 * stream, this field is {@code -1}. If
 * there is a marked position in the input
 * stream,  then {@code buf[markpos]}
 * is the first byte to be supplied as input
 * after a {@code reset} operation. If
 * {@code markpos} is not {@code -1},
 * then all bytes from positions {@code buf[markpos]}
 * through  {@code buf[pos-1]} must remain
 * in the buffer array (though they may be
 * moved to  another place in the buffer array,
 * with suitable adjustments to the values
 * of {@code count},  {@code pos},
 * and {@code markpos}); they may not
 * be discarded unless and until the difference
 * between {@code pos} and {@code markpos}
 * exceeds {@code marklimit}.
 *
 * @see     java.io.BufferedInputStream#mark(int)
 * @see     java.io.BufferedInputStream#pos
 */

protected int markpos = -1; // 0xffffffff

/**
 * The current position in the buffer. This is the index of the next
 * character to be read from the {@code buf} array.
 * <p>
 * This value is always in the range {@code 0}
 * through {@code count}. If it is less
 * than {@code count}, then  {@code buf[pos]}
 * is the next byte to be supplied as input;
 * if it is equal to {@code count}, then
 * the  next {@code read} or {@code skip}
 * operation will require more bytes to be
 * read from the contained  input stream.
 *
 * @see     java.io.BufferedInputStream#buf
 */

protected int pos;
}

