/*
 * Copyright (c) 1997, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.security;


/**
 * <p> This exception is thrown by the AccessController to indicate
 * that a requested access (to a critical system resource such as the
 * file system or the network) is denied.
 *
 * <p> The reason to deny access can vary.  For example, the requested
 * permission might be of an incorrect type,  contain an invalid
 * value, or request access that is not allowed according to the
 * security policy.  Such information should be given whenever
 * possible at the time the exception is thrown.
 *
 * @author Li Gong
 * @author Roland Schemers
 * @since 1.2
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AccessControlException extends java.lang.SecurityException {

/**
 * Constructs an {@code AccessControlException} with the
 * specified, detailed message.
 *
 * @param   s   the detail message.
 */

public AccessControlException(java.lang.String s) { throw new RuntimeException("Stub!"); }

/**
 * Constructs an {@code AccessControlException} with the
 * specified, detailed message, and the requested permission that caused
 * the exception.
 *
 * @param   s   the detail message.
 * @param   p   the permission that caused the exception.
 */

public AccessControlException(java.lang.String s, java.security.Permission p) { throw new RuntimeException("Stub!"); }

/**
 * Gets the Permission object associated with this exception, or
 * null if there was no corresponding Permission object.
 *
 * @return the Permission object.
 */

public java.security.Permission getPermission() { throw new RuntimeException("Stub!"); }
}

