/*
 * Copyright (c) 1997, 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.security;

import java.util.*;

/**
 * Android doesn't support {@link java.lang.SecurityManager SecurityManager}. Do not use this class.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class PermissionCollection implements java.io.Serializable {

public PermissionCollection() { throw new RuntimeException("Stub!"); }

/**
 * Adds a permission object to the current collection of permission objects.
 *
 * @param permission the Permission object to add.
 *
 * @exception java.lang.SecurityException -  if this PermissionCollection object
 *                                 has been marked readonly
 * @exception java.lang.IllegalArgumentException - if this PermissionCollection
 *                object is a homogeneous collection and the permission
 *                is not of the correct type.
 */

public abstract void add(java.security.Permission permission);

/**
 * Returns an enumeration of all the Permission objects in the collection.
 *
 * @return an enumeration of all the Permissions.
 */

public abstract java.util.Enumeration<java.security.Permission> elements();

/**
 * Checks to see if the specified permission is implied by
 * the collection of Permission objects held in this PermissionCollection.
 *
 * @param permission the Permission object to compare.
 *
 * @return true if "permission" is implied by the  permissions in
 * the collection, false if not.
 */

public abstract boolean implies(java.security.Permission permission);

public boolean isReadOnly() { throw new RuntimeException("Stub!"); }

public void setReadOnly() { throw new RuntimeException("Stub!"); }
}

