/*
 * Copyright (c) 1997, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.util;


/**
 * This class provides a skeletal implementation of the {@code Collection}
 * interface, to minimize the effort required to implement this interface. <p>
 *
 * To implement an unmodifiable collection, the programmer needs only to
 * extend this class and provide implementations for the {@code iterator} and
 * {@code size} methods.  (The iterator returned by the {@code iterator}
 * method must implement {@code hasNext} and {@code next}.)<p>
 *
 * To implement a modifiable collection, the programmer must additionally
 * override this class's {@code add} method (which otherwise throws an
 * {@code UnsupportedOperationException}), and the iterator returned by the
 * {@code iterator} method must additionally implement its {@code remove}
 * method.<p>
 *
 * The programmer should generally provide a void (no argument) and
 * {@code Collection} constructor, as per the recommendation in the
 * {@code Collection} interface specification.<p>
 *
 * The documentation for each non-abstract method in this class describes its
 * implementation in detail.  Each of these methods may be overridden if
 * the collection being implemented admits a more efficient implementation.<p>
 *
 * This class is a member of the
 * <a href="{@docRoot}/reference/java/util/package-summary.html#CollectionsFramework">
 * Java Collections Framework</a>.
 *
 * @author  Josh Bloch
 * @author  Neal Gafter
 * @see java.util.Collection
 * @since 1.2
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class AbstractCollection<E> implements java.util.Collection<E> {

/**
 * Sole constructor.  (For invocation by subclass constructors, typically
 * implicit.)
 */

protected AbstractCollection() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 *
 * @implSpec
 * This implementation always throws an
 * {@code UnsupportedOperationException}.
 *
 * @throws java.lang.UnsupportedOperationException {@inheritDoc}
 * @throws java.lang.ClassCastException            {@inheritDoc}
 * @throws java.lang.NullPointerException          {@inheritDoc}
 * @throws java.lang.IllegalArgumentException      {@inheritDoc}
 * @throws java.lang.IllegalStateException         {@inheritDoc}
 */

public boolean add(E e) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 *
 * @implSpec
 * This implementation iterates over the specified collection, and adds
 * each object returned by the iterator to this collection, in turn.
 *
 * <p>Note that this implementation will throw an
 * {@code UnsupportedOperationException} unless {@code add} is
 * overridden (assuming the specified collection is non-empty).
 *
 * @throws java.lang.UnsupportedOperationException {@inheritDoc}
 * @throws java.lang.ClassCastException            {@inheritDoc}
 * @throws java.lang.NullPointerException          {@inheritDoc}
 * @throws java.lang.IllegalArgumentException      {@inheritDoc}
 * @throws java.lang.IllegalStateException         {@inheritDoc}
 *
 * @see #add(Object)
 */

public boolean addAll(@androidx.annotation.RecentlyNonNull java.util.Collection<? extends E> c) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 *
 * @implSpec
 * This implementation iterates over this collection, removing each
 * element using the {@code Iterator.remove} operation.  Most
 * implementations will probably choose to override this method for
 * efficiency.
 *
 * <p>Note that this implementation will throw an
 * {@code UnsupportedOperationException} if the iterator returned by this
 * collection's {@code iterator} method does not implement the
 * {@code remove} method and this collection is non-empty.
 *
 * @throws java.lang.UnsupportedOperationException {@inheritDoc}
 */

public void clear() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 *
 * @implSpec
 * This implementation iterates over the elements in the collection,
 * checking each element in turn for equality with the specified element.
 *
 * @throws java.lang.ClassCastException   {@inheritDoc}
 * @throws java.lang.NullPointerException {@inheritDoc}
 */

public boolean contains(@androidx.annotation.RecentlyNullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 *
 * @implSpec
 * This implementation iterates over the specified collection,
 * checking each element returned by the iterator in turn to see
 * if it's contained in this collection.  If all elements are so
 * contained {@code true} is returned, otherwise {@code false}.
 *
 * @throws java.lang.ClassCastException            {@inheritDoc}
 * @throws java.lang.NullPointerException          {@inheritDoc}
 * @see #contains(Object)
 */

public boolean containsAll(@androidx.annotation.RecentlyNonNull java.util.Collection<?> c) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 *
 * @implSpec
 * This implementation returns {@code size() == 0}.
 */

public boolean isEmpty() { throw new RuntimeException("Stub!"); }

/**
 * Returns an iterator over the elements contained in this collection.
 *
 * @return an iterator over the elements contained in this collection
 */

@androidx.annotation.RecentlyNonNull
public abstract java.util.Iterator<E> iterator();

/**
 * {@inheritDoc}
 *
 * @implSpec
 * This implementation iterates over the collection looking for the
 * specified element.  If it finds the element, it removes the element
 * from the collection using the iterator's remove method.
 *
 * <p>Note that this implementation throws an
 * {@code UnsupportedOperationException} if the iterator returned by this
 * collection's iterator method does not implement the {@code remove}
 * method and this collection contains the specified object.
 *
 * @throws java.lang.UnsupportedOperationException {@inheritDoc}
 * @throws java.lang.ClassCastException            {@inheritDoc}
 * @throws java.lang.NullPointerException          {@inheritDoc}
 */

public boolean remove(@androidx.annotation.RecentlyNullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 *
 * @implSpec
 * This implementation iterates over this collection, checking each
 * element returned by the iterator in turn to see if it's contained
 * in the specified collection.  If it's so contained, it's removed from
 * this collection with the iterator's {@code remove} method.
 *
 * <p>Note that this implementation will throw an
 * {@code UnsupportedOperationException} if the iterator returned by the
 * {@code iterator} method does not implement the {@code remove} method
 * and this collection contains one or more elements in common with the
 * specified collection.
 *
 * @throws java.lang.UnsupportedOperationException {@inheritDoc}
 * @throws java.lang.ClassCastException            {@inheritDoc}
 * @throws java.lang.NullPointerException          {@inheritDoc}
 *
 * @see #remove(Object)
 * @see #contains(Object)
 */

public boolean removeAll(@androidx.annotation.RecentlyNonNull java.util.Collection<?> c) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 *
 * @implSpec
 * This implementation iterates over this collection, checking each
 * element returned by the iterator in turn to see if it's contained
 * in the specified collection.  If it's not so contained, it's removed
 * from this collection with the iterator's {@code remove} method.
 *
 * <p>Note that this implementation will throw an
 * {@code UnsupportedOperationException} if the iterator returned by the
 * {@code iterator} method does not implement the {@code remove} method
 * and this collection contains one or more elements not present in the
 * specified collection.
 *
 * @throws java.lang.UnsupportedOperationException {@inheritDoc}
 * @throws java.lang.ClassCastException            {@inheritDoc}
 * @throws java.lang.NullPointerException          {@inheritDoc}
 *
 * @see #remove(Object)
 * @see #contains(Object)
 */

public boolean retainAll(@androidx.annotation.RecentlyNonNull java.util.Collection<?> c) { throw new RuntimeException("Stub!"); }

public abstract int size();

/**
 * {@inheritDoc}
 *
 * @implSpec
 * This implementation returns an array containing all the elements
 * returned by this collection's iterator, in the same order, stored in
 * consecutive elements of the array, starting with index {@code 0}.
 * The length of the returned array is equal to the number of elements
 * returned by the iterator, even if the size of this collection changes
 * during iteration, as might happen if the collection permits
 * concurrent modification during iteration.  The {@code size} method is
 * called only as an optimization hint; the correct result is returned
 * even if the iterator returns a different number of elements.
 *
 * <p>This method is equivalent to:
 *
 *  <pre> {@code
 * List<E> list = new ArrayList<E>(size());
 * for (E e : this)
 *     list.add(e);
 * return list.toArray();
 * }</pre>
 */

@androidx.annotation.RecentlyNonNull
public java.lang.Object[] toArray() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 *
 * @implSpec
 * This implementation returns an array containing all the elements
 * returned by this collection's iterator in the same order, stored in
 * consecutive elements of the array, starting with index {@code 0}.
 * If the number of elements returned by the iterator is too large to
 * fit into the specified array, then the elements are returned in a
 * newly allocated array with length equal to the number of elements
 * returned by the iterator, even if the size of this collection
 * changes during iteration, as might happen if the collection permits
 * concurrent modification during iteration.  The {@code size} method is
 * called only as an optimization hint; the correct result is returned
 * even if the iterator returns a different number of elements.
 *
 * <p>This method is equivalent to:
 *
 *  <pre> {@code
 * List<E> list = new ArrayList<E>(size());
 * for (E e : this)
 *     list.add(e);
 * return list.toArray(a);
 * }</pre>
 *
 * @throws java.lang.ArrayStoreException  {@inheritDoc}
 * @throws java.lang.NullPointerException {@inheritDoc}
 */

@androidx.annotation.RecentlyNonNull
public <T> T[] toArray(@androidx.annotation.RecentlyNonNull T[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a string representation of this collection.  The string
 * representation consists of a list of the collection's elements in the
 * order they are returned by its iterator, enclosed in square brackets
 * ({@code "[]"}).  Adjacent elements are separated by the characters
 * {@code ", "} (comma and space).  Elements are converted to strings as
 * by {@link java.lang.String#valueOf(java.lang.Object) String.valueOf(Object)}.
 *
 * @return a string representation of this collection
 */

@androidx.annotation.RecentlyNonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

