/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.crypto.hpke;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface HpkeSpi {

@android.annotation.NonNull
public byte[] engineExport(int length, @android.annotation.Nullable byte[] context);

public void engineInitRecipient(@android.annotation.NonNull byte[] encapsulated, @android.annotation.NonNull java.security.PrivateKey recipientKey, @android.annotation.Nullable byte[] info, @android.annotation.Nullable java.security.PublicKey senderKey, @android.annotation.Nullable byte[] psk, @android.annotation.Nullable byte[] psk_id) throws java.security.InvalidKeyException;

public void engineInitSender(@android.annotation.NonNull java.security.PublicKey recipientKey, @android.annotation.Nullable byte[] info, @android.annotation.Nullable java.security.PrivateKey senderKey, @android.annotation.Nullable byte[] psk, @android.annotation.Nullable byte[] psk_id) throws java.security.InvalidKeyException;

public void engineInitSenderWithSeed(@android.annotation.NonNull java.security.PublicKey recipientKey, @android.annotation.Nullable byte[] info, @android.annotation.Nullable java.security.PrivateKey senderKey, @android.annotation.Nullable byte[] psk, @android.annotation.Nullable byte[] psk_id, @android.annotation.NonNull byte[] sKe) throws java.security.InvalidKeyException;

@android.annotation.NonNull
public byte[] engineOpen(@android.annotation.NonNull byte[] ciphertext, @android.annotation.Nullable byte[] aad) throws java.security.GeneralSecurityException;

@android.annotation.NonNull
public byte[] engineSeal(@android.annotation.NonNull byte[] plaintext, @android.annotation.Nullable byte[] aad);

@android.annotation.NonNull
public byte[] getEncapsulated();
}

