/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package java.util;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface PrimitiveIterator<T, T_CONS> extends java.util.Iterator<T> {

public void forEachRemaining(T_CONS action);
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OfDouble extends java.util.PrimitiveIterator<java.lang.Double,java.util.function.DoubleConsumer> {

public default void forEachRemaining(java.util.function.Consumer<? super java.lang.Double> action) { throw new RuntimeException("Stub!"); }

public default void forEachRemaining(java.util.function.DoubleConsumer action) { throw new RuntimeException("Stub!"); }

public default java.lang.Double next() { throw new RuntimeException("Stub!"); }

public double nextDouble();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OfInt extends java.util.PrimitiveIterator<java.lang.Integer,java.util.function.IntConsumer> {

public default void forEachRemaining(java.util.function.Consumer<? super java.lang.Integer> action) { throw new RuntimeException("Stub!"); }

public default void forEachRemaining(java.util.function.IntConsumer action) { throw new RuntimeException("Stub!"); }

public default java.lang.Integer next() { throw new RuntimeException("Stub!"); }

public int nextInt();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OfLong extends java.util.PrimitiveIterator<java.lang.Long,java.util.function.LongConsumer> {

public default void forEachRemaining(java.util.function.Consumer<? super java.lang.Long> action) { throw new RuntimeException("Stub!"); }

public default void forEachRemaining(java.util.function.LongConsumer action) { throw new RuntimeException("Stub!"); }

public default java.lang.Long next() { throw new RuntimeException("Stub!"); }

public long nextLong();
}

}

