/*
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package java.lang.invoke;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface TypeDescriptor {

public java.lang.String descriptorString();
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OfField<F extends java.lang.invoke.TypeDescriptor.OfField<F>> extends java.lang.invoke.TypeDescriptor {

public F arrayType();

public F componentType();

public boolean isArray();

public boolean isPrimitive();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OfMethod<F extends java.lang.invoke.TypeDescriptor.OfField<F>, M extends java.lang.invoke.TypeDescriptor.OfMethod<F, M>> extends java.lang.invoke.TypeDescriptor {

public M changeParameterType(int index, F paramType);

public M changeReturnType(F newReturn);

public M dropParameterTypes(int start, int end);

public M insertParameterTypes(int pos, F... paramTypes);

public F[] parameterArray();

public int parameterCount();

public java.util.List<F> parameterList();

public F parameterType(int i);

public F returnType();
}

}

