/*
 * Copyright (C) 2014 The Android Open Source Project
 * Copyright (c) 1996, 2010, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.sql;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface Connection extends java.lang.AutoCloseable, java.sql.Wrapper {

public void clearWarnings() throws java.sql.SQLException;

public void close() throws java.sql.SQLException;

public void commit() throws java.sql.SQLException;

public java.sql.Array createArrayOf(java.lang.String typeName, java.lang.Object[] elements) throws java.sql.SQLException;

public java.sql.Blob createBlob() throws java.sql.SQLException;

public java.sql.Clob createClob() throws java.sql.SQLException;

public java.sql.NClob createNClob() throws java.sql.SQLException;

public java.sql.SQLXML createSQLXML() throws java.sql.SQLException;

public java.sql.Statement createStatement() throws java.sql.SQLException;

public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws java.sql.SQLException;

public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws java.sql.SQLException;

public java.sql.Struct createStruct(java.lang.String typeName, java.lang.Object[] attributes) throws java.sql.SQLException;

public boolean getAutoCommit() throws java.sql.SQLException;

public java.lang.String getCatalog() throws java.sql.SQLException;

public java.util.Properties getClientInfo() throws java.sql.SQLException;

public java.lang.String getClientInfo(java.lang.String name) throws java.sql.SQLException;

public int getHoldability() throws java.sql.SQLException;

public java.sql.DatabaseMetaData getMetaData() throws java.sql.SQLException;

public int getTransactionIsolation() throws java.sql.SQLException;

public java.util.Map<java.lang.String,java.lang.Class<?>> getTypeMap() throws java.sql.SQLException;

public java.sql.SQLWarning getWarnings() throws java.sql.SQLException;

public boolean isClosed() throws java.sql.SQLException;

public boolean isReadOnly() throws java.sql.SQLException;

public boolean isValid(int timeout) throws java.sql.SQLException;

public java.lang.String nativeSQL(java.lang.String sql) throws java.sql.SQLException;

public java.sql.CallableStatement prepareCall(java.lang.String sql) throws java.sql.SQLException;

public java.sql.CallableStatement prepareCall(java.lang.String sql, int resultSetType, int resultSetConcurrency) throws java.sql.SQLException;

public java.sql.CallableStatement prepareCall(java.lang.String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws java.sql.SQLException;

public java.sql.PreparedStatement prepareStatement(java.lang.String sql) throws java.sql.SQLException;

public java.sql.PreparedStatement prepareStatement(java.lang.String sql, int autoGeneratedKeys) throws java.sql.SQLException;

public java.sql.PreparedStatement prepareStatement(java.lang.String sql, int resultSetType, int resultSetConcurrency) throws java.sql.SQLException;

public java.sql.PreparedStatement prepareStatement(java.lang.String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws java.sql.SQLException;

public java.sql.PreparedStatement prepareStatement(java.lang.String sql, int[] columnIndexes) throws java.sql.SQLException;

public java.sql.PreparedStatement prepareStatement(java.lang.String sql, java.lang.String[] columnNames) throws java.sql.SQLException;

public void releaseSavepoint(java.sql.Savepoint savepoint) throws java.sql.SQLException;

public void rollback() throws java.sql.SQLException;

public void rollback(java.sql.Savepoint savepoint) throws java.sql.SQLException;

public void setAutoCommit(boolean autoCommit) throws java.sql.SQLException;

public void setCatalog(java.lang.String catalog) throws java.sql.SQLException;

public void setClientInfo(java.lang.String name, java.lang.String value) throws java.sql.SQLClientInfoException;

public void setClientInfo(java.util.Properties properties) throws java.sql.SQLClientInfoException;

public void setHoldability(int holdability) throws java.sql.SQLException;

public void setReadOnly(boolean readOnly) throws java.sql.SQLException;

public java.sql.Savepoint setSavepoint() throws java.sql.SQLException;

public java.sql.Savepoint setSavepoint(java.lang.String name) throws java.sql.SQLException;

public void setTransactionIsolation(int level) throws java.sql.SQLException;

public void setTypeMap(java.util.Map<java.lang.String,java.lang.Class<?>> map) throws java.sql.SQLException;

public static final int TRANSACTION_NONE = 0; // 0x0

public static final int TRANSACTION_READ_COMMITTED = 2; // 0x2

public static final int TRANSACTION_READ_UNCOMMITTED = 1; // 0x1

public static final int TRANSACTION_REPEATABLE_READ = 4; // 0x4

public static final int TRANSACTION_SERIALIZABLE = 8; // 0x8
}

