/*
 * Copyright (C) 2014 The Android Open Source Project
 * Copyright (c) 1996, 2010, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.sql;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface Statement extends java.lang.AutoCloseable, java.sql.Wrapper {

public void addBatch(java.lang.String sql) throws java.sql.SQLException;

public void cancel() throws java.sql.SQLException;

public void clearBatch() throws java.sql.SQLException;

public void clearWarnings() throws java.sql.SQLException;

public void close() throws java.sql.SQLException;

public boolean execute(java.lang.String sql) throws java.sql.SQLException;

public boolean execute(java.lang.String sql, int autoGeneratedKeys) throws java.sql.SQLException;

public boolean execute(java.lang.String sql, int[] columnIndexes) throws java.sql.SQLException;

public boolean execute(java.lang.String sql, java.lang.String[] columnNames) throws java.sql.SQLException;

public int[] executeBatch() throws java.sql.SQLException;

public java.sql.ResultSet executeQuery(java.lang.String sql) throws java.sql.SQLException;

public int executeUpdate(java.lang.String sql) throws java.sql.SQLException;

public int executeUpdate(java.lang.String sql, int autoGeneratedKeys) throws java.sql.SQLException;

public int executeUpdate(java.lang.String sql, int[] columnIndexes) throws java.sql.SQLException;

public int executeUpdate(java.lang.String sql, java.lang.String[] columnNames) throws java.sql.SQLException;

public java.sql.Connection getConnection() throws java.sql.SQLException;

public int getFetchDirection() throws java.sql.SQLException;

public int getFetchSize() throws java.sql.SQLException;

public java.sql.ResultSet getGeneratedKeys() throws java.sql.SQLException;

public int getMaxFieldSize() throws java.sql.SQLException;

public int getMaxRows() throws java.sql.SQLException;

public boolean getMoreResults() throws java.sql.SQLException;

public boolean getMoreResults(int current) throws java.sql.SQLException;

public int getQueryTimeout() throws java.sql.SQLException;

public java.sql.ResultSet getResultSet() throws java.sql.SQLException;

public int getResultSetConcurrency() throws java.sql.SQLException;

public int getResultSetHoldability() throws java.sql.SQLException;

public int getResultSetType() throws java.sql.SQLException;

public int getUpdateCount() throws java.sql.SQLException;

public java.sql.SQLWarning getWarnings() throws java.sql.SQLException;

public boolean isClosed() throws java.sql.SQLException;

public boolean isPoolable() throws java.sql.SQLException;

public void setCursorName(java.lang.String name) throws java.sql.SQLException;

public void setEscapeProcessing(boolean enable) throws java.sql.SQLException;

public void setFetchDirection(int direction) throws java.sql.SQLException;

public void setFetchSize(int rows) throws java.sql.SQLException;

public void setMaxFieldSize(int max) throws java.sql.SQLException;

public void setMaxRows(int max) throws java.sql.SQLException;

public void setPoolable(boolean poolable) throws java.sql.SQLException;

public void setQueryTimeout(int seconds) throws java.sql.SQLException;

public static final int CLOSE_ALL_RESULTS = 3; // 0x3

public static final int CLOSE_CURRENT_RESULT = 1; // 0x1

public static final int EXECUTE_FAILED = -3; // 0xfffffffd

public static final int KEEP_CURRENT_RESULT = 2; // 0x2

public static final int NO_GENERATED_KEYS = 2; // 0x2

public static final int RETURN_GENERATED_KEYS = 1; // 0x1

public static final int SUCCESS_NO_INFO = -2; // 0xfffffffe
}

