/*
 * Copyright (C) 2014 The Android Open Source Project
 * Copyright (c) 1997, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.util;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class Arrays {

Arrays() { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
@java.lang.SafeVarargs
public static <T> java.util.List<T> asList(@androidx.annotation.RecentlyNonNull T... a) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull byte[] a, byte key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull byte[] a, int fromIndex, int toIndex, byte key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull char[] a, char key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull char[] a, int fromIndex, int toIndex, char key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull double[] a, double key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull double[] a, int fromIndex, int toIndex, double key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull float[] a, float key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull float[] a, int fromIndex, int toIndex, float key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull int[] a, int key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull int[] a, int fromIndex, int toIndex, int key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, int fromIndex, int toIndex, @androidx.annotation.RecentlyNonNull java.lang.Object key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, @androidx.annotation.RecentlyNonNull java.lang.Object key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull long[] a, int fromIndex, int toIndex, long key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull long[] a, long key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull short[] a, int fromIndex, int toIndex, short key) { throw new RuntimeException("Stub!"); }

public static int binarySearch(@androidx.annotation.RecentlyNonNull short[] a, short key) { throw new RuntimeException("Stub!"); }

public static <T> int binarySearch(@androidx.annotation.RecentlyNonNull T[] a, int fromIndex, int toIndex, T key, @androidx.annotation.RecentlyNullable java.util.Comparator<? super T> c) { throw new RuntimeException("Stub!"); }

public static <T> int binarySearch(@androidx.annotation.RecentlyNonNull T[] a, T key, @androidx.annotation.RecentlyNullable java.util.Comparator<? super T> c) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNullable boolean[] a, @androidx.annotation.RecentlyNullable boolean[] b) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNonNull boolean[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull boolean[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNullable byte[] a, @androidx.annotation.RecentlyNullable byte[] b) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNonNull byte[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull byte[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNullable char[] a, @androidx.annotation.RecentlyNullable char[] b) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNonNull char[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull char[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNullable double[] a, @androidx.annotation.RecentlyNullable double[] b) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNonNull double[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull double[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNullable float[] a, @androidx.annotation.RecentlyNullable float[] b) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNonNull float[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull float[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNonNull int[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull int[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNullable int[] a, @androidx.annotation.RecentlyNullable int[] b) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNonNull long[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull long[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNullable long[] a, @androidx.annotation.RecentlyNullable long[] b) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNonNull short[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull short[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int compare(@androidx.annotation.RecentlyNullable short[] a, @androidx.annotation.RecentlyNullable short[] b) { throw new RuntimeException("Stub!"); }

public static <T extends java.lang.Comparable<? super T>> int compare(@androidx.annotation.RecentlyNonNull T[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull T[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static <T> int compare(@androidx.annotation.RecentlyNonNull T[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull T[] b, int bFromIndex, int bToIndex, @androidx.annotation.RecentlyNonNull java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

public static <T extends java.lang.Comparable<? super T>> int compare(@androidx.annotation.RecentlyNullable T[] a, @androidx.annotation.RecentlyNullable T[] b) { throw new RuntimeException("Stub!"); }

public static <T> int compare(@androidx.annotation.RecentlyNullable T[] a, @androidx.annotation.RecentlyNullable T[] b, @androidx.annotation.RecentlyNonNull java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

public static int compareUnsigned(@androidx.annotation.RecentlyNullable byte[] a, @androidx.annotation.RecentlyNullable byte[] b) { throw new RuntimeException("Stub!"); }

public static int compareUnsigned(@androidx.annotation.RecentlyNonNull byte[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull byte[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int compareUnsigned(@androidx.annotation.RecentlyNonNull int[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull int[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int compareUnsigned(@androidx.annotation.RecentlyNullable int[] a, @androidx.annotation.RecentlyNullable int[] b) { throw new RuntimeException("Stub!"); }

public static int compareUnsigned(@androidx.annotation.RecentlyNonNull long[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull long[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int compareUnsigned(@androidx.annotation.RecentlyNullable long[] a, @androidx.annotation.RecentlyNullable long[] b) { throw new RuntimeException("Stub!"); }

public static int compareUnsigned(@androidx.annotation.RecentlyNonNull short[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull short[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int compareUnsigned(@androidx.annotation.RecentlyNullable short[] a, @androidx.annotation.RecentlyNullable short[] b) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static boolean[] copyOf(@androidx.annotation.RecentlyNonNull boolean[] original, int newLength) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static byte[] copyOf(@androidx.annotation.RecentlyNonNull byte[] original, int newLength) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static char[] copyOf(@androidx.annotation.RecentlyNonNull char[] original, int newLength) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static double[] copyOf(@androidx.annotation.RecentlyNonNull double[] original, int newLength) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static float[] copyOf(@androidx.annotation.RecentlyNonNull float[] original, int newLength) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static int[] copyOf(@androidx.annotation.RecentlyNonNull int[] original, int newLength) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static long[] copyOf(@androidx.annotation.RecentlyNonNull long[] original, int newLength) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static short[] copyOf(@androidx.annotation.RecentlyNonNull short[] original, int newLength) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static <T> T[] copyOf(@androidx.annotation.RecentlyNonNull T[] original, int newLength) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static <T, U> T[] copyOf(@androidx.annotation.RecentlyNonNull U[] original, int newLength, @androidx.annotation.RecentlyNonNull java.lang.Class<? extends T[]> newType) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static boolean[] copyOfRange(@androidx.annotation.RecentlyNonNull boolean[] original, int from, int to) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static byte[] copyOfRange(@androidx.annotation.RecentlyNonNull byte[] original, int from, int to) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static char[] copyOfRange(@androidx.annotation.RecentlyNonNull char[] original, int from, int to) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static double[] copyOfRange(@androidx.annotation.RecentlyNonNull double[] original, int from, int to) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static float[] copyOfRange(@androidx.annotation.RecentlyNonNull float[] original, int from, int to) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static int[] copyOfRange(@androidx.annotation.RecentlyNonNull int[] original, int from, int to) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static long[] copyOfRange(@androidx.annotation.RecentlyNonNull long[] original, int from, int to) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static short[] copyOfRange(@androidx.annotation.RecentlyNonNull short[] original, int from, int to) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static <T> T[] copyOfRange(@androidx.annotation.RecentlyNonNull T[] original, int from, int to) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static <T, U> T[] copyOfRange(@androidx.annotation.RecentlyNonNull U[] original, int from, int to, @androidx.annotation.RecentlyNonNull java.lang.Class<? extends T[]> newType) { throw new RuntimeException("Stub!"); }

public static boolean deepEquals(@androidx.annotation.RecentlyNullable java.lang.Object[] a1, @androidx.annotation.RecentlyNullable java.lang.Object[] a2) { throw new RuntimeException("Stub!"); }

public static int deepHashCode(@androidx.annotation.RecentlyNullable java.lang.Object[] a) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.lang.String deepToString(@androidx.annotation.RecentlyNullable java.lang.Object[] a) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNullable boolean[] a, @androidx.annotation.RecentlyNullable boolean[] a2) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNonNull boolean[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull boolean[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNullable byte[] a, @androidx.annotation.RecentlyNullable byte[] a2) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNonNull byte[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull byte[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNullable char[] a, @androidx.annotation.RecentlyNullable char[] a2) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNonNull char[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull char[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNullable double[] a, @androidx.annotation.RecentlyNullable double[] a2) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNonNull double[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull double[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNullable float[] a, @androidx.annotation.RecentlyNullable float[] a2) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNonNull float[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull float[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNonNull int[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull int[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNullable int[] a, @androidx.annotation.RecentlyNullable int[] a2) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull java.lang.Object[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNullable java.lang.Object[] a, @androidx.annotation.RecentlyNullable java.lang.Object[] a2) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNonNull long[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull long[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNullable long[] a, @androidx.annotation.RecentlyNullable long[] a2) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNonNull short[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull short[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static boolean equals(@androidx.annotation.RecentlyNullable short[] a, @androidx.annotation.RecentlyNullable short[] a2) { throw new RuntimeException("Stub!"); }

public static <T> boolean equals(@androidx.annotation.RecentlyNonNull T[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull T[] b, int bFromIndex, int bToIndex, @androidx.annotation.RecentlyNonNull java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

public static <T> boolean equals(@androidx.annotation.RecentlyNullable T[] a, @androidx.annotation.RecentlyNullable T[] a2, @androidx.annotation.RecentlyNonNull java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull boolean[] a, boolean val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull boolean[] a, int fromIndex, int toIndex, boolean val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull byte[] a, byte val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull byte[] a, int fromIndex, int toIndex, byte val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull char[] a, char val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull char[] a, int fromIndex, int toIndex, char val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull double[] a, double val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull double[] a, int fromIndex, int toIndex, double val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull float[] a, float val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull float[] a, int fromIndex, int toIndex, float val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull int[] a, int val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull int[] a, int fromIndex, int toIndex, int val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, int fromIndex, int toIndex, @androidx.annotation.RecentlyNullable java.lang.Object val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, @androidx.annotation.RecentlyNullable java.lang.Object val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull long[] a, int fromIndex, int toIndex, long val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull long[] a, long val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull short[] a, int fromIndex, int toIndex, short val) { throw new RuntimeException("Stub!"); }

public static void fill(@androidx.annotation.RecentlyNonNull short[] a, short val) { throw new RuntimeException("Stub!"); }

public static int hashCode(@androidx.annotation.RecentlyNullable boolean[] a) { throw new RuntimeException("Stub!"); }

public static int hashCode(@androidx.annotation.RecentlyNullable byte[] a) { throw new RuntimeException("Stub!"); }

public static int hashCode(@androidx.annotation.RecentlyNullable char[] a) { throw new RuntimeException("Stub!"); }

public static int hashCode(@androidx.annotation.RecentlyNullable double[] a) { throw new RuntimeException("Stub!"); }

public static int hashCode(@androidx.annotation.RecentlyNullable float[] a) { throw new RuntimeException("Stub!"); }

public static int hashCode(@androidx.annotation.RecentlyNullable int[] a) { throw new RuntimeException("Stub!"); }

public static int hashCode(@androidx.annotation.RecentlyNullable java.lang.Object[] a) { throw new RuntimeException("Stub!"); }

public static int hashCode(@androidx.annotation.RecentlyNullable long[] a) { throw new RuntimeException("Stub!"); }

public static int hashCode(@androidx.annotation.RecentlyNullable short[] a) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull boolean[] a, @androidx.annotation.RecentlyNonNull boolean[] b) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull boolean[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull boolean[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull byte[] a, @androidx.annotation.RecentlyNonNull byte[] b) { throw new RuntimeException("Stub!"); }

public static int mismatch(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull char[] a, @androidx.annotation.RecentlyNonNull char[] b) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull char[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull char[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull double[] a, @androidx.annotation.RecentlyNonNull double[] b) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull double[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull double[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull float[] a, @androidx.annotation.RecentlyNonNull float[] b) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull float[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull float[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull int[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull int[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull int[] a, @androidx.annotation.RecentlyNonNull int[] b) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull java.lang.Object[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, @androidx.annotation.RecentlyNonNull java.lang.Object[] b) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull long[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull long[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull long[] a, @androidx.annotation.RecentlyNonNull long[] b) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull short[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull short[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

public static int mismatch(@androidx.annotation.RecentlyNonNull short[] a, @androidx.annotation.RecentlyNonNull short[] b) { throw new RuntimeException("Stub!"); }

public static <T> int mismatch(@androidx.annotation.RecentlyNonNull T[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull T[] b, int bFromIndex, int bToIndex, @androidx.annotation.RecentlyNonNull java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

public static <T> int mismatch(@androidx.annotation.RecentlyNonNull T[] a, @androidx.annotation.RecentlyNonNull T[] b, @androidx.annotation.RecentlyNonNull java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

public static void parallelPrefix(@androidx.annotation.RecentlyNonNull double[] array, int fromIndex, int toIndex, @androidx.annotation.RecentlyNonNull java.util.function.DoubleBinaryOperator op) { throw new RuntimeException("Stub!"); }

public static void parallelPrefix(@androidx.annotation.RecentlyNonNull double[] array, @androidx.annotation.RecentlyNonNull java.util.function.DoubleBinaryOperator op) { throw new RuntimeException("Stub!"); }

public static void parallelPrefix(@androidx.annotation.RecentlyNonNull int[] array, int fromIndex, int toIndex, @androidx.annotation.RecentlyNonNull java.util.function.IntBinaryOperator op) { throw new RuntimeException("Stub!"); }

public static void parallelPrefix(@androidx.annotation.RecentlyNonNull int[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntBinaryOperator op) { throw new RuntimeException("Stub!"); }

public static void parallelPrefix(@androidx.annotation.RecentlyNonNull long[] array, int fromIndex, int toIndex, @androidx.annotation.RecentlyNonNull java.util.function.LongBinaryOperator op) { throw new RuntimeException("Stub!"); }

public static void parallelPrefix(@androidx.annotation.RecentlyNonNull long[] array, @androidx.annotation.RecentlyNonNull java.util.function.LongBinaryOperator op) { throw new RuntimeException("Stub!"); }

public static <T> void parallelPrefix(@androidx.annotation.RecentlyNonNull T[] array, int fromIndex, int toIndex, @androidx.annotation.RecentlyNonNull java.util.function.BinaryOperator<T> op) { throw new RuntimeException("Stub!"); }

public static <T> void parallelPrefix(@androidx.annotation.RecentlyNonNull T[] array, @androidx.annotation.RecentlyNonNull java.util.function.BinaryOperator<T> op) { throw new RuntimeException("Stub!"); }

public static void parallelSetAll(@androidx.annotation.RecentlyNonNull double[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntToDoubleFunction generator) { throw new RuntimeException("Stub!"); }

public static void parallelSetAll(@androidx.annotation.RecentlyNonNull int[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntUnaryOperator generator) { throw new RuntimeException("Stub!"); }

public static void parallelSetAll(@androidx.annotation.RecentlyNonNull long[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntToLongFunction generator) { throw new RuntimeException("Stub!"); }

public static <T> void parallelSetAll(@androidx.annotation.RecentlyNonNull T[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntFunction<? extends T> generator) { throw new RuntimeException("Stub!"); }

public static void parallelSort(@androidx.annotation.RecentlyNonNull byte[] a) { throw new RuntimeException("Stub!"); }

public static void parallelSort(@androidx.annotation.RecentlyNonNull byte[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static void parallelSort(@androidx.annotation.RecentlyNonNull char[] a) { throw new RuntimeException("Stub!"); }

public static void parallelSort(@androidx.annotation.RecentlyNonNull char[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static void parallelSort(@androidx.annotation.RecentlyNonNull double[] a) { throw new RuntimeException("Stub!"); }

public static void parallelSort(@androidx.annotation.RecentlyNonNull double[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static void parallelSort(@androidx.annotation.RecentlyNonNull float[] a) { throw new RuntimeException("Stub!"); }

public static void parallelSort(@androidx.annotation.RecentlyNonNull float[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static void parallelSort(@androidx.annotation.RecentlyNonNull int[] a) { throw new RuntimeException("Stub!"); }

public static void parallelSort(@androidx.annotation.RecentlyNonNull int[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static void parallelSort(@androidx.annotation.RecentlyNonNull long[] a) { throw new RuntimeException("Stub!"); }

public static void parallelSort(@androidx.annotation.RecentlyNonNull long[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static void parallelSort(@androidx.annotation.RecentlyNonNull short[] a) { throw new RuntimeException("Stub!"); }

public static void parallelSort(@androidx.annotation.RecentlyNonNull short[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static <T extends java.lang.Comparable<? super T>> void parallelSort(@androidx.annotation.RecentlyNonNull T[] a) { throw new RuntimeException("Stub!"); }

public static <T extends java.lang.Comparable<? super T>> void parallelSort(@androidx.annotation.RecentlyNonNull T[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static <T> void parallelSort(@androidx.annotation.RecentlyNonNull T[] a, int fromIndex, int toIndex, @androidx.annotation.RecentlyNullable java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

public static <T> void parallelSort(@androidx.annotation.RecentlyNonNull T[] a, @androidx.annotation.RecentlyNullable java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

public static void setAll(@androidx.annotation.RecentlyNonNull double[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntToDoubleFunction generator) { throw new RuntimeException("Stub!"); }

public static void setAll(@androidx.annotation.RecentlyNonNull int[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntUnaryOperator generator) { throw new RuntimeException("Stub!"); }

public static void setAll(@androidx.annotation.RecentlyNonNull long[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntToLongFunction generator) { throw new RuntimeException("Stub!"); }

public static <T> void setAll(@androidx.annotation.RecentlyNonNull T[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntFunction<? extends T> generator) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull byte[] a) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull byte[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull char[] a) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull char[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull double[] a) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull double[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull float[] a) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull float[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull int[] a) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull int[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull java.lang.Object[] a) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull long[] a) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull long[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull short[] a) { throw new RuntimeException("Stub!"); }

public static void sort(@androidx.annotation.RecentlyNonNull short[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

public static <T> void sort(@androidx.annotation.RecentlyNonNull T[] a, int fromIndex, int toIndex, @androidx.annotation.RecentlyNullable java.util.Comparator<? super T> c) { throw new RuntimeException("Stub!"); }

public static <T> void sort(@androidx.annotation.RecentlyNonNull T[] a, @androidx.annotation.RecentlyNullable java.util.Comparator<? super T> c) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.util.Spliterator.OfDouble spliterator(@androidx.annotation.RecentlyNonNull double[] array) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.util.Spliterator.OfDouble spliterator(@androidx.annotation.RecentlyNonNull double[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.util.Spliterator.OfInt spliterator(@androidx.annotation.RecentlyNonNull int[] array) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.util.Spliterator.OfInt spliterator(@androidx.annotation.RecentlyNonNull int[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.util.Spliterator.OfLong spliterator(@androidx.annotation.RecentlyNonNull long[] array) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.util.Spliterator.OfLong spliterator(@androidx.annotation.RecentlyNonNull long[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static <T> java.util.Spliterator<T> spliterator(@androidx.annotation.RecentlyNonNull T[] array) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static <T> java.util.Spliterator<T> spliterator(@androidx.annotation.RecentlyNonNull T[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.util.stream.DoubleStream stream(@androidx.annotation.RecentlyNonNull double[] array) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.util.stream.DoubleStream stream(@androidx.annotation.RecentlyNonNull double[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.util.stream.IntStream stream(@androidx.annotation.RecentlyNonNull int[] array) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.util.stream.IntStream stream(@androidx.annotation.RecentlyNonNull int[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.util.stream.LongStream stream(@androidx.annotation.RecentlyNonNull long[] array) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.util.stream.LongStream stream(@androidx.annotation.RecentlyNonNull long[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static <T> java.util.stream.Stream<T> stream(@androidx.annotation.RecentlyNonNull T[] array) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static <T> java.util.stream.Stream<T> stream(@androidx.annotation.RecentlyNonNull T[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable boolean[] a) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable byte[] a) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable char[] a) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable double[] a) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable float[] a) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable int[] a) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable java.lang.Object[] a) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable long[] a) { throw new RuntimeException("Stub!"); }

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable short[] a) { throw new RuntimeException("Stub!"); }
}

