/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.RenderEffect;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Size;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.android.car.apps.common.BitmapUtils;
import com.android.car.apps.common.CrossfadeImageView;
import com.android.car.apps.common.R;

public class BackgroundImageView
extends ConstraintLayout {
    private CrossfadeImageView mImageView;
    private Size mBitmapTargetSize;
    private float mBitmapBlurPercent;
    private View mDarkeningScrim;

    public BackgroundImageView(Context context) {
        this(context, null);
    }

    public BackgroundImageView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.backgroundImageViewStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int resId;
        float extraScale;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.BackgroundImageView, defStyle, 0);
        try {
            extraScale = a.getFloat(R.styleable.BackgroundImageView_imageAdditionalScale, 1.05f);
            resId = a.getResourceId(R.styleable.BackgroundImageView_contentLayout, R.layout.background_image);
            this.mBitmapBlurPercent = a.getFloat(R.styleable.BackgroundImageView_bitmap_blur_percent, this.getResources().getFloat(R.dimen.background_bitmap_blur_percent));
            int size = a.getInteger(R.styleable.BackgroundImageView_bitmap_target_size_px, this.getResources().getInteger(R.integer.background_bitmap_target_size_px));
            this.mBitmapTargetSize = new Size(size, size);
        }
        finally {
            a.recycle();
        }
        BackgroundImageView.inflate((Context)this.getContext(), (int)resId, (ViewGroup)this);
        this.mImageView = (CrossfadeImageView)this.findViewById(R.id.background_image_image);
        this.mDarkeningScrim = this.findViewById(R.id.background_image_darkening_scrim);
        this.setImageAdditionalScale(extraScale);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int averageDim;
        float radius;
        super.onLayout(changed, left, top, right, bottom);
        if (Build.VERSION.SDK_INT >= 31 && (radius = this.mBitmapBlurPercent * (float)(averageDim = (this.mImageView.getWidth() + this.mImageView.getHeight()) / 2)) > 0.0f) {
            RenderEffect blur = RenderEffect.createBlurEffect((float)radius, (float)radius, (Shader.TileMode)Shader.TileMode.MIRROR);
            this.mImageView.setRenderEffect(blur);
        }
    }

    @Deprecated
    public void setBackgroundImage(@Nullable Bitmap bitmap, boolean showAnimation) {
        BitmapDrawable drawable = bitmap != null ? new BitmapDrawable(this.getResources(), bitmap) : null;
        this.updateImage((Drawable)drawable, showAnimation);
    }

    public void setBackgroundDrawable(@Nullable Drawable drawable) {
        this.setBackgroundDrawable(drawable, true);
    }

    public void setBackgroundDrawable(@Nullable Drawable drawable, boolean showAnimation) {
        this.updateImage(drawable, showAnimation);
    }

    private void updateImage(@Nullable Drawable drawable, boolean showAnimation) {
        if (drawable == null) {
            this.mImageView.setImageBitmap(null, false);
            return;
        }
        Bitmap bmp = BitmapUtils.fromDrawable(drawable, this.mBitmapTargetSize);
        this.mImageView.setImageBitmap(bmp, showAnimation);
        this.invalidate();
        this.requestLayout();
    }

    public void setBackgroundColor(int color2) {
        this.mImageView.setBackgroundColor(color2);
    }

    public void setDimmed(boolean dim) {
        this.mDarkeningScrim.setVisibility(dim ? 0 : 8);
    }

    public void setImageAdditionalScale(float scale) {
        this.mImageView.setImageAdditionalScale(scale);
    }
}

