/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.util.Size;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.car.apps.common.CommonFlags;
import com.android.car.apps.common.R;

public class BitmapUtils {
    private static final String TAG = "BitmapUtils";

    public static Bitmap scaleBitmap(Bitmap bm, int width, int height) {
        if (bm == null || bm.getHeight() == height && bm.getWidth() == width) {
            return bm;
        }
        float heightScale = 1.0f;
        if (bm.getHeight() > height) {
            heightScale = (float)height / (float)bm.getHeight();
        }
        float widthScale = 1.0f;
        if (bm.getWidth() > width) {
            widthScale = (float)width / (float)bm.getWidth();
        }
        float scale = heightScale > widthScale ? heightScale : widthScale;
        int scaleWidth = (int)Math.ceil((float)bm.getWidth() * scale);
        int scaleHeight = (int)Math.ceil((float)bm.getHeight() * scale);
        Bitmap scaledBm = bm;
        if (scale < 0.5f) {
            scaledBm = Bitmap.createScaledBitmap((Bitmap)scaledBm, (int)(scaleWidth * 2), (int)(scaleHeight * 2), (boolean)true);
        }
        if (scale != 1.0f) {
            Bitmap newScaledBitmap = Bitmap.createScaledBitmap((Bitmap)scaledBm, (int)scaleWidth, (int)scaleHeight, (boolean)true);
            if (scaledBm != bm) {
                scaledBm.recycle();
            }
            scaledBm = newScaledBitmap;
        }
        return scaledBm;
    }

    public static Bitmap cropBitmap(Bitmap bm, int width, int height) {
        if (bm == null) {
            return bm;
        }
        if (bm.getHeight() < height || bm.getWidth() < width) {
            if (Log.isLoggable((String)TAG, (int)4)) {
                Log.i((String)TAG, (String)String.format("Can't crop bitmap to larger dimensions (%d, %d) -> (%d, %d).", bm.getWidth(), bm.getHeight(), width, height));
            }
            return bm;
        }
        int x = (bm.getWidth() - width) / 2;
        int y = (bm.getHeight() - height) / 2;
        return Bitmap.createBitmap((Bitmap)bm, (int)x, (int)y, (int)width, (int)height);
    }

    @Nullable
    public static Bitmap createTintedBitmap(@Nullable Bitmap image, @ColorInt int colorOverlay) {
        if (image == null) {
            return null;
        }
        Bitmap clone = Bitmap.createBitmap((int)image.getWidth(), (int)image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(clone);
        canvas.drawBitmap(image, 0.0f, 0.0f, new Paint());
        canvas.drawColor(colorOverlay);
        return clone;
    }

    @NonNull
    public static Drawable maybeFlagDrawable(@NonNull Context context, @NonNull Drawable drawable) {
        if (drawable instanceof BitmapDrawable) {
            CommonFlags flags = CommonFlags.getInstance(context);
            Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
            if (flags.shouldFlagImproperImageRefs() && bitmap != null) {
                Resources res = context.getResources();
                int tint = context.getColor(R.color.improper_image_refs_tint_color);
                drawable = new BitmapDrawable(res, BitmapUtils.createTintedBitmap(bitmap, tint));
            }
        }
        return drawable;
    }

    public static Bitmap fromDrawable(Drawable drawable, @Nullable Size bitmapSize) {
        BitmapDrawable bitmapDrawable;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        Matrix matrix = new Matrix();
        if (drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0) {
            bitmapSize = new Size(1, 1);
            drawable.setBounds(0, 0, bitmapSize.getWidth(), bitmapSize.getHeight());
        } else {
            if (bitmapSize == null) {
                bitmapSize = new Size(drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
            }
            drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
            RectF srcR = new RectF(0.0f, 0.0f, (float)drawable.getIntrinsicWidth(), (float)drawable.getIntrinsicHeight());
            RectF dstR = new RectF(0.0f, 0.0f, (float)bitmapSize.getWidth(), (float)bitmapSize.getHeight());
            matrix.setRectToRect(srcR, dstR, Matrix.ScaleToFit.CENTER);
        }
        Bitmap bitmap = Bitmap.createBitmap((int)bitmapSize.getWidth(), (int)bitmapSize.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.setMatrix(matrix);
        drawable.draw(canvas);
        return bitmap;
    }
}

