/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import android.widget.SeekBar;
import com.android.car.apps.common.CarSeekBarRotaryHelper;
import com.android.car.apps.common.R;
import com.android.car.ui.uxr.DrawableStateSeekBar;

public class CarSeekBar
extends DrawableStateSeekBar {
    private Context mContext;
    private CarSeekBarRotaryHelper mCarSeekBarRotaryHelper;
    private Drawable mIcon;
    private InsetDrawable mIconContainer;

    public CarSeekBar(Context context) {
        super(context);
        this.init(context);
    }

    public CarSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public CarSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public CarSeekBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        LayerDrawable sliderIconDrawable = (LayerDrawable)this.mContext.getDrawable(R.drawable.car_seekbar_slider_icon);
        this.mIconContainer = (InsetDrawable)sliderIconDrawable.findDrawableByLayerId(R.id.seekbar_progress_icon);
        this.setSplitTrack(false);
        super.setThumb(null);
        this.setBackground(this.mContext.getDrawable(R.drawable.car_seekbar_rotary_selector));
        this.mCarSeekBarRotaryHelper = new CarSeekBarRotaryHelper((SeekBar)this, this.isClickable());
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        super.setProgressDrawable(this.mContext.getDrawable(R.drawable.car_seekbar_progress));
        this.setIcon(this.mIcon);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.adjustSize();
    }

    private void adjustSize() {
        int defaultPadding = this.mContext.getResources().getDimensionPixelSize(R.dimen.car_seekbar_padding);
        int paddingLeft = this.getPaddingLeft() >= defaultPadding ? this.getPaddingLeft() : defaultPadding;
        int paddingRight = this.getPaddingRight() >= defaultPadding ? this.getPaddingRight() : defaultPadding;
        this.setPadding(paddingLeft, this.getPaddingTop(), paddingRight, this.getPaddingBottom());
    }

    public void setThumb(Drawable thumb) {
        super.setThumb(null);
        this.setIcon(thumb);
    }

    public Drawable getThumb() {
        return this.mIcon;
    }

    public void setIcon(Drawable icon) {
        this.mIcon = icon;
        if (this.mIconContainer != null) {
            this.mIconContainer.setDrawable(this.mIcon);
            this.invalidate();
        }
    }

    public void setClickable(boolean adjustable) {
        super.setClickable(adjustable);
        if (this.mCarSeekBarRotaryHelper != null) {
            this.mCarSeekBarRotaryHelper.setAdjustable(adjustable);
        }
    }

    public void setProgressDrawable(Drawable d) {
    }
}

