/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.graphics.drawable.InsetDrawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.car.apps.common.log.L;

public class CarSeekBarProgressDrawable
extends InsetDrawable {
    private static final String TAG = CarSeekBarProgressDrawable.class.getSimpleName();
    private static final int MAX_LEVEL = 10000;

    public CarSeekBarProgressDrawable() {
        super(null, 0);
    }

    public CarSeekBarProgressDrawable(@Nullable Drawable drawable2, int inset) {
        super(drawable2, inset);
    }

    public CarSeekBarProgressDrawable(@Nullable Drawable drawable2, float inset) {
        super(drawable2, inset);
    }

    public CarSeekBarProgressDrawable(@Nullable Drawable drawable2, int insetLeft, int insetTop, int insetRight, int insetBottom) {
        super(drawable2, insetLeft, insetTop, insetRight, insetBottom);
    }

    public CarSeekBarProgressDrawable(@Nullable Drawable drawable2, float insetLeftFraction, float insetTopFraction, float insetRightFraction, float insetBottomFraction) {
        super(drawable2, insetLeftFraction, insetTopFraction, insetRightFraction, insetBottomFraction);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.onLevelChange(this.getLevel());
    }

    protected boolean onLevelChange(int level) {
        this.update(level);
        return super.onLevelChange(level);
    }

    private void update(int level) {
        Rect rect = this.getBounds();
        if (this.getDrawable() != null) {
            this.getDrawable().setBounds(rect.left, rect.top, (rect.width() - rect.height()) * level / 10000 + rect.height(), rect.bottom);
        } else {
            L.d(TAG, "The wrapped drawable is null.", new Object[0]);
        }
    }

    @Nullable
    public Drawable.ConstantState getConstantState() {
        return new CarSeekBarProgressState(super.getConstantState());
    }

    static final class CarSeekBarProgressState
    extends Drawable.ConstantState {
        private Drawable.ConstantState mWrappedState;

        CarSeekBarProgressState(Drawable.ConstantState constantState) {
            this.mWrappedState = constantState;
        }

        @NonNull
        public Drawable newDrawable() {
            return this.newDrawable(null);
        }

        @NonNull
        public Drawable newDrawable(Resources res) {
            return new CarSeekBarProgressDrawable(((DrawableWrapper)this.mWrappedState.newDrawable(res)).getDrawable(), 0);
        }

        @NonNull
        public Drawable newDrawable(@Nullable Resources res, @Nullable Resources.Theme theme) {
            return new CarSeekBarProgressDrawable(((DrawableWrapper)this.mWrappedState.newDrawable(res)).getDrawable(), 0);
        }

        public int getChangingConfigurations() {
            return this.mWrappedState.getChangingConfigurations();
        }
    }
}

