/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.view.KeyEvent;
import android.view.View;
import android.widget.SeekBar;
import com.android.car.ui.utils.DirectManipulationHelper;

public class CarSeekBarRotaryHelper {
    private SeekBar mSeekBar;
    private boolean mAdjustable;
    private boolean mInDirectManipulationMode;
    private final View.OnKeyListener mSeekBarKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (CarSeekBarRotaryHelper.this.mSeekBar == null || !CarSeekBarRotaryHelper.this.mSeekBar.isEnabled() || !CarSeekBarRotaryHelper.this.mAdjustable) {
                return false;
            }
            if (CarSeekBarRotaryHelper.this.mInDirectManipulationMode && (keyCode == 21 || keyCode == 22 || keyCode == 19 || keyCode == 20)) {
                return true;
            }
            if (keyCode == 23) {
                if (event.getAction() == 0) {
                    CarSeekBarRotaryHelper.this.setInDirectManipulationMode(v, !CarSeekBarRotaryHelper.this.mInDirectManipulationMode);
                }
                return true;
            }
            if (keyCode == 4 && CarSeekBarRotaryHelper.this.mInDirectManipulationMode) {
                if (event.getAction() == 0) {
                    CarSeekBarRotaryHelper.this.setInDirectManipulationMode(v, false);
                }
                return true;
            }
            if (CarSeekBarRotaryHelper.this.isConfirmKey(keyCode)) {
                return false;
            }
            if (event.getAction() == 0) {
                return CarSeekBarRotaryHelper.this.mSeekBar.onKeyDown(keyCode, event);
            }
            return CarSeekBarRotaryHelper.this.mSeekBar.onKeyUp(keyCode, event);
        }
    };
    private final View.OnFocusChangeListener mSeekBarFocusChangeListener = (v, hasFocus) -> {
        if (!hasFocus && this.mInDirectManipulationMode && this.mSeekBar != null) {
            this.setInDirectManipulationMode(v, false);
        }
    };
    private final View.OnGenericMotionListener mSeekBarScrollListener = (v, event) -> {
        if (!this.mInDirectManipulationMode || !this.mAdjustable || this.mSeekBar == null) {
            return false;
        }
        int adjustment = Math.round(event.getAxisValue(26));
        if (adjustment == 0) {
            return false;
        }
        int count = Math.abs(adjustment);
        int keyCode = adjustment < 0 ? 21 : 22;
        KeyEvent downEvent = new KeyEvent(event.getDownTime(), event.getEventTime(), 0, keyCode, 0);
        KeyEvent upEvent = new KeyEvent(event.getDownTime(), event.getEventTime(), 1, keyCode, 0);
        for (int i = 0; i < count; ++i) {
            this.mSeekBar.onKeyDown(keyCode, downEvent);
            this.mSeekBar.onKeyUp(keyCode, upEvent);
        }
        return true;
    };

    private void setInDirectManipulationMode(View view, boolean enable) {
        this.mInDirectManipulationMode = enable;
        DirectManipulationHelper.enableDirectManipulationMode((View)this.mSeekBar, (boolean)enable);
        view.setSelected(enable);
        this.mSeekBar.setSelected(enable);
    }

    public CarSeekBarRotaryHelper(SeekBar seekBar, boolean adjustable) {
        this.mSeekBar = seekBar;
        this.mAdjustable = adjustable;
        this.mSeekBar.setOnKeyListener(this.mSeekBarKeyListener);
        this.mSeekBar.setOnFocusChangeListener(this.mSeekBarFocusChangeListener);
        this.mSeekBar.setOnGenericMotionListener(this.mSeekBarScrollListener);
    }

    public void setAdjustable(boolean adjustable) {
        this.mAdjustable = adjustable;
    }

    private boolean isConfirmKey(int keyCode) {
        switch (keyCode) {
            case 23: 
            case 62: 
            case 66: 
            case 160: {
                return true;
            }
        }
        return false;
    }
}

