/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.annotation.SuppressLint;
import android.car.drivingstate.CarUxRestrictions;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.android.car.apps.common.R;
import com.android.car.ui.R;
import com.android.car.ui.preference.PreferenceFragment;
import com.android.car.ui.recyclerview.CarUiGridLayoutStyle;
import com.android.car.ui.recyclerview.CarUiLayoutStyle;
import com.android.car.ui.recyclerview.CarUiLinearLayoutStyle;
import com.android.car.ui.recyclerview.CarUiRecyclerView;
import com.android.car.ui.recyclerview.CarUiRecyclerViewContainer;
import com.android.car.ui.recyclerview.decorations.grid.GridDividerItemDecoration;
import com.android.car.ui.recyclerview.decorations.linear.LinearDividerItemDecoration;
import com.android.car.ui.utils.CarUxRestrictionsUtil;
import com.android.car.ui.utils.ViewUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@SuppressLint(value={"CustomViewStyleable"})
public final class CarUiRecyclerViewNoScrollbar
extends FrameLayout
implements CarUiRecyclerView,
ViewUtils.LazyLayoutView,
PreferenceFragment.AndroidxRecyclerViewProvider {
    private static final Class<?>[] LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE = new Class[]{Context.class, AttributeSet.class, Integer.TYPE, Integer.TYPE};
    @Nullable
    private RecyclerView.Adapter<?> mAdapter;
    @NonNull
    private RecyclerView mRecyclerView;
    private final CarUxRestrictionsUtil.OnUxRestrictionsChangedListener mListener = new UxRestrictionChangedListener();
    @NonNull
    private final CarUxRestrictionsUtil mCarUxRestrictionsUtil;
    @Nullable
    private GridDividerItemDecoration mDividerItemDecorationGrid;
    @Nullable
    private RecyclerView.ItemDecoration mDividerItemDecorationLinear;
    private int mNumOfColumns;
    private boolean mIsInitialized;
    private boolean mEnableDividers;
    @NonNull
    private final Set<Runnable> mOnLayoutCompletedListeners = new HashSet<Runnable>();
    @Nullable
    private CarUiLayoutStyle mLayoutStyle;
    @NonNull
    private final List<CarUiRecyclerView.OnScrollListener> mScrollListeners = new ArrayList<CarUiRecyclerView.OnScrollListener>();
    @NonNull
    private final RecyclerView.OnScrollListener mOnScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
            for (CarUiRecyclerView.OnScrollListener listener : CarUiRecyclerViewNoScrollbar.this.mScrollListeners) {
                listener.onScrollStateChanged((CarUiRecyclerView)CarUiRecyclerViewNoScrollbar.this, CarUiRecyclerViewNoScrollbar.toInternalScrollState(newState));
            }
        }

        public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
            for (CarUiRecyclerView.OnScrollListener listener : CarUiRecyclerViewNoScrollbar.this.mScrollListeners) {
                listener.onScrolled((CarUiRecyclerView)CarUiRecyclerViewNoScrollbar.this, dx, dy);
            }
        }
    };

    public CarUiRecyclerViewNoScrollbar(@NonNull Context context) {
        this(context, null, 0);
    }

    public CarUiRecyclerViewNoScrollbar(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CarUiRecyclerViewNoScrollbar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mCarUxRestrictionsUtil = CarUxRestrictionsUtil.getInstance((Context)context);
        this.init(context, attrs, defStyle);
    }

    public boolean canScrollHorizontally(int direction) {
        return this.mRecyclerView.canScrollHorizontally(direction);
    }

    public boolean canScrollVertically(int direction) {
        return this.mRecyclerView.canScrollVertically(direction);
    }

    private void init(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CarUiRecyclerView, defStyleAttr, 0);
        int layout2 = R.layout.car_ui_recycler_view_no_scrollbar;
        LayoutInflater factory = LayoutInflater.from((Context)context);
        View rootView = factory.inflate(layout2, (ViewGroup)this, true);
        ViewGroup recyclerViewContainer = (ViewGroup)this.requireViewById(R.id.car_ui_recycler_view);
        this.mRecyclerView = recyclerViewContainer instanceof CarUiRecyclerViewContainer ? (RecyclerView)recyclerViewContainer.getChildAt(0) : (RecyclerView)recyclerViewContainer;
        boolean rotaryScrollEnabled = a.getBoolean(R.styleable.CarUiRecyclerView_rotaryScrollEnabled, false);
        int orientation = a.getInt(R.styleable.CarUiRecyclerView_android_orientation, 1);
        this.initRotaryScroll((ViewGroup)this.mRecyclerView, rotaryScrollEnabled, orientation);
        int carUiRecyclerViewLayout = a.getInt(R.styleable.CarUiRecyclerView_layoutStyle, 0);
        this.mNumOfColumns = a.getInt(R.styleable.CarUiRecyclerView_numOfColumns, 2);
        this.mEnableDividers = a.getBoolean(R.styleable.CarUiRecyclerView_enableDivider, false);
        this.mDividerItemDecorationLinear = new LinearDividerItemDecoration(ContextCompat.getDrawable((Context)context, (int)R.drawable.recyclerview_divider));
        this.mDividerItemDecorationGrid = new GridDividerItemDecoration(ContextCompat.getDrawable((Context)context, (int)R.drawable.car_ui_divider), ContextCompat.getDrawable((Context)context, (int)R.drawable.car_ui_divider), this.mNumOfColumns);
        this.mIsInitialized = true;
        this.mRecyclerView.setClipToPadding(true);
        String layoutManagerInXml = a.getString(R.styleable.CarUiRecyclerView_layoutManager);
        if (!TextUtils.isEmpty((CharSequence)layoutManagerInXml)) {
            this.createLayoutManager(context, layoutManagerInXml, attrs, defStyleAttr, 0);
        } else if (carUiRecyclerViewLayout == 1) {
            this.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), this.mNumOfColumns));
        } else {
            this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        }
        if (this.isVerticalFadingEdgeEnabled()) {
            this.mRecyclerView.setVerticalFadingEdgeEnabled(true);
            this.mRecyclerView.setFadingEdgeLength(this.getVerticalFadingEdgeLength());
            this.setVerticalFadingEdgeEnabled(false);
            this.setFadingEdgeLength(0);
        }
        if (this.isHorizontalFadingEdgeEnabled()) {
            this.mRecyclerView.setHorizontalFadingEdgeEnabled(true);
            this.mRecyclerView.setFadingEdgeLength(this.getHorizontalFadingEdgeLength());
            this.setHorizontalFadingEdgeEnabled(false);
            this.setFadingEdgeLength(0);
        }
        a.recycle();
        this.mRecyclerView.setVerticalScrollBarEnabled(false);
        this.mRecyclerView.setHorizontalScrollBarEnabled(false);
    }

    public void setLayoutManager(@Nullable RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof GridLayoutManager) {
            this.setLayoutStyle((CarUiLayoutStyle)CarUiGridLayoutStyle.from((RecyclerView.LayoutManager)layoutManager));
        } else {
            this.setLayoutStyle((CarUiLayoutStyle)CarUiLinearLayoutStyle.from((RecyclerView.LayoutManager)layoutManager));
        }
    }

    @Nullable
    public RecyclerView.LayoutManager getLayoutManager() {
        return this.mRecyclerView.getLayoutManager();
    }

    public CarUiLayoutStyle getLayoutStyle() {
        return this.mLayoutStyle;
    }

    public boolean hasFixedSize() {
        return false;
    }

    public void setLayoutStyle(CarUiLayoutStyle layoutStyle) {
        Object layoutManager;
        this.mLayoutStyle = layoutStyle;
        if (layoutStyle == null) {
            this.mRecyclerView.setLayoutManager(null);
            return;
        }
        if (layoutStyle.getLayoutType() == 0) {
            layoutManager = new LinearLayoutManager(this.getContext(), layoutStyle.getOrientation(), layoutStyle.getReverseLayout()){

                public void onLayoutCompleted(RecyclerView.State state) {
                    super.onLayoutCompleted(state);
                    HashSet onLayoutCompletedListeners = new HashSet(CarUiRecyclerViewNoScrollbar.this.mOnLayoutCompletedListeners);
                    for (Runnable runnable : onLayoutCompletedListeners) {
                        runnable.run();
                    }
                }
            };
        } else {
            layoutManager = new GridLayoutManager(this.getContext(), layoutStyle.getSpanCount(), layoutStyle.getOrientation(), layoutStyle.getReverseLayout()){

                public void onLayoutCompleted(RecyclerView.State state) {
                    super.onLayoutCompleted(state);
                    HashSet onLayoutCompletedListeners = new HashSet(CarUiRecyclerViewNoScrollbar.this.mOnLayoutCompletedListeners);
                    for (Runnable runnable : onLayoutCompletedListeners) {
                        runnable.run();
                    }
                }
            };
            if (layoutStyle instanceof CarUiGridLayoutStyle) {
                ((GridLayoutManager)layoutManager).setSpanSizeLookup(((CarUiGridLayoutStyle)layoutStyle).getSpanSizeLookup());
            }
        }
        if (this.mIsInitialized) {
            this.addItemDecorations((RecyclerView.LayoutManager)layoutManager);
        }
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
    }

    @NonNull
    public View getView() {
        return this;
    }

    public void invalidateItemDecorations() {
        this.mRecyclerView.invalidateItemDecorations();
    }

    public boolean isLayoutCompleted() {
        RecyclerView.Adapter<?> adapter = this.getAdapter();
        return adapter != null && adapter.getItemCount() > 0 && !this.mRecyclerView.isComputingLayout();
    }

    public void addOnLayoutCompleteListener(@Nullable Runnable runnable) {
        if (runnable != null) {
            this.mOnLayoutCompletedListeners.add(runnable);
        }
    }

    public void removeOnLayoutCompleteListener(@Nullable Runnable runnable) {
        if (runnable != null) {
            this.mOnLayoutCompletedListeners.remove(runnable);
        }
    }

    public RecyclerView.ViewHolder findViewHolderForAdapterPosition(int position) {
        return this.mRecyclerView.findViewHolderForAdapterPosition(position);
    }

    public RecyclerView.ViewHolder findViewHolderForLayoutPosition(int position) {
        return this.mRecyclerView.findViewHolderForLayoutPosition(position);
    }

    public RecyclerView.Adapter<?> getAdapter() {
        return this.mRecyclerView.getAdapter();
    }

    public int getChildLayoutPosition(View child) {
        return this.mRecyclerView.getChildLayoutPosition(child);
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public int getRecyclerViewChildCount() {
        if (this.mRecyclerView.getLayoutManager() != null) {
            return this.mRecyclerView.getLayoutManager().getChildCount();
        }
        return 0;
    }

    public View getRecyclerViewChildAt(int index) {
        if (this.mRecyclerView.getLayoutManager() != null) {
            return this.mRecyclerView.getLayoutManager().getChildAt(index);
        }
        return null;
    }

    public int getRecyclerViewChildPosition(View child) {
        if (this.mRecyclerView.getLayoutManager() != null) {
            return this.mRecyclerView.getLayoutManager().getPosition(child);
        }
        return -1;
    }

    public View findViewByPosition(int position) {
        if (this.mRecyclerView.getLayoutManager() != null) {
            return this.mRecyclerView.getLayoutManager().findViewByPosition(position);
        }
        return null;
    }

    private static int toInternalScrollState(int state) {
        int internalState = 0;
        switch (state) {
            case 1: {
                internalState = 1;
                break;
            }
            case 2: {
                internalState = 2;
            }
        }
        return internalState;
    }

    public int getScrollState() {
        return CarUiRecyclerViewNoScrollbar.toInternalScrollState(this.mRecyclerView.getScrollState());
    }

    public void addOnScrollListener(CarUiRecyclerView.OnScrollListener scrollListener) {
        if (this.mScrollListeners.isEmpty()) {
            this.mRecyclerView.addOnScrollListener(this.mOnScrollListener);
        }
        this.mScrollListeners.add(scrollListener);
    }

    public void clearOnChildAttachStateChangeListeners() {
        this.mRecyclerView.clearOnChildAttachStateChangeListeners();
    }

    public void clearOnScrollListeners() {
        this.mScrollListeners.clear();
        this.mRecyclerView.removeOnScrollListener(this.mOnScrollListener);
    }

    public void addItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.mRecyclerView.addItemDecoration(decor);
    }

    public void addItemDecoration(@NonNull RecyclerView.ItemDecoration decor, int index) {
        this.mRecyclerView.addItemDecoration(decor, index);
    }

    public void addOnChildAttachStateChangeListener(RecyclerView.OnChildAttachStateChangeListener listener) {
        this.mRecyclerView.addOnChildAttachStateChangeListener(listener);
    }

    @NonNull
    public RecyclerView.ItemDecoration getItemDecorationAt(int index) {
        return this.mRecyclerView.getItemDecorationAt(index);
    }

    public int getItemDecorationCount() {
        return this.mRecyclerView.getItemDecorationCount();
    }

    public void removeItemDecorationAt(int index) {
        this.mRecyclerView.removeItemDecorationAt(index);
    }

    public void removeOnChildAttachStateChangeListener(RecyclerView.OnChildAttachStateChangeListener listener) {
        this.mRecyclerView.removeOnChildAttachStateChangeListener(listener);
    }

    public void removeItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.mRecyclerView.removeItemDecoration(decor);
    }

    public int findFirstCompletelyVisibleItemPosition() {
        return ((LinearLayoutManager)Objects.requireNonNull(this.mRecyclerView.getLayoutManager())).findFirstCompletelyVisibleItemPosition();
    }

    public int findFirstVisibleItemPosition() {
        return ((LinearLayoutManager)Objects.requireNonNull(this.mRecyclerView.getLayoutManager())).findFirstVisibleItemPosition();
    }

    public int findLastCompletelyVisibleItemPosition() {
        return ((LinearLayoutManager)Objects.requireNonNull(this.mRecyclerView.getLayoutManager())).findLastCompletelyVisibleItemPosition();
    }

    public int findLastVisibleItemPosition() {
        return ((LinearLayoutManager)Objects.requireNonNull(this.mRecyclerView.getLayoutManager())).findLastVisibleItemPosition();
    }

    public void setSpanSizeLookup(@NonNull GridLayoutManager.SpanSizeLookup spanSizeLookup) {
        if (this.mRecyclerView.getLayoutManager() instanceof GridLayoutManager) {
            ((GridLayoutManager)this.mRecyclerView.getLayoutManager()).setSpanSizeLookup(spanSizeLookup);
        }
    }

    private void addItemDecorations(RecyclerView.LayoutManager layoutManager) {
        this.mRecyclerView.removeItemDecoration((RecyclerView.ItemDecoration)Objects.requireNonNull(this.mDividerItemDecorationGrid));
        this.mRecyclerView.removeItemDecoration(Objects.requireNonNull(this.mDividerItemDecorationLinear));
        if (layoutManager instanceof GridLayoutManager) {
            if (this.mEnableDividers) {
                this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)Objects.requireNonNull(this.mDividerItemDecorationGrid));
            }
            this.setNumOfColumns(((GridLayoutManager)layoutManager).getSpanCount());
        } else if (this.mEnableDividers) {
            this.mRecyclerView.addItemDecoration(Objects.requireNonNull(this.mDividerItemDecorationLinear));
        }
    }

    private void initRotaryScroll(@NonNull ViewGroup recyclerView, boolean rotaryScrollEnabled, int orientation) {
        if (rotaryScrollEnabled) {
            ViewUtils.setRotaryScrollEnabled((View)recyclerView, (orientation == 1 ? 1 : 0) != 0);
        }
        recyclerView.setOnGenericMotionListener(rotaryScrollEnabled ? (v, event) -> {
            if (event.getAction() == 8 && event.getSource() == 0x400000) {
                MotionEvent mouseEvent = MotionEvent.obtain((MotionEvent)event);
                mouseEvent.setSource(8194);
                recyclerView.onGenericMotionEvent(mouseEvent);
                return true;
            }
            return false;
        } : null);
        recyclerView.setFocusable(rotaryScrollEnabled);
        recyclerView.setDescendantFocusability(131072);
        recyclerView.setDefaultFocusHighlightEnabled(false);
        if (!rotaryScrollEnabled) {
            recyclerView.setContentDescription((CharSequence)"com.android.car.ui.utils.ROTARY_CONTAINER");
        }
    }

    public void requestLayout() {
        super.requestLayout();
        if (this.mIsInitialized) {
            Parcelable recyclerViewState = null;
            if (this.mRecyclerView.getLayoutManager() != null) {
                recyclerViewState = this.mRecyclerView.getLayoutManager().onSaveInstanceState();
            }
            this.mRecyclerView.requestLayout();
            if (this.mRecyclerView.getLayoutManager() != null && recyclerViewState != null) {
                this.mRecyclerView.getLayoutManager().onRestoreInstanceState(recyclerViewState);
            }
        }
    }

    public void removeOnScrollListener(CarUiRecyclerView.OnScrollListener scrollListener) {
        this.mScrollListeners.remove(scrollListener);
        if (this.mScrollListeners.isEmpty()) {
            this.mRecyclerView.removeOnScrollListener(this.mOnScrollListener);
        }
    }

    private void setNumOfColumns(int numberOfColumns) {
        this.mNumOfColumns = numberOfColumns;
        if (this.mDividerItemDecorationGrid != null) {
            this.mDividerItemDecorationGrid.setNumOfColumns(this.mNumOfColumns);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mCarUxRestrictionsUtil.register(this.mListener);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mCarUxRestrictionsUtil.unregister(this.mListener);
    }

    public void setPadding(int left, int top, int right, int bottom) {
        int currentPosition = this.findFirstVisibleItemPosition();
        this.mRecyclerView.setPadding(0, top, 0, bottom);
        super.setPadding(left, 0, right, 0);
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
        int currentPosition = this.findFirstVisibleItemPosition();
        this.mRecyclerView.setPaddingRelative(0, top, 0, bottom);
        super.setPaddingRelative(start, 0, end, 0);
    }

    public int getPaddingTop() {
        return this.mRecyclerView.getPaddingTop();
    }

    public int getPaddingBottom() {
        return this.mRecyclerView.getPaddingBottom();
    }

    public void smoothScrollBy(int dx, int dy) {
        this.mRecyclerView.smoothScrollBy(dx, dy);
    }

    public void smoothScrollToPosition(int position) {
        this.mRecyclerView.smoothScrollToPosition(position);
    }

    public boolean post(Runnable runnable) {
        return this.mRecyclerView.post(runnable);
    }

    public void scrollToPosition(int position) {
        this.mRecyclerView.scrollToPosition(position);
    }

    public void scrollToPositionWithOffset(int position, int offset) {
        ((LinearLayoutManager)Objects.requireNonNull(this.mRecyclerView.getLayoutManager())).scrollToPositionWithOffset(position, offset);
    }

    public void scrollBy(int x, int y) {
        this.mRecyclerView.scrollBy(x, y);
    }

    public void setContentDescription(CharSequence contentDescription) {
        boolean rotaryScrollEnabled = contentDescription != null && ("com.android.car.ui.utils.HORIZONTALLY_SCROLLABLE".contentEquals(contentDescription) || "com.android.car.ui.utils.VERTICALLY_SCROLLABLE".contentEquals(contentDescription));
        int orientation = this.getLayoutStyle() == null ? 1 : this.getLayoutStyle().getOrientation();
        this.initRotaryScroll((ViewGroup)this.mRecyclerView, rotaryScrollEnabled, orientation);
        if (!rotaryScrollEnabled) {
            super.setContentDescription(contentDescription);
        }
    }

    public void setAdapter(@Nullable RecyclerView.Adapter<?> adapter) {
        if (this.mAdapter instanceof CarUiRecyclerView.OnAttachListener) {
            ((CarUiRecyclerView.OnAttachListener)this.mAdapter).onDetachedFromCarUiRecyclerView((CarUiRecyclerView)this);
        }
        this.mAdapter = adapter;
        this.mRecyclerView.setAdapter(adapter);
        if (adapter instanceof CarUiRecyclerView.OnAttachListener) {
            ((CarUiRecyclerView.OnAttachListener)adapter).onAttachedToCarUiRecyclerView((CarUiRecyclerView)this);
        }
    }

    public void setItemAnimator(RecyclerView.ItemAnimator itemAnimator) {
        this.mRecyclerView.setItemAnimator(itemAnimator);
    }

    public void setHasFixedSize(boolean hasFixedSize) {
        this.mRecyclerView.setHasFixedSize(hasFixedSize);
    }

    public void setOnFlingListener(RecyclerView.OnFlingListener listener) {
        this.mRecyclerView.setOnFlingListener(listener);
    }

    private OrientationHelper createOrientationHelper() {
        if (this.mLayoutStyle.getOrientation() == 1) {
            return OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)this.mRecyclerView.getLayoutManager());
        }
        return OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)this.mRecyclerView.getLayoutManager());
    }

    public int getEndAfterPadding() {
        if (this.mLayoutStyle == null) {
            return 0;
        }
        return this.createOrientationHelper().getEndAfterPadding();
    }

    public int getStartAfterPadding() {
        if (this.mLayoutStyle == null) {
            return 0;
        }
        return this.createOrientationHelper().getStartAfterPadding();
    }

    public int getTotalSpace() {
        if (this.mLayoutStyle == null) {
            return 0;
        }
        return this.createOrientationHelper().getTotalSpace();
    }

    public int getDecoratedStart(View child) {
        if (this.mLayoutStyle == null) {
            return 0;
        }
        return this.createOrientationHelper().getDecoratedStart(child);
    }

    public int getDecoratedEnd(View child) {
        if (this.mLayoutStyle == null) {
            return 0;
        }
        return this.createOrientationHelper().getDecoratedEnd(child);
    }

    public int getDecoratedMeasuredHeight(View child) {
        if (this.mRecyclerView.getLayoutManager() != null) {
            return this.mRecyclerView.getLayoutManager().getDecoratedMeasuredHeight(child);
        }
        return 0;
    }

    public int getDecoratedMeasuredWidth(View child) {
        if (this.mRecyclerView.getLayoutManager() != null) {
            return this.mRecyclerView.getLayoutManager().getDecoratedMeasuredWidth(child);
        }
        return 0;
    }

    public int getDecoratedMeasurementInOther(View child) {
        if (this.mLayoutStyle == null) {
            return 0;
        }
        return this.createOrientationHelper().getDecoratedMeasurementInOther(child);
    }

    public int getDecoratedMeasurement(View child) {
        if (this.mLayoutStyle == null) {
            return 0;
        }
        return this.createOrientationHelper().getDecoratedMeasurement(child);
    }

    private void createLayoutManager(Context context, String className, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (className != null && !(className = className.trim()).isEmpty()) {
            className = this.getFullClassName(context, className);
            try {
                Constructor<RecyclerView.LayoutManager> constructor;
                ClassLoader classLoader = this.isInEditMode() ? ((Object)((Object)this)).getClass().getClassLoader() : context.getClassLoader();
                Class<RecyclerView.LayoutManager> layoutManagerClass = Class.forName(className, false, classLoader).asSubclass(RecyclerView.LayoutManager.class);
                Object[] constructorArgs = null;
                try {
                    constructor = layoutManagerClass.getConstructor(LAYOUT_MANAGER_CONSTRUCTOR_SIGNATURE);
                    constructorArgs = new Object[]{context, attrs, defStyleAttr, defStyleRes};
                }
                catch (NoSuchMethodException e) {
                    try {
                        constructor = layoutManagerClass.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        e1.initCause(e);
                        throw new IllegalStateException(attrs.getPositionDescription() + ": Error creating LayoutManager " + className, e1);
                    }
                }
                constructor.setAccessible(true);
                this.setLayoutManager(constructor.newInstance(constructorArgs));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Unable to find LayoutManager " + className, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Could not instantiate the LayoutManager: " + className, e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Could not instantiate the LayoutManager: " + className, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Cannot access non-public constructor " + className, e);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException(attrs.getPositionDescription() + ": Class is not a LayoutManager " + className, e);
            }
        }
    }

    private String getFullClassName(Context context, String className) {
        if (className.charAt(0) == '.') {
            return context.getPackageName() + className;
        }
        if (className.contains(".")) {
            return className;
        }
        return RecyclerView.class.getPackage().getName() + '.' + className;
    }

    private class UxRestrictionChangedListener
    implements CarUxRestrictionsUtil.OnUxRestrictionsChangedListener {
        private UxRestrictionChangedListener() {
        }

        public void onRestrictionsChanged(@NonNull CarUxRestrictions carUxRestrictions) {
            RecyclerView.Adapter adapter = CarUiRecyclerViewNoScrollbar.this.mRecyclerView.getAdapter();
            if (!(adapter instanceof CarUiRecyclerView.ItemCap)) {
                return;
            }
            int maxItems = -1;
            if ((carUxRestrictions.getActiveRestrictions() & 0x20) != 0) {
                maxItems = carUxRestrictions.getMaxCumulativeContentItems();
            }
            int originalCount = adapter.getItemCount();
            ((CarUiRecyclerView.ItemCap)adapter).setMaxItems(maxItems);
            int newCount = adapter.getItemCount();
            if (newCount == originalCount) {
                return;
            }
            if (newCount < originalCount) {
                adapter.notifyItemRangeRemoved(newCount, originalCount - newCount);
            } else {
                adapter.notifyItemRangeInserted(originalCount, newCount - originalCount);
            }
        }
    }
}

