/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.NonNull;
import com.android.car.apps.common.R;
import com.android.car.ui.utils.CarUiUtils;

public class CommonFlags {
    private static CommonFlags sInstance;
    private final Context mApplicationContext;
    private Boolean mFlagImproperImageRefs;

    public static CommonFlags getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new CommonFlags(context);
        }
        return sInstance;
    }

    private CommonFlags(@NonNull Context context) {
        this.mApplicationContext = context.getApplicationContext() != null ? context.getApplicationContext() : context;
    }

    public boolean shouldFlagImproperImageRefs() {
        if (this.mFlagImproperImageRefs == null) {
            Resources res = this.mApplicationContext.getResources();
            this.mFlagImproperImageRefs = res.getBoolean(R.bool.flag_improper_image_references) || "1".equals(CarUiUtils.getSystemProperty((Resources)res, (int)R.string.flag_non_local_images_system_property_name));
        }
        return this.mFlagImproperImageRefs;
    }
}

