/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.transition.ChangeBounds;
import android.transition.Fade;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Space;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Preconditions;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.android.car.apps.common.CarControlBar;
import com.android.car.apps.common.ExpandableControlBar;
import com.android.car.apps.common.R;
import com.android.car.apps.common.util.ViewUtils;
import java.util.Locale;

public class ControlBar
extends RelativeLayout
implements ExpandableControlBar {
    private static final String TAG = "ControlBar";
    private ViewGroup mRowsContainer;
    private FrameLayout[] mSlots;
    private FrameLayout mFirstCreatedSlot;
    private final SparseArray<View> mFixedViews = new SparseArray();
    @Nullable
    private View mExpandCollapseView;
    private View mDefaultExpandCollapseView;
    private int mNumExtraRowsInUse;
    private boolean mIsExpanded;
    @Nullable
    private View[] mViews;
    private int mNumColumns;
    private int mNumRows;
    private boolean mExpandEnabled;
    private ExpandableControlBar.ExpandCollapseCallback mExpandCollapseCallback;
    private ViewGroup mTransitionRoot;
    private boolean mHasFocus;
    private static final float SPACERS_WEIGHT = 1.0f;
    private final ViewTreeObserver.OnGlobalFocusChangeListener mFocusChangeListener = (oldFocus, newFocus) -> {
        boolean hasFocus = this.hasFocus();
        if (this.mHasFocus && !hasFocus && this.mIsExpanded) {
            this.onExpandCollapse();
        }
        this.mHasFocus = hasFocus;
    };

    public ControlBar(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public ControlBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public ControlBar(Context context, AttributeSet attrs, int defStyleAttrs) {
        super(context, attrs, defStyleAttrs);
        this.init(context, attrs, defStyleAttrs, 0);
    }

    public ControlBar(Context context, AttributeSet attrs, int defStyleAttrs, int defStyleRes) {
        super(context, attrs, defStyleAttrs, defStyleRes);
        this.init(context, attrs, defStyleAttrs, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttrs, int defStyleRes) {
        ControlBar.inflate((Context)context, (int)R.layout.control_bar, (ViewGroup)this);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ControlBar, defStyleAttrs, defStyleRes);
        this.mNumColumns = ta.getInteger(R.styleable.ControlBar_columns, context.getResources().getInteger(R.integer.control_bar_columns));
        this.mExpandEnabled = ta.getBoolean(R.styleable.ControlBar_enableOverflow, context.getResources().getBoolean(R.bool.enable_control_bar_overflow));
        ta.recycle();
        this.mRowsContainer = (ViewGroup)this.findViewById(R.id.rows_container);
        this.mNumRows = this.mRowsContainer.getChildCount();
        Preconditions.checkState((this.mNumRows > 0 ? 1 : 0) != 0, (String)"Must have at least 1 row");
        this.mSlots = new FrameLayout[this.mNumColumns * this.mNumRows];
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        boolean attachToRoot = false;
        for (int i = 0; i < this.mNumRows; ++i) {
            ViewGroup row = (ViewGroup)this.mRowsContainer.getChildAt(this.mNumRows - i - 1);
            for (int j = 0; j < this.mNumColumns; ++j) {
                int pos = i * this.mNumColumns + j;
                this.mSlots[pos] = (FrameLayout)inflater.inflate(R.layout.control_bar_slot, row, false);
                if (this.mFirstCreatedSlot == null) {
                    this.mFirstCreatedSlot = this.mSlots[pos];
                }
                if (j > 0) {
                    Space space = new Space(context);
                    row.addView((View)space);
                    space.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
                }
                row.addView((View)this.mSlots[pos]);
            }
        }
        this.mDefaultExpandCollapseView = this.createIconButton(context.getDrawable(R.drawable.ic_overflow_button));
        this.mDefaultExpandCollapseView.setContentDescription((CharSequence)context.getString(R.string.control_bar_expand_collapse_button));
        this.mDefaultExpandCollapseView.setOnClickListener(v -> this.onExpandCollapse());
    }

    private int getSlotIndex(int slotPosition) {
        return CarControlBar.getSlotIndex(slotPosition, this.mNumColumns);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnGlobalFocusChangeListener(this.mFocusChangeListener);
    }

    protected void onDetachedFromWindow() {
        this.getViewTreeObserver().removeOnGlobalFocusChangeListener(this.mFocusChangeListener);
        super.onDetachedFromWindow();
    }

    @Override
    public void setView(@Nullable View view, int slotPosition) {
        if (view != null) {
            this.mFixedViews.put(slotPosition, (Object)view);
        } else {
            this.mFixedViews.remove(slotPosition);
        }
        this.updateViewsLayout();
    }

    public void setExpandCollapseView(@NonNull View view) {
        this.mExpandCollapseView = view;
        this.mExpandCollapseView.setOnClickListener(v -> this.onExpandCollapse());
        this.updateViewsLayout();
    }

    private View getExpandCollapseView() {
        return this.mExpandCollapseView != null ? this.mExpandCollapseView : this.mDefaultExpandCollapseView;
    }

    @Override
    public ImageButton createIconButton(Drawable icon) {
        return this.createIconButton(icon, R.layout.control_bar_button);
    }

    @Override
    public ImageButton createIconButton(Drawable icon, int viewId) {
        LayoutInflater inflater = LayoutInflater.from((Context)this.mFirstCreatedSlot.getContext());
        boolean attachToRoot = false;
        ImageButton button = (ImageButton)inflater.inflate(viewId, (ViewGroup)this.mFirstCreatedSlot, false);
        button.setImageDrawable(icon);
        return button;
    }

    @Override
    public int getFocusedViewIndex() {
        for (int slotIndex = 0; slotIndex < this.mSlots.length; ++slotIndex) {
            FrameLayout slot = this.mSlots[slotIndex];
            if (slot == null || !slot.hasFocus()) continue;
            return slotIndex;
        }
        return -1;
    }

    @Override
    public void setFocusAtViewIndex(int i) {
        if (-1 < i && i < this.mSlots.length && this.mSlots[i] != null) {
            this.mSlots[i].requestFocus();
        }
    }

    @Override
    public void registerExpandCollapseCallback(@Nullable ExpandableControlBar.ExpandCollapseCallback callback) {
        this.mExpandCollapseCallback = callback;
    }

    @Override
    public void close() {
        if (this.mIsExpanded) {
            this.onExpandCollapse();
        }
    }

    @Override
    public void setViews(@Nullable View[] views) {
        this.mViews = views;
        this.updateViewsLayout();
    }

    private void updateViewsLayout() {
        int totalSlots = this.mSlots.length;
        View[] slotViews = new View[totalSlots];
        for (int i = 0; i < this.mFixedViews.size(); ++i) {
            int index = this.getSlotIndex(this.mFixedViews.keyAt(i));
            if (index < 0 || index >= slotViews.length) continue;
            slotViews[index] = (View)this.mFixedViews.valueAt(i);
        }
        int expandCollapseIndex = this.getSlotIndex(3);
        int lastUsedIndex = 0;
        int viewsIndex = 0;
        for (int i = 0; i < totalSlots; ++i) {
            View viewToUse = null;
            if (slotViews[i] != null) {
                viewToUse = slotViews[i];
            } else if (this.mExpandEnabled && i == expandCollapseIndex && this.mViews != null && viewsIndex < this.mViews.length - 1) {
                viewToUse = this.getExpandCollapseView();
                Log.d((String)TAG, (String)("" + this + "Setting expand control"));
            } else if (this.mViews != null && viewsIndex < this.mViews.length) {
                viewToUse = this.mViews[viewsIndex];
                ++viewsIndex;
            }
            ViewUtils.setView(viewToUse, this.mSlots[i]);
            if (viewToUse == null) continue;
            lastUsedIndex = i;
        }
        int numExtraRowsInUseBefore = this.mNumExtraRowsInUse;
        this.mNumExtraRowsInUse = lastUsedIndex / this.mNumColumns;
        int lastIndex = lastUsedIndex;
        if (this.mNumRows > 1) {
            this.mRowsContainer.getViewTreeObserver().addOnGlobalLayoutListener(() -> {
                for (int i = 1; i < this.mNumRows; ++i) {
                    int rowIndex = this.mNumRows - 1 - i;
                    if (lastIndex < (i + 1) * this.mNumColumns) {
                        float lastRowX = this.mSlots[lastIndex].getX();
                        float firstRowX = this.mSlots[this.mNumColumns - 1].getX();
                        this.mRowsContainer.getChildAt(rowIndex).setTranslationX((firstRowX - lastRowX) / 2.0f);
                        continue;
                    }
                    this.mRowsContainer.getChildAt(rowIndex).setTranslationX(0.0f);
                }
            });
        }
        if (numExtraRowsInUseBefore > this.mNumExtraRowsInUse) {
            for (int i = 0; i < this.mRowsContainer.getChildCount() - 1; ++i) {
                this.mRowsContainer.getChildAt(i).setVisibility(8);
            }
        } else if (numExtraRowsInUseBefore < this.mNumExtraRowsInUse) {
            this.mRowsContainer.getChildAt(this.mRowsContainer.getChildCount() - 1).setVisibility(0);
        }
    }

    private void onExpandCollapse() {
        boolean bl = this.mIsExpanded = !this.mIsExpanded;
        if (this.mExpandCollapseView != null) {
            this.mExpandCollapseView.setSelected(this.mIsExpanded);
        }
        if (this.mExpandCollapseCallback != null) {
            this.mExpandCollapseCallback.onExpandCollapse(this.mIsExpanded);
        }
        this.mSlots[this.getSlotIndex(3)].setActivated(this.mIsExpanded);
        int animationDuration = this.getContext().getResources().getInteger(this.mIsExpanded ? R.integer.control_bar_expand_anim_duration : R.integer.control_bar_collapse_anim_duration);
        TransitionSet set = new TransitionSet().addTransition((Transition)new ChangeBounds()).addTransition((Transition)new Fade()).setDuration((long)animationDuration).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        this.maybeInitTransitionRoot();
        TransitionManager.beginDelayedTransition((ViewGroup)this.mTransitionRoot, (Transition)set);
        for (int i = 0; i < this.mNumExtraRowsInUse; ++i) {
            this.mRowsContainer.getChildAt(i).setVisibility(this.mIsExpanded ? 0 : 8);
        }
    }

    private void maybeInitTransitionRoot() {
        if (this.mTransitionRoot != null) {
            return;
        }
        this.mTransitionRoot = this;
        ViewParent viewParent = this.getParent();
        while (viewParent != null && viewParent instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)viewParent;
            if (parent.getLayoutParams().height != -2) break;
            this.mTransitionRoot = parent;
            viewParent = parent.getParent();
        }
    }

    @VisibleForTesting
    @Nullable
    View getViewAt(int rowIdx, int colIdx) {
        if (rowIdx < 0 || rowIdx > this.mRowsContainer.getChildCount()) {
            throw new IllegalArgumentException(String.format((Locale)null, "Row index out of range (requested: %d, max: %d)", rowIdx, this.mRowsContainer.getChildCount()));
        }
        if (colIdx < 0 || colIdx > this.mNumColumns) {
            throw new IllegalArgumentException(String.format((Locale)null, "Column index out of range (requested: %d, max: %d)", colIdx, this.mNumColumns));
        }
        FrameLayout slot = (FrameLayout)((LinearLayout)this.mRowsContainer.getChildAt(rowIdx)).getChildAt(colIdx + 1);
        return slot.getChildCount() > 0 ? slot.getChildAt(0) : null;
    }
}

