/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.android.car.apps.common.R;
import java.util.Locale;

public class CropAlignedImageView
extends ImageView {
    private static final int ALIGN_HORIZONTAL_CENTER = 0;
    private static final int ALIGN_HORIZONTAL_START = 1;
    private static final int ALIGN_HORIZONTAL_END = 2;
    private int mAlignHorizontal;
    private float mAdditionalScale = 1.0f;
    private int mFrameWidth;
    private int mFrameHeight;

    public CropAlignedImageView(Context context) {
        this(context, null);
    }

    public CropAlignedImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CropAlignedImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public CropAlignedImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CrossfadeImageView, defStyleAttr, defStyleRes);
        this.mAlignHorizontal = ta.getInt(R.styleable.CrossfadeImageView_align_horizontal, 0);
        ta.recycle();
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    protected boolean setFrame(int frameLeft, int frameTop, int frameRight, int frameBottom) {
        this.mFrameWidth = frameRight - frameLeft;
        this.mFrameHeight = frameBottom - frameTop;
        this.setMatrix();
        return super.setFrame(frameLeft, frameTop, frameRight, frameBottom);
    }

    private void setMatrix() {
        if (this.getDrawable() != null) {
            float originalImageWidth = this.getDrawable().getIntrinsicWidth();
            float originalImageHeight = this.getDrawable().getIntrinsicHeight();
            float fitHorizontallyScaleFactor = (float)this.mFrameWidth / originalImageWidth;
            float fitVerticallyScaleFactor = (float)this.mFrameHeight / originalImageHeight;
            float usedScaleFactor = Math.max(fitHorizontallyScaleFactor, fitVerticallyScaleFactor);
            int layoutDirection = TextUtils.getLayoutDirectionFromLocale((Locale)Locale.getDefault());
            boolean isRTL = layoutDirection == 1;
            float fittedImageWidth = originalImageWidth * usedScaleFactor;
            Matrix matrix = new Matrix();
            matrix.setTranslate(-originalImageWidth / 2.0f, -originalImageHeight / 2.0f);
            matrix.postScale(usedScaleFactor * this.mAdditionalScale, usedScaleFactor * this.mAdditionalScale);
            float dx = 0.0f;
            switch (this.mAlignHorizontal) {
                case 0: {
                    dx = (float)this.mFrameWidth / 2.0f;
                    break;
                }
                case 1: {
                    dx = isRTL ? (float)this.mFrameWidth - fittedImageWidth / 2.0f : fittedImageWidth / 2.0f;
                    break;
                }
                case 2: {
                    dx = isRTL ? fittedImageWidth / 2.0f : (float)this.mFrameWidth - fittedImageWidth / 2.0f;
                }
            }
            matrix.postTranslate(dx, (float)this.mFrameHeight / 2.0f);
            this.setImageMatrix(matrix);
        }
    }

    public void setImageAdditionalScale(float scale) {
        this.mAdditionalScale = scale;
        this.setMatrix();
    }
}

