/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.android.car.apps.common.CropAlignedImageView;
import com.android.car.apps.common.R;
import java.util.Objects;

public class CrossfadeImageView
extends FrameLayout {
    private final CropAlignedImageView mImageView1;
    private final CropAlignedImageView mImageView2;
    private CropAlignedImageView mActiveImageView;
    private CropAlignedImageView mInactiveImageView;
    private Bitmap mCurrentBitmap = null;
    private Integer mCurrentColor = null;
    private Animation mImageInAnimation;
    private Animation mImageOutAnimation;
    private final Animation.AnimationListener mAnimationListener = new Animation.AnimationListener(){

        public void onAnimationEnd(Animation animation) {
            if (CrossfadeImageView.this.mInactiveImageView != null) {
                CrossfadeImageView.this.mInactiveImageView.setVisibility(8);
            }
        }

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };

    public CrossfadeImageView(Context context) {
        this(context, null);
    }

    public CrossfadeImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CrossfadeImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public CrossfadeImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        ImageView imageViewBackground = new ImageView(context, attrs, defStyleAttr, defStyleRes);
        imageViewBackground.setLayoutParams((ViewGroup.LayoutParams)lp);
        imageViewBackground.setBackgroundColor(-16777216);
        this.addView((View)imageViewBackground);
        this.mImageView1 = new CropAlignedImageView(context, attrs, defStyleAttr, defStyleRes);
        this.mImageView1.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.addView((View)this.mImageView1);
        this.mImageView2 = new CropAlignedImageView(context, attrs, defStyleAttr, defStyleRes);
        this.mImageView2.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.addView((View)this.mImageView2);
        this.mActiveImageView = this.mImageView1;
        this.mInactiveImageView = this.mImageView2;
        this.mImageInAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.image_in);
        this.mImageInAnimation.setInterpolator((Interpolator)new DecelerateInterpolator());
        this.mImageOutAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.image_out);
    }

    public void setImageBitmap(Bitmap bitmap, boolean showAnimation) {
        if (Objects.equals(this.mCurrentBitmap, bitmap)) {
            return;
        }
        this.mCurrentBitmap = bitmap;
        this.mCurrentColor = null;
        this.mInactiveImageView.setImageBitmap(bitmap);
        if (showAnimation) {
            this.animateViews();
        } else {
            this.mActiveImageView.setImageBitmap(bitmap);
        }
    }

    public void setBackgroundColor(int color2) {
        if (this.mCurrentColor != null && this.mCurrentColor == color2) {
            return;
        }
        this.mInactiveImageView.setImageBitmap(null);
        this.mCurrentBitmap = null;
        this.mCurrentColor = color2;
        this.mInactiveImageView.setBackgroundColor(color2);
        this.animateViews();
    }

    private void animateViews() {
        this.mInactiveImageView.setVisibility(0);
        this.mInactiveImageView.startAnimation(this.mImageInAnimation);
        this.mInactiveImageView.bringToFront();
        this.mActiveImageView.startAnimation(this.mImageOutAnimation);
        this.mImageOutAnimation.setAnimationListener(this.mAnimationListener);
        if (this.mActiveImageView == this.mImageView1) {
            this.mActiveImageView = this.mImageView2;
            this.mInactiveImageView = this.mImageView1;
        } else {
            this.mActiveImageView = this.mImageView1;
            this.mInactiveImageView = this.mImageView2;
        }
    }

    public void setImageAdditionalScale(float scale) {
        this.mImageView2.setImageAdditionalScale(scale);
        this.mImageView1.setImageAdditionalScale(scale);
    }
}

