/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import java.util.Objects;

public class FragmentUtils {
    private static Object sParentForTesting;

    private FragmentUtils() {
    }

    @VisibleForTesting(otherwise=5)
    public static void setParentForTesting(Object parentForTesting) {
        sParentForTesting = parentForTesting;
    }

    @CheckResult(suggest="#checkParent(Fragment, Class)}")
    @Nullable
    public static <T> T getParent(@NonNull Fragment fragment, @NonNull Class<T> parentType) {
        if (parentType.isInstance(sParentForTesting)) {
            Object parent = sParentForTesting;
            return (T)parent;
        }
        Fragment parentFragment = fragment.getParentFragment();
        if (parentType.isInstance(parentFragment)) {
            Fragment parent = parentFragment;
            return (T)parent;
        }
        FragmentActivity activity = fragment.getActivity();
        if (parentType.isInstance(activity)) {
            FragmentActivity parent = activity;
            return (T)parent;
        }
        return null;
    }

    @CheckResult(suggest="#checkParent(Fragment, Class)}")
    @NonNull
    public static <T> T requireParent(@NonNull Fragment fragment, @NonNull Class<T> parentType) {
        return Objects.requireNonNull(FragmentUtils.getParent(fragment, parentType));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkParent(@NonNull Fragment fragment, @NonNull Class<?> parentType) throws AssertionError {
        String parent;
        if (sParentForTesting != null) {
            return;
        }
        if (FragmentUtils.getParent(fragment, parentType) != null) {
            return;
        }
        if (fragment.getParentFragment() == null) {
            if (fragment.getActivity() != null) {
                parent = fragment.getActivity().getClass().getName();
                throw new AssertionError((Object)(fragment.getClass().getName() + " must be added to a parent that implements " + parentType.getName() + ". Instead found " + parent));
            } else {
                if (fragment.getHost() == null) throw new AssertionError((Object)(fragment.getClass().getName() + " must be added to a parent that implements " + parentType.getName() + " but is currently unattached to a parent."));
                parent = fragment.getHost().getClass().getName();
            }
            throw new AssertionError((Object)(fragment.getClass().getName() + " must be added to a parent that implements " + parentType.getName() + ". Instead found " + parent));
        } else {
            parent = fragment.getParentFragment().getClass().getName();
        }
        throw new AssertionError((Object)(fragment.getClass().getName() + " must be added to a parent that implements " + parentType.getName() + ". Instead found " + parent));
    }
}

