/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.core.graphics.PathParser;
import com.android.car.apps.common.BitmapUtils;
import com.android.car.apps.common.R;

public final class IconCropper {
    private static final float ICON_MASK_SIZE = 100.0f;
    @NonNull
    private final Path mIconMask;

    public IconCropper(@NonNull Path iconMask) {
        this.mIconMask = iconMask;
    }

    public IconCropper(@NonNull Context context) {
        this(IconCropper.getDefaultMask(context));
    }

    private static Path getDefaultMask(@NonNull Context context) {
        return PathParser.createPathFromPathData((String)context.getString(R.string.config_crop_icon_mask));
    }

    @NonNull
    public Bitmap crop(@NonNull Drawable source) {
        return this.crop(BitmapUtils.fromDrawable(source, null));
    }

    @NonNull
    public Bitmap crop(@NonNull Bitmap icon) {
        int width = icon.getWidth();
        int height = icon.getHeight();
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(-1);
        canvas.save();
        canvas.scale((float)width / 100.0f, (float)height / 100.0f);
        canvas.drawPath(this.mIconMask, paint);
        canvas.restore();
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(icon, 0.0f, 0.0f, paint);
        return output;
    }
}

