/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.content.Context;
import android.graphics.Bitmap;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.util.Size;
import androidx.annotation.NonNull;

public class ImageUtils {
    private static final float MIN_BLUR = 0.1f;
    private static final float MAX_BLUR = 25.0f;

    @Deprecated
    @NonNull
    public static Bitmap blur(Context context, @NonNull Bitmap image, Size bitmapTargetSize, float bitmapBlurPercent) {
        float blurRadius = bitmapBlurPercent * (float)ImageUtils.getBitmapDimension(image = ImageUtils.maybeResize(image, bitmapTargetSize));
        if (blurRadius <= 0.1f) {
            return image;
        }
        if (blurRadius > 25.0f) {
            blurRadius = 25.0f;
        }
        if (image.getConfig() != Bitmap.Config.ARGB_8888) {
            image = image.copy(Bitmap.Config.ARGB_8888, true);
        }
        Bitmap outputBitmap = Bitmap.createBitmap((Bitmap)image);
        RenderScript rs = RenderScript.create((Context)context);
        ScriptIntrinsicBlur theIntrinsic = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
        Allocation tmpIn = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)image);
        Allocation tmpOut = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)outputBitmap);
        theIntrinsic.setRadius(blurRadius);
        theIntrinsic.setInput(tmpIn);
        theIntrinsic.forEach(tmpOut);
        tmpOut.copyTo(outputBitmap);
        return outputBitmap;
    }

    private static Bitmap maybeResize(@NonNull Bitmap image, Size bitmapTargetSize) {
        if (image.getWidth() > bitmapTargetSize.getWidth() || image.getHeight() > bitmapTargetSize.getHeight()) {
            int imageDim = ImageUtils.getBitmapDimension(image);
            float scale = (float)ImageUtils.getAverage(bitmapTargetSize) / (float)imageDim;
            int width = Math.round(scale * (float)image.getWidth());
            int height = Math.round(scale * (float)image.getHeight());
            return Bitmap.createScaledBitmap((Bitmap)image, (int)width, (int)height, (boolean)false);
        }
        return image;
    }

    private static int getAverage(@NonNull Size size) {
        return (size.getWidth() + size.getHeight()) / 2;
    }

    private static int getBitmapDimension(@NonNull Bitmap image) {
        return (image.getWidth() + image.getHeight()) / 2;
    }
}

