/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.android.car.apps.common.R;

public class LetterTileDrawable
extends Drawable {
    private static int[] sColors;
    private static int sDefaultColor;
    private static int sTileFontColor;
    private static int sDefaultWidth;
    private static int sDefaultHeight;
    private static float sLetterToTileRatio;
    private static Drawable sDefaultPersonAvatar;
    private static Drawable sDefaultBusinessAvatar;
    private static Drawable sDefaultVoicemailAvatar;
    private static final Paint sTextPaint;
    public static final int TYPE_PERSON = 1;
    public static final int TYPE_BUSINESS = 2;
    public static final int TYPE_VOICEMAIL = 3;
    public static final int TYPE_DEFAULT = 1;
    private final Paint mPaint = new Paint();
    private String mLetters;
    private int mColor;
    private int mContactType = 1;
    private float mScale = 1.0f;
    private float mOffset = 0.0f;
    private boolean mIsCircle = false;

    public LetterTileDrawable(Resources res) {
        this(res, null, null);
    }

    public LetterTileDrawable(Resources res, @Nullable String letters, @Nullable String identifier) {
        this.mPaint.setFilterBitmap(true);
        this.mPaint.setDither(true);
        this.setScale(0.7f);
        if (sColors == null) {
            sDefaultColor = res.getColor(R.color.letter_tile_default_color, null);
            TypedArray ta = res.obtainTypedArray(R.array.letter_tile_colors);
            if (ta.length() == 0) {
                sColors = new int[]{sDefaultColor};
            } else {
                sColors = new int[ta.length()];
                for (int i = ta.length() - 1; i >= 0; --i) {
                    LetterTileDrawable.sColors[i] = ta.getColor(i, sDefaultColor);
                }
                ta.recycle();
            }
            sTileFontColor = res.getColor(R.color.letter_tile_font_color, null);
            sLetterToTileRatio = res.getFraction(R.fraction.letter_to_tile_ratio, 1, 1);
            sDefaultPersonAvatar = res.getDrawable(R.drawable.ic_person, null);
            sDefaultBusinessAvatar = res.getDrawable(R.drawable.ic_person, null);
            sDefaultVoicemailAvatar = res.getDrawable(R.drawable.ic_person, null);
            sDefaultHeight = res.getDimensionPixelSize(R.dimen.letter_tile_drawable_height);
            sDefaultWidth = res.getDimensionPixelSize(R.dimen.letter_tile_drawable_width);
            sTextPaint.setTypeface(Typeface.create((String)res.getString(R.string.config_letter_tile_font_family), (int)res.getInteger(R.integer.config_letter_tile_text_style)));
            sTextPaint.setTextAlign(Paint.Align.CENTER);
            sTextPaint.setAntiAlias(true);
            sTextPaint.setColor(sTileFontColor);
        }
        this.setContactDetails(letters, identifier);
    }

    public int getIntrinsicHeight() {
        return !TextUtils.isEmpty((CharSequence)this.mLetters) ? sDefaultHeight : LetterTileDrawable.getDrawablepForContactType(this.mContactType).getIntrinsicHeight();
    }

    public int getIntrinsicWidth() {
        return !TextUtils.isEmpty((CharSequence)this.mLetters) ? sDefaultWidth : LetterTileDrawable.getDrawablepForContactType(this.mContactType).getIntrinsicWidth();
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        if (!this.isVisible() || bounds.isEmpty()) {
            return;
        }
        this.drawLetterTile(canvas);
    }

    private void drawDrawableOnCanvas(Drawable drawable2, Canvas canvas) {
        Rect destRect = this.copyBounds();
        int halfLength = (int)(this.mScale * (float)Math.min(destRect.width(), destRect.height()) / 2.0f);
        destRect.set(destRect.centerX() - halfLength, (int)((float)(destRect.centerY() - halfLength) + this.mOffset * (float)destRect.height()), destRect.centerX() + halfLength, (int)((float)(destRect.centerY() + halfLength) + this.mOffset * (float)destRect.height()));
        drawable2.setAlpha(this.mPaint.getAlpha());
        drawable2.setColorFilter(sTileFontColor, PorterDuff.Mode.SRC_IN);
        drawable2.setBounds(destRect);
        drawable2.draw(canvas);
    }

    private void drawLetterTile(Canvas canvas) {
        Rect bounds = this.getBounds();
        int minDimension = Math.min(bounds.width(), bounds.height());
        this.mPaint.setColor(this.mColor);
        if (this.mIsCircle) {
            canvas.drawCircle((float)bounds.centerX(), (float)bounds.centerY(), (float)(minDimension / 2), this.mPaint);
        } else {
            canvas.drawRect(bounds, this.mPaint);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mLetters)) {
            sTextPaint.setTextSize(this.mScale * sLetterToTileRatio * (float)minDimension);
            Paint.FontMetrics fontMetrics = sTextPaint.getFontMetrics();
            canvas.drawText(this.mLetters, (float)bounds.centerX(), (float)bounds.centerY() + this.mOffset * (float)bounds.height() - (fontMetrics.ascent + fontMetrics.descent) / 2.0f, sTextPaint);
        } else {
            Drawable drawable2 = LetterTileDrawable.getDrawablepForContactType(this.mContactType);
            this.drawDrawableOnCanvas(drawable2, canvas);
        }
    }

    public int getColor() {
        return this.mColor;
    }

    private int pickColor(String identifier) {
        if (TextUtils.isEmpty((CharSequence)identifier) || this.mContactType == 3) {
            return sDefaultColor;
        }
        int color2 = Math.abs(identifier.hashCode()) % sColors.length;
        return sColors[color2];
    }

    private static Drawable getDrawablepForContactType(int contactType) {
        switch (contactType) {
            case 1: {
                return sDefaultPersonAvatar;
            }
            case 2: {
                return sDefaultBusinessAvatar;
            }
            case 3: {
                return sDefaultVoicemailAvatar;
            }
        }
        return sDefaultPersonAvatar;
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -1;
    }

    public void setScale(float scale) {
        this.mScale = scale;
    }

    public void setOffset(float offset) {
        this.mOffset = offset;
    }

    public void setContactDetails(@Nullable String letters, @Nullable String identifier) {
        this.mLetters = letters;
        this.mColor = this.pickColor(identifier);
    }

    public void setContactType(int contactType) {
        this.mContactType = contactType;
    }

    public void setIsCircular(boolean isCircle) {
        this.mIsCircle = isCircle;
    }

    public Bitmap toBitmap(int size) {
        Bitmap largeIcon = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(largeIcon);
        Rect bounds = this.getBounds();
        this.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        this.draw(canvas);
        this.setBounds(bounds);
        return largeIcon;
    }

    static {
        sTextPaint = new Paint();
    }
}

