/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.android.car.apps.common.CarControlBar;
import com.android.car.apps.common.R;
import com.android.car.apps.common.util.ViewUtils;

public class MinimizedControlBar
extends ConstraintLayout
implements CarControlBar {
    private FrameLayout[] mSlots;
    private final View[] mFixedViews = new View[3];
    private View[] mViews;
    protected TextView mTitle;
    protected TextView mSubtitle;
    protected ImageView mContentTile;
    protected ImageView mAppIcon;
    private static final int NUM_COLUMNS = 3;

    public MinimizedControlBar(Context context) {
        this(context, null, 0);
    }

    public MinimizedControlBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MinimizedControlBar(Context context, AttributeSet attrs, int defStyleAttrs) {
        this(context, attrs, defStyleAttrs, R.layout.minimized_control_bar);
    }

    protected MinimizedControlBar(Context context, AttributeSet attrs, int defStyleAttrs, int layoutId) {
        super(context, attrs, defStyleAttrs);
        this.init(context, layoutId);
    }

    private void init(Context context, int layoutId) {
        MinimizedControlBar.inflate((Context)context, (int)layoutId, (ViewGroup)this);
        this.mViews = new View[3];
        this.mTitle = (TextView)this.findViewById(R.id.minimized_control_bar_title);
        this.mSubtitle = (TextView)this.findViewById(R.id.minimized_control_bar_subtitle);
        this.mContentTile = (ImageView)this.findViewById(R.id.minimized_control_bar_content_tile);
        this.mAppIcon = (ImageView)this.findViewById(R.id.minimized_control_bar_app_icon);
        this.mSlots = new FrameLayout[3];
        this.mSlots[0] = (FrameLayout)this.findViewById(R.id.minimized_control_bar_left_slot);
        this.mSlots[1] = (FrameLayout)this.findViewById(R.id.minimized_control_bar_main_slot);
        this.mSlots[2] = (FrameLayout)this.findViewById(R.id.minimized_control_bar_right_slot);
    }

    @Override
    public void setView(@Nullable View view, int slotPosition) {
        this.mFixedViews[slotPosition] = view;
        this.updateViewsLayout();
    }

    @Override
    public void setViews(@Nullable View[] views) {
        this.mViews = views;
        this.updateViewsLayout();
    }

    @Override
    public ImageButton createIconButton(Drawable icon) {
        return this.createIconButton(icon, R.layout.control_bar_button);
    }

    @Override
    public ImageButton createIconButton(Drawable icon, int viewId) {
        LayoutInflater inflater = LayoutInflater.from((Context)this.mSlots[0].getContext());
        boolean attachToRoot = false;
        ImageButton button = (ImageButton)inflater.inflate(viewId, (ViewGroup)this.mSlots[0], false);
        button.setImageDrawable(icon);
        return button;
    }

    @Override
    public int getFocusedViewIndex() {
        for (int slotIndex = 0; slotIndex < this.mSlots.length; ++slotIndex) {
            FrameLayout slot = this.mSlots[slotIndex];
            if (slot == null || !slot.hasFocus()) continue;
            return slotIndex;
        }
        return -1;
    }

    @Override
    public void setFocusAtViewIndex(int i) {
        if (-1 < i && i < this.mSlots.length && this.mSlots[i] != null) {
            this.mSlots[i].requestFocus();
        }
    }

    private void updateViewsLayout() {
        int viewIndex = 0;
        for (int i = 0; i < 3; ++i) {
            View viewToUse = null;
            if (this.mFixedViews[i] != null) {
                viewToUse = this.mFixedViews[i];
            } else if (this.mViews != null && viewIndex < this.mViews.length) {
                viewToUse = this.mViews[viewIndex];
                ++viewIndex;
            }
            ViewUtils.setView(viewToUse, this.mSlots[CarControlBar.getSlotIndex(i, 3)]);
        }
    }
}

