/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import androidx.annotation.NonNull;

public class RoundedDrawable
extends DrawableWrapper {
    private final float mCornerRatio;
    private Path mClippedPath;

    public RoundedDrawable(Drawable drawable2, float cornerRatio) {
        super(drawable2);
        this.mCornerRatio = cornerRatio;
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.getDrawable() == null) {
            return;
        }
        canvas.clipPath(this.mClippedPath);
        this.getDrawable().draw(canvas);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (this.getDrawable() == null) {
            return;
        }
        this.mClippedPath = new Path();
        RectF rect = new RectF(this.getBounds());
        float adjustedCornerRadius = this.mCornerRatio * (float)Math.min(this.getDrawable().getIntrinsicHeight(), this.getDrawable().getIntrinsicWidth());
        this.mClippedPath.addRoundRect(rect, adjustedCornerRadius, adjustedCornerRadius, Path.Direction.CW);
    }
}

