/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.android.car.apps.common.R;

@SuppressLint(value={"AppCompatCustomView"})
public class TappableTextView
extends TextView {
    private final int mHideViewMode;
    private final int mEndIconResId;
    private final int mTappableStyle;
    private final int mNormalStyle;
    private boolean mDrawLinkIcon;
    private Drawable mEndIcon;
    private final Rect mEndIconRect = new Rect();

    public TappableTextView(@NonNull Context context) {
        this(context, null);
    }

    public TappableTextView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TappableTextView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TappableTextView, defStyleAttr, 0);
        try {
            this.mEndIconResId = a.getResourceId(R.styleable.TappableTextView_endDrawable, R.drawable.ic_link_indicator);
            this.mTappableStyle = a.getResourceId(R.styleable.TappableTextView_tappableTextStyle, 0);
            this.mNormalStyle = a.getResourceId(R.styleable.TappableTextView_normalTextStyle, 0);
            this.mHideViewMode = a.getInteger(R.styleable.TappableTextView_hideViewMode, 4);
        }
        finally {
            a.recycle();
        }
    }

    public void hideView(boolean hidden) {
        this.setVisibility(hidden ? this.mHideViewMode : 0);
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        super.setOnClickListener(l);
        this.onNewClickListener(l);
    }

    protected void onNewClickListener(@Nullable View.OnClickListener l) {
        int drawableId;
        int styleId;
        this.mDrawLinkIcon = l != null;
        Context ctx = this.getContext();
        if (l != null) {
            styleId = this.mTappableStyle;
            TypedValue value = new TypedValue();
            ctx.getTheme().resolveAttribute(16843534, value, true);
            drawableId = value.resourceId;
        } else {
            styleId = this.mNormalStyle;
            drawableId = 0;
        }
        this.setBackgroundResource(drawableId);
        this.setTextAppearance(styleId);
        this.invalidate();
    }

    @SuppressLint(value={"UseCompatLoadingForDrawables"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setCompoundDrawablesRelative(null, null, null, null);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mDrawLinkIcon) {
            if (this.mEndIcon == null && this.mEndIconResId != 0) {
                this.mEndIcon = ContextCompat.getDrawable((Context)this.getContext(), (int)this.mEndIconResId);
            }
            if (this.mEndIcon != null) {
                int height = this.getMeasuredHeight();
                this.mEndIconRect.set(0, 0, height, height);
                this.mEndIcon.setBounds(this.mEndIconRect);
                this.setCompoundDrawablesRelative(null, null, this.mEndIcon, null);
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }
    }
}

