/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;

public final class UriUtils {
    private static final String SCHEME_SHORTCUT_ICON_RESOURCE = "shortcut.icon.resource";
    private static final String SCHEME_DELIMITER = "://";
    private static final String URI_PATH_DELIMITER = "/";
    private static final String URI_PACKAGE_DELIMITER = ":";
    private static final String HTTP_PREFIX = "http";
    private static final String HTTPS_PREFIX = "https";
    private static final String SCHEME_ACCOUNT_IMAGE = "image.account";
    private static final String ACCOUNT_IMAGE_CHANGE_NOTIFY_URI = "change_notify_uri";
    private static final String DETAIL_DIALOG_URI_DIALOG_TITLE = "detail_dialog_title";
    private static final String DETAIL_DIALOG_URI_DIALOG_DESCRIPTION = "detail_dialog_description";
    private static final String DETAIL_DIALOG_URI_DIALOG_ACTION_START_INDEX = "detail_dialog_action_start_index";
    private static final String DETAIL_DIALOG_URI_DIALOG_ACTION_START_NAME = "detail_dialog_action_start_name";

    private UriUtils() {
    }

    public static boolean isEmpty(@Nullable Uri uri) {
        return uri == null || TextUtils.isEmpty((CharSequence)uri.toString());
    }

    public static String getAndroidResourceUri(Context context, int resourceId) {
        return UriUtils.getAndroidResourceUri(context.getResources(), resourceId);
    }

    public static String getAndroidResourceUri(Resources resources, int resourceId) {
        return "android.resource://" + resources.getResourceName(resourceId).replace(URI_PACKAGE_DELIMITER, URI_PATH_DELIMITER);
    }

    @Nullable
    public static Drawable getDrawable(Context context, Intent.ShortcutIconResource r) {
        Resources resources = null;
        try {
            resources = context.getPackageManager().getResourcesForApplication(r.packageName);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (resources == null) {
            return null;
        }
        int id2 = resources.getIdentifier(r.resourceName, null, null);
        return resources.getDrawable(id2, null);
    }

    public static Uri getShortcutIconResourceUri(Intent.ShortcutIconResource iconResource) {
        return Uri.parse((String)("shortcut.icon.resource://" + iconResource.packageName + URI_PATH_DELIMITER + iconResource.resourceName.replace(URI_PACKAGE_DELIMITER, URI_PATH_DELIMITER)));
    }

    public static Uri getAndroidResourceUri(String resourceName) {
        Uri uri = Uri.parse((String)("android.resource://" + resourceName.replace(URI_PACKAGE_DELIMITER, URI_PATH_DELIMITER)));
        return uri;
    }

    public static boolean isAndroidResourceUri(Uri uri) {
        return "android.resource".equals(uri.getScheme());
    }

    public static Uri getAccountImageUri(String accountName) {
        Uri uri = Uri.parse((String)("image.account://" + accountName));
        return uri;
    }

    public static Uri getAccountImageUri(String accountName, Uri changeNotifyUri) {
        Uri uri = Uri.parse((String)("image.account://" + accountName));
        if (changeNotifyUri != null) {
            uri = uri.buildUpon().appendQueryParameter(ACCOUNT_IMAGE_CHANGE_NOTIFY_URI, changeNotifyUri.toString()).build();
        }
        return uri;
    }

    public static boolean isAccountImageUri(Uri uri) {
        return uri == null ? false : SCHEME_ACCOUNT_IMAGE.equals(uri.getScheme());
    }

    public static String getAccountName(Uri uri) {
        if (UriUtils.isAccountImageUri(uri)) {
            String accountName = uri.getAuthority() + uri.getPath();
            return accountName;
        }
        throw new IllegalArgumentException("Invalid account image URI. " + uri);
    }

    public static Uri getAccountImageChangeNotifyUri(Uri uri) {
        if (UriUtils.isAccountImageUri(uri)) {
            String notifyUri = uri.getQueryParameter(ACCOUNT_IMAGE_CHANGE_NOTIFY_URI);
            if (notifyUri == null) {
                return null;
            }
            return Uri.parse((String)notifyUri);
        }
        throw new IllegalArgumentException("Invalid account image URI. " + uri);
    }

    @Nullable
    public static String getPackageName(Context context, Uri uri) {
        PackageManager pm = context.getPackageManager();
        ProviderInfo info = pm.resolveContentProvider(uri.getAuthority(), 131072);
        return info != null ? info.packageName : uri.getAuthority();
    }

    public static boolean isContentUri(Uri uri) {
        return "content".equals(uri.getScheme()) || "file".equals(uri.getScheme());
    }

    public static boolean isShortcutIconResourceUri(Uri uri) {
        return SCHEME_SHORTCUT_ICON_RESOURCE.equals(uri.getScheme());
    }

    public static Intent.ShortcutIconResource getIconResource(Context context, Uri uri) {
        if (UriUtils.isAndroidResourceUri(uri)) {
            Intent.ShortcutIconResource iconResource = new Intent.ShortcutIconResource();
            iconResource.packageName = UriUtils.getPackageName(context, uri);
            int resStart = "android.resource".length() + SCHEME_DELIMITER.length() + uri.getAuthority().length();
            iconResource.resourceName = iconResource.packageName + uri.toString().substring(resStart).replaceFirst(URI_PATH_DELIMITER, URI_PACKAGE_DELIMITER);
            return iconResource;
        }
        if (UriUtils.isShortcutIconResourceUri(uri)) {
            Intent.ShortcutIconResource iconResource = new Intent.ShortcutIconResource();
            iconResource.packageName = UriUtils.getPackageName(context, uri);
            iconResource.resourceName = uri.toString().substring(SCHEME_SHORTCUT_ICON_RESOURCE.length() + SCHEME_DELIMITER.length() + uri.getAuthority().length() + URI_PATH_DELIMITER.length()).replaceFirst(URI_PATH_DELIMITER, URI_PACKAGE_DELIMITER);
            return iconResource;
        }
        throw new IllegalArgumentException("Invalid resource URI. " + uri);
    }

    public static boolean isWebUri(Uri resourceUri) {
        String scheme = resourceUri.getScheme() == null ? null : resourceUri.getScheme().toLowerCase();
        return HTTP_PREFIX.equals(scheme) || HTTPS_PREFIX.equals(scheme);
    }

    public static Uri getSubactionDialogUri(Uri uri, String dialogTitle, String dialogDescription) {
        return UriUtils.getSubactionDialogUri(uri, dialogTitle, dialogDescription, null, -1);
    }

    public static Uri getSubactionDialogUri(Uri uri, String dialogTitle, String dialogDescription, int startIndex) {
        return UriUtils.getSubactionDialogUri(uri, dialogTitle, dialogDescription, null, startIndex);
    }

    public static Uri getSubactionDialogUri(Uri uri, String dialogTitle, String dialogDescription, String startName) {
        return UriUtils.getSubactionDialogUri(uri, dialogTitle, dialogDescription, startName, -1);
    }

    public static Uri getSubactionDialogUri(Uri uri, String dialogTitle, String dialogDescription, String startName, int startIndex) {
        if (uri == null || !UriUtils.isContentUri(uri)) {
            return null;
        }
        Uri.Builder builder = uri.buildUpon();
        if (!TextUtils.isEmpty((CharSequence)dialogTitle)) {
            builder.appendQueryParameter(DETAIL_DIALOG_URI_DIALOG_TITLE, dialogTitle);
        }
        if (!TextUtils.isEmpty((CharSequence)DETAIL_DIALOG_URI_DIALOG_DESCRIPTION)) {
            builder.appendQueryParameter(DETAIL_DIALOG_URI_DIALOG_DESCRIPTION, dialogDescription);
        }
        if (startIndex != -1) {
            builder.appendQueryParameter(DETAIL_DIALOG_URI_DIALOG_ACTION_START_INDEX, Integer.toString(startIndex));
        }
        if (!TextUtils.isEmpty((CharSequence)startName)) {
            builder.appendQueryParameter(DETAIL_DIALOG_URI_DIALOG_ACTION_START_NAME, startName);
        }
        return builder.build();
    }

    public static String getSubactionDialogTitle(Uri uri) {
        if (uri == null || !UriUtils.isContentUri(uri)) {
            return null;
        }
        return uri.getQueryParameter(DETAIL_DIALOG_URI_DIALOG_TITLE);
    }

    public static String getSubactionDialogDescription(Uri uri) {
        if (uri == null || !UriUtils.isContentUri(uri)) {
            return null;
        }
        return uri.getQueryParameter(DETAIL_DIALOG_URI_DIALOG_DESCRIPTION);
    }

    public static int getSubactionDialogActionStartIndex(Uri uri) {
        if (uri == null || !UriUtils.isContentUri(uri)) {
            return -1;
        }
        String startIndexStr = uri.getQueryParameter(DETAIL_DIALOG_URI_DIALOG_ACTION_START_INDEX);
        if (!TextUtils.isEmpty((CharSequence)startIndexStr) && TextUtils.isDigitsOnly((CharSequence)startIndexStr)) {
            return Integer.parseInt(startIndexStr);
        }
        return -1;
    }

    public static String getSubactionDialogActionStartName(Uri uri) {
        if (uri == null || !UriUtils.isContentUri(uri)) {
            return null;
        }
        return uri.getQueryParameter(DETAIL_DIALOG_URI_DIALOG_ACTION_START_NAME);
    }
}

