/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.car.drivingstate.CarUxRestrictions;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import com.android.car.apps.common.R;
import com.android.car.ui.utils.CarUxRestrictionsUtil;

public class UxrButton
extends TextView {
    private static final int[] STATE_UX_RESTRICTED = new int[]{R.attr.state_ux_restricted};
    private CarUxRestrictionsUtil mCarUxRestrictionsUtil;
    private CarUxRestrictions mActiveCarUxRestrictions;
    private View.OnClickListener mOnClickListenerDelegate;
    private int mRestrictions;
    private final Handler mHandler = new Handler();
    private final CarUxRestrictionsUtil.OnUxRestrictionsChangedListener mListener = this::updateActiveCarUxRestrictions;
    private final View.OnClickListener mOnClickListenerWrapper = v -> {
        if (this.mOnClickListenerDelegate == null) {
            return;
        }
        if (this.isRestricted()) {
            this.showBlockingMessage();
        } else {
            this.mOnClickListenerDelegate.onClick(v);
        }
    };

    public UxrButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public UxrButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public UxrButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public UxrButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.mCarUxRestrictionsUtil = CarUxRestrictionsUtil.getInstance((Context)context);
        super.setOnClickListener(this.mOnClickListenerWrapper);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.UxrButton);
        try {
            this.mRestrictions = a.getInteger(R.styleable.UxrButton_carUxRestrictions, 511);
        }
        finally {
            a.recycle();
        }
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isRestricted()) {
            UxrButton.mergeDrawableStates((int[])drawableState, (int[])STATE_UX_RESTRICTED);
        }
        return drawableState;
    }

    public void setOnClickListener(@Nullable View.OnClickListener listener) {
        this.mOnClickListenerDelegate = listener;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mCarUxRestrictionsUtil.register(this.mListener);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mCarUxRestrictionsUtil.unregister(this.mListener);
    }

    public void setUxRestrictions(int uxRestrictions) {
        this.mRestrictions = uxRestrictions;
        this.mHandler.post(() -> this.refreshDrawableState());
    }

    private boolean isRestricted() {
        return CarUxRestrictionsUtil.isRestricted((int)this.mRestrictions, (CarUxRestrictions)this.mActiveCarUxRestrictions);
    }

    private void updateActiveCarUxRestrictions(CarUxRestrictions carUxRestrictions) {
        this.mActiveCarUxRestrictions = carUxRestrictions;
        this.mHandler.post(() -> this.refreshDrawableState());
    }

    protected void showBlockingMessage() {
        Toast.makeText((Context)this.getContext(), (int)R.string.restricted_while_driving, (int)0).show();
    }
}

