/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common;

import android.car.drivingstate.CarUxRestrictions;
import android.content.Context;
import android.graphics.Rect;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.android.car.ui.utils.CarUxRestrictionsUtil;

public class UxrTextView
extends TextView {
    private CarUxRestrictionsUtil mCarUxRestrictionsUtil;
    private CarUxRestrictions mCarUxRestrictions;
    private CarUxRestrictionsUtil.OnUxRestrictionsChangedListener mListener;

    public UxrTextView(Context context) {
        super(context);
        this.init(context);
    }

    public UxrTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public UxrTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public UxrTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.mCarUxRestrictionsUtil = CarUxRestrictionsUtil.getInstance((Context)context);
        this.mListener = this::updateCarUxRestrictions;
    }

    private void updateCarUxRestrictions(CarUxRestrictions carUxRestrictions) {
        this.mCarUxRestrictions = carUxRestrictions;
        this.setTransformationMethod(new UXRTransformationMethod());
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mCarUxRestrictionsUtil.register(this.mListener);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mCarUxRestrictionsUtil.unregister(this.mListener);
    }

    public void setAllCaps(boolean b) {
    }

    public void setSingleLine(boolean b) {
    }

    public void setInputType(int i) {
    }

    private class UXRTransformationMethod
    implements TransformationMethod {
        private UXRTransformationMethod() {
        }

        public CharSequence getTransformation(CharSequence source, View view) {
            if (source == null) {
                return "";
            }
            return CarUxRestrictionsUtil.complyString((Context)UxrTextView.this.getContext(), (String)source.toString(), (CarUxRestrictions)UxrTextView.this.mCarUxRestrictions);
        }

        public void onFocusChanged(View view, CharSequence sourceText, boolean focused, int direction, Rect previouslyFocusedRect) {
        }
    }
}

