/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common.imaging;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.android.car.apps.common.R;
import com.android.car.apps.common.UriUtils;
import com.android.car.apps.common.imaging.ImageFetcher;
import com.android.car.apps.common.imaging.ImageKey;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class ImageBinder<T extends ImageRef> {
    private final PlaceholderType mPlaceholderType;
    private final Size mMaxImageSize;
    @Nullable
    private final Consumer<Drawable> mClient;
    private T mCurrentRef;
    private ImageKey mCurrentKey;
    private BiConsumer<ImageKey, Drawable> mFetchReceiver;
    private Drawable mLoadingDrawable;

    public ImageBinder(@NonNull PlaceholderType type, @NonNull Size maxImageSize, @NonNull Consumer<Drawable> consumer) {
        this.mPlaceholderType = (PlaceholderType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"Need a type"));
        this.mMaxImageSize = (Size)Preconditions.checkNotNull((Object)maxImageSize, (Object)"Need a size");
        this.mClient = (Consumer)Preconditions.checkNotNull(consumer, (Object)"Cannot bind a null consumer");
    }

    protected ImageBinder(@NonNull PlaceholderType type, @NonNull Size maxImageSize) {
        this.mPlaceholderType = (PlaceholderType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"Need a type"));
        this.mMaxImageSize = (Size)Preconditions.checkNotNull((Object)maxImageSize, (Object)"Need a size");
        this.mClient = null;
    }

    protected void setDrawable(@Nullable Drawable drawable2) {
        if (this.mClient != null) {
            this.mClient.accept(drawable2);
        }
    }

    public void setImage(Context context, @Nullable T newRef) {
        this.setImage(context, newRef, true);
    }

    public void setImage(Context context, @Nullable T newRef, boolean preventRemoteUris) {
        if (this.isSameImage(context, newRef)) {
            return;
        }
        this.prepareForNewBinding(context);
        this.mCurrentRef = newRef;
        if (this.mCurrentRef == null) {
            this.setDrawable(null);
        } else {
            Drawable image = this.mCurrentRef.getImage(context);
            if (image != null) {
                this.setDrawable(image);
                return;
            }
            this.mFetchReceiver = (key, drawable2) -> {
                if (Objects.equals(this.mCurrentKey, key)) {
                    Drawable displayed = drawable2 == null && this.mPlaceholderType != PlaceholderType.NONE ? this.mCurrentRef.getPlaceholder(context, this.mPlaceholderType) : drawable2;
                    this.setDrawable(displayed);
                    this.onRequestFinished();
                }
            };
            if (UriUtils.isEmpty(this.mCurrentRef.getImageURI())) {
                this.mCurrentKey = null;
                this.mFetchReceiver.accept(null, null);
            } else {
                this.mCurrentKey = new ImageKey(this.mCurrentRef.getImageURI(), this.mMaxImageSize);
                this.getImageFetcher(context).getImage(context, this.mCurrentKey, this.mFetchReceiver, preventRemoteUris);
            }
        }
    }

    private boolean isSameImage(Context context, @Nullable T newRef) {
        if (this.mCurrentRef == null && newRef == null) {
            return true;
        }
        if (this.mCurrentRef != null && newRef != null) {
            return this.mCurrentRef.equals(context, newRef);
        }
        return false;
    }

    private ImageFetcher getImageFetcher(Context context) {
        return ImageFetcher.getInstance(context);
    }

    protected void prepareForNewBinding(Context context) {
        if (this.mCurrentKey != null) {
            this.getImageFetcher(context).cancelRequest(this.mCurrentKey, this.mFetchReceiver);
            this.onRequestFinished();
        }
        this.setDrawable(this.mPlaceholderType != PlaceholderType.NONE ? this.getLoadingDrawable(context) : null);
    }

    private void onRequestFinished() {
        this.mCurrentKey = null;
        this.mFetchReceiver = null;
    }

    private Drawable getLoadingDrawable(Context context) {
        if (this.mLoadingDrawable == null) {
            int color2 = context.getColor(R.color.loading_image_placeholder_color);
            this.mLoadingDrawable = new ColorDrawable(color2);
        }
        return this.mLoadingDrawable;
    }

    public static enum PlaceholderType {
        NONE,
        FOREGROUND,
        FOREGROUND_ICON,
        BACKGROUND;

    }

    public static interface ImageRef {
        public boolean equals(Context var1, Object var2);

        @Nullable
        public Uri getImageURI();

        @Nullable
        default public Drawable getImage(Context context) {
            return null;
        }

        public Drawable getPlaceholder(Context var1, @NonNull PlaceholderType var2);
    }
}

