/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common.imaging;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import android.util.LruCache;
import androidx.annotation.UiThread;
import com.android.car.apps.common.BitmapUtils;
import com.android.car.apps.common.CommonFlags;
import com.android.car.apps.common.R;
import com.android.car.apps.common.UriUtils;
import com.android.car.apps.common.imaging.ImageKey;
import com.android.car.apps.common.util.CarAppsIOUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;

public class ImageFetcher {
    private static final String TAG = "ImageFetcher";
    private static final boolean L_WARN = Log.isLoggable((String)"ImageFetcher", (int)5);
    private static final boolean L_DEBUG = Log.isLoggable((String)"ImageFetcher", (int)3);
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static ImageFetcher sInstance;
    private final int mPoolSize;
    private final LruCache<String, Executor> mThreadPools;
    private final Map<ImageKey, HashSet<BiConsumer<ImageKey, Drawable>>> mConsumers = new HashMap<ImageKey, HashSet<BiConsumer<ImageKey, Drawable>>>(20);
    private final Map<ImageKey, ImageLoadingTask> mTasks = new HashMap<ImageKey, ImageLoadingTask>(20);
    private final LruCache<ImageKey, Drawable> mMemoryCache;
    private final boolean mFlagRemoteImages;

    public static ImageFetcher getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new ImageFetcher(context);
        }
        return sInstance;
    }

    @UiThread
    private ImageFetcher(Context context) {
        Resources res = context.getResources();
        int maxPools = res.getInteger(R.integer.image_fetcher_thread_pools_max_count);
        this.mPoolSize = res.getInteger(R.integer.image_fetcher_thread_pool_size);
        this.mThreadPools = new LruCache(maxPools);
        int cacheSizeMB = res.getInteger(R.integer.bitmap_memory_cache_max_size_mb);
        final int drawableDefaultWeightKB = res.getInteger(R.integer.drawable_default_weight_kb);
        this.mMemoryCache = new LruCache<ImageKey, Drawable>(cacheSizeMB * 0x100000){

            protected int sizeOf(ImageKey key, Drawable drawable2) {
                if (drawable2 instanceof BitmapDrawable) {
                    return ((BitmapDrawable)drawable2).getBitmap().getAllocationByteCount();
                }
                return drawableDefaultWeightKB * 1024;
            }
        };
        this.mFlagRemoteImages = CommonFlags.getInstance(context).shouldFlagImproperImageRefs();
    }

    private Executor getThreadPool(String packageName) {
        Executor result = (Executor)this.mThreadPools.get((Object)packageName);
        if (result == null) {
            result = Executors.newFixedThreadPool(this.mPoolSize);
            this.mThreadPools.put((Object)packageName, (Object)result);
        }
        return result;
    }

    @UiThread
    public void getImage(Context context, ImageKey key, BiConsumer<ImageKey, Drawable> consumer, boolean preventRemoteImages) {
        Drawable cached = (Drawable)this.mMemoryCache.get((Object)key);
        if (cached != null) {
            consumer.accept(key, cached);
            return;
        }
        ImageLoadingTask task = this.mTasks.get(key);
        HashSet<BiConsumer<ImageKey, Object>> consumers = this.mConsumers.get(key);
        if (consumers == null) {
            consumers = new HashSet(3);
            if (task != null && L_WARN) {
                Log.w((String)TAG, (String)("Expected no task here for " + key));
            }
            this.mConsumers.put(key, consumers);
        }
        consumers.add(consumer);
        if (task == null) {
            String packageName = UriUtils.getPackageName(context, key.mImageUri);
            if (packageName != null) {
                task = new ImageLoadingTask(context, key, this.mFlagRemoteImages, preventRemoteImages);
                this.mTasks.put(key, task);
                task.executeOnExecutor(this.getThreadPool(packageName), new Void[0]);
                if (L_DEBUG) {
                    Log.d((String)TAG, (String)("Added task " + key.mImageUri));
                }
            } else {
                Log.e((String)TAG, (String)("No package for " + key.mImageUri));
            }
        }
    }

    @UiThread
    public void cancelRequest(ImageKey key, BiConsumer<ImageKey, Drawable> consumer) {
        HashSet<BiConsumer<ImageKey, Drawable>> consumers = this.mConsumers.get(key);
        if (consumers != null) {
            boolean removed = consumers.remove(consumer);
            if (consumers.isEmpty()) {
                this.mConsumers.remove(key);
                ImageLoadingTask task = this.mTasks.remove(key);
                if (task != null) {
                    task.cancel(true);
                    if (L_DEBUG) {
                        Log.d((String)TAG, (String)("Canceled task " + key.mImageUri));
                    }
                } else if (L_WARN) {
                    Log.w((String)TAG, (String)("cancelRequest missing task for: " + key));
                }
            }
            if (!removed && L_WARN) {
                Log.w((String)TAG, (String)("cancelRequest missing consumer for: " + key));
            }
        } else if (L_WARN) {
            Log.w((String)TAG, (String)("cancelRequest has no consumers for: " + key));
        }
    }

    @UiThread
    private void fulfilRequests(ImageLoadingTask task, Drawable drawable2) {
        ImageKey key = task.mImageKey;
        ImageLoadingTask pendingTask = this.mTasks.get(key);
        if (pendingTask == task) {
            if (drawable2 != null) {
                this.mMemoryCache.put((Object)key, (Object)drawable2);
            }
            HashSet<BiConsumer<ImageKey, Drawable>> consumers = this.mConsumers.remove(key);
            this.mTasks.remove(key);
            if (consumers != null) {
                for (BiConsumer<ImageKey, Drawable> consumer : consumers) {
                    consumer.accept(key, drawable2);
                }
            }
        } else if (L_WARN) {
            Log.w((String)TAG, (String)("A new task already started for: " + task.mImageKey));
        }
    }

    private static class ImageLoadingTask
    extends AsyncTask<Void, Void, Drawable> {
        private final WeakReference<Context> mWeakContext;
        private final ImageKey mImageKey;
        private final boolean mFlagRemoteImages;
        private final boolean mPreventRemoteImages;
        private final ImageDecoder.OnHeaderDecodedListener mOnHeaderDecodedListener = new ImageDecoder.OnHeaderDecodedListener(){

            public void onHeaderDecoded(ImageDecoder decoder, ImageDecoder.ImageInfo info, ImageDecoder.Source source) {
                if (this.isCancelled()) {
                    throw new CancellationException();
                }
                decoder.setAllocator(mAllocatorMode);
                int maxW = ((ImageLoadingTask)this).mImageKey.mMaxImageSize.getWidth();
                int maxH = ((ImageLoadingTask)this).mImageKey.mMaxImageSize.getHeight();
                int imgW = info.getSize().getWidth();
                int imgH = info.getSize().getHeight();
                if (imgW > maxW || imgH > maxH) {
                    float scale = Math.min((float)maxW / (float)imgW, (float)maxH / (float)imgH);
                    decoder.setTargetSize(Math.round(scale * (float)imgW), Math.round(scale * (float)imgH));
                }
            }
        };
        private int mAllocatorMode = 1;

        @UiThread
        ImageLoadingTask(Context context, ImageKey request, boolean flagRemoteImages, boolean preventRemoteImages) {
            this.mWeakContext = new WeakReference<Context>(context.getApplicationContext());
            this.mImageKey = request;
            this.mFlagRemoteImages = flagRemoteImages;
            this.mPreventRemoteImages = preventRemoteImages;
        }

        protected Drawable doInBackground(Void ... voids) {
            try {
                if (this.isCancelled()) {
                    return null;
                }
                Uri imageUri = this.mImageKey.mImageUri;
                Context context = (Context)this.mWeakContext.get();
                if (context == null) {
                    return null;
                }
                if (UriUtils.isAndroidResourceUri(imageUri)) {
                    return UriUtils.getDrawable(context, UriUtils.getIconResource(context, imageUri));
                }
                if (UriUtils.isContentUri(imageUri)) {
                    ContentResolver resolver = context.getContentResolver();
                    ImageDecoder.Source src = ImageDecoder.createSource((ContentResolver)resolver, (Uri)imageUri);
                    return ImageDecoder.decodeDrawable((ImageDecoder.Source)src, (ImageDecoder.OnHeaderDecodedListener)this.mOnHeaderDecodedListener);
                }
                if (this.mPreventRemoteImages && this.mFlagRemoteImages) {
                    return this.loadRemoteUri(context, imageUri, true);
                }
                if (!this.mPreventRemoteImages) {
                    return this.loadRemoteUri(context, imageUri, false);
                }
            }
            catch (IOException ioe) {
                Log.e((String)ImageFetcher.TAG, (String)("ImageLoadingTask#doInBackground: " + ioe));
            }
            catch (CancellationException e) {
                return null;
            }
            return null;
        }

        @UiThread
        protected void onPostExecute(Drawable drawable2) {
            if (L_DEBUG) {
                Log.d((String)ImageFetcher.TAG, (String)("onPostExecute canceled:  " + this.isCancelled() + " drawable: " + drawable2 + " " + this.mImageKey.mImageUri));
            }
            if (!this.isCancelled()) {
                if (sInstance != null) {
                    sInstance.fulfilRequests(this, drawable2);
                } else {
                    Log.e((String)ImageFetcher.TAG, (String)"ImageLoadingTask#onPostExecute: ImageFetcher was reset !");
                }
            }
        }

        private Drawable loadRemoteUri(Context context, Uri imageUri, boolean shouldTintDrawable) throws IOException {
            this.mAllocatorMode = 1;
            URL url = new URL(imageUri.toString());
            BufferedInputStream is = new BufferedInputStream(url.openStream());
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            CarAppsIOUtils.copy(is, bytes);
            ImageDecoder.Source src = ImageDecoder.createSource((ByteBuffer)ByteBuffer.wrap(bytes.toByteArray()));
            Bitmap decoded = ImageDecoder.decodeBitmap((ImageDecoder.Source)src, (ImageDecoder.OnHeaderDecodedListener)this.mOnHeaderDecodedListener);
            if (shouldTintDrawable) {
                decoded = BitmapUtils.createTintedBitmap(decoded, context.getColor(R.color.improper_image_refs_tint_color));
            }
            return new BitmapDrawable(context.getResources(), decoded);
        }
    }
}

