/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common.imaging;

import android.net.Uri;
import android.util.Size;
import androidx.core.util.Preconditions;
import com.android.car.apps.common.UriUtils;
import java.util.Objects;

class ImageKey {
    public final Uri mImageUri;
    public final Size mMaxImageSize;

    ImageKey(Uri imageUri, Size maxImageSize) {
        Preconditions.checkArgument((!UriUtils.isEmpty(imageUri) ? 1 : 0) != 0, (Object)"Empty uri!");
        this.mImageUri = imageUri;
        this.mMaxImageSize = maxImageSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageKey imageKey = (ImageKey)o;
        return this.mImageUri.equals((Object)imageKey.mImageUri) && this.mMaxImageSize.equals((Object)imageKey.mMaxImageSize);
    }

    public int hashCode() {
        return Objects.hash(this.mImageUri, this.mMaxImageSize);
    }

    public String toString() {
        return "ImageKey{mImageUri=" + this.mImageUri + ", mMaxImageSize=" + this.mMaxImageSize + '}';
    }
}

