/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common.imaging;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Size;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.android.car.apps.common.CommonFlags;
import com.android.car.apps.common.R;
import com.android.car.apps.common.imaging.ImageBinder;

public class ImageViewBinder<T extends ImageBinder.ImageRef>
extends ImageBinder<T> {
    @Nullable
    private final ImageView mImageView;
    private final boolean mFlagBitmaps;
    private T mSavedRef;
    private boolean mCancelled;

    public ImageViewBinder(Size maxImageSize, @Nullable ImageView imageView) {
        this(ImageBinder.PlaceholderType.FOREGROUND, maxImageSize, imageView, false);
    }

    public ImageViewBinder(ImageBinder.PlaceholderType type, Size maxImageSize, @Nullable ImageView imageView, boolean flagBitmaps) {
        super(type, maxImageSize);
        this.mImageView = imageView;
        this.mFlagBitmaps = flagBitmaps;
    }

    @Override
    protected void setDrawable(@Nullable Drawable drawable2) {
        if (this.mImageView != null) {
            CommonFlags flags;
            this.mImageView.setImageDrawable(drawable2);
            if (this.mFlagBitmaps && (flags = CommonFlags.getInstance(this.mImageView.getContext())).shouldFlagImproperImageRefs()) {
                if (drawable2 instanceof BitmapDrawable) {
                    int tint = this.mImageView.getContext().getColor(R.color.improper_image_refs_tint_color);
                    this.mImageView.setColorFilter(tint);
                } else {
                    this.mImageView.clearColorFilter();
                }
            }
        }
    }

    @Override
    public void setImage(Context context, @Nullable T newRef) {
        this.mSavedRef = newRef;
        this.mCancelled = false;
        if (this.mImageView != null) {
            super.setImage(context, newRef);
        }
    }

    public void maybeRestartLoading(Context context) {
        if (this.mCancelled) {
            this.setImage(context, this.mSavedRef);
        }
    }

    public void maybeCancelLoading(Context context) {
        this.mCancelled = true;
        if (this.mImageView != null) {
            super.setImage(context, null);
        }
    }

    @Override
    protected void prepareForNewBinding(Context context) {
        this.mImageView.setImageBitmap(null);
        this.mImageView.setImageDrawable(null);
        this.mImageView.clearColorFilter();
        super.prepareForNewBinding(context);
    }
}

