/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common.util;

import androidx.annotation.Nullable;

public class FutureData<T> {
    private final boolean mIsLoading;
    private final T mPastData;
    private final T mData;

    public static <T> FutureData<T> newLoadingData() {
        return new FutureData<Object>(true, null);
    }

    public static <T> FutureData<T> newLoadedData(T data) {
        return new FutureData<T>(false, data);
    }

    public static <T> FutureData<T> newLoadedData(T oldData, T newData) {
        return new FutureData<T>(false, oldData, newData);
    }

    @Nullable
    public static <T> T getData(@Nullable FutureData<T> future) {
        return future != null ? (T)future.getData() : null;
    }

    @Nullable
    public static <T> T getPastData(@Nullable FutureData<T> future) {
        return future != null ? (T)future.getPastData() : null;
    }

    @Deprecated
    public FutureData(boolean isLoading, T data) {
        this(isLoading, null, data);
    }

    private FutureData(boolean isLoading, T oldData, T newData) {
        this.mIsLoading = isLoading;
        this.mPastData = oldData;
        this.mData = newData;
    }

    public boolean isLoading() {
        return this.mIsLoading;
    }

    public T getData() {
        return this.mData;
    }

    public T getPastData() {
        return this.mPastData;
    }
}

