/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common.util;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.util.Function;
import androidx.core.util.Pair;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import com.android.car.apps.common.util.FutureData;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class LiveDataFunctions {
    private static volatile LiveData<?> sNullLiveData;
    private static volatile LiveData<Boolean> sTrueLiveData;
    private static volatile LiveData<Boolean> sFalseLiveData;

    private LiveDataFunctions() {
    }

    public static <T> LiveData<T> nullLiveData() {
        if (sNullLiveData == null) {
            sNullLiveData = LiveDataFunctions.dataOf(null);
        }
        return sNullLiveData;
    }

    public static <T> MutableLiveData<T> dataOf(@Nullable T value) {
        MutableLiveData data = new MutableLiveData();
        data.setValue(value);
        return data;
    }

    public static <T, R> LiveData<R> mapNonNull(@NonNull LiveData<T> source, @NonNull Function<T, R> func) {
        return LiveDataFunctions.mapNonNull(source, null, func);
    }

    public static <T, R> LiveData<R> mapNonNull(@NonNull LiveData<T> source, @Nullable R nullValue, @NonNull Function<T, R> func) {
        return Transformations.map(source, value -> value == null ? nullValue : func.apply(value));
    }

    public static <T, R> LiveData<R> switchMapNonNull(@NonNull LiveData<T> source, @NonNull Function<T, LiveData<R>> func) {
        return LiveDataFunctions.switchMapNonNull(source, null, value -> (LiveData)func.apply(value));
    }

    public static <T, R> LiveData<R> switchMapNonNull(@NonNull LiveData<T> source, @Nullable R nullValue, @NonNull Function<T, LiveData<R>> func) {
        return Transformations.switchMap(source, value -> value == null ? LiveDataFunctions.nullLiveData() : (LiveData)func.apply(value));
    }

    public static <T, R> LiveData<FutureData<R>> loadingSwitchMap(final LiveData<T> trigger, @NonNull Function<T, LiveData<R>> func) {
        final LiveData output = Transformations.switchMap(trigger, value -> (LiveData)func.apply(value));
        return new MediatorLiveData<FutureData<R>>(){
            {
                this.addSource(trigger, data -> this.setValue(new FutureData<Object>(true, null)));
                this.addSource(output, data -> this.setValue(new FutureData<Object>(false, output.getValue())));
            }
        };
    }

    public static <T> LiveData<T> iff(@NonNull LiveData<Boolean> predicate, @NonNull LiveData<T> value) {
        return LiveDataFunctions.iff(predicate, Boolean::booleanValue, value);
    }

    public static <P, T> LiveData<T> iff(@NonNull LiveData<P> trigger, @NonNull Predicate<? super P> predicate, @NonNull LiveData<T> value) {
        return new BinaryOperation<Object, Object, Object>(trigger, value, (p, v) -> p == null || !predicate.test((Object)p) ? null : v);
    }

    public static <T, U> LiveData<Pair<T, U>> pair(@NonNull LiveData<T> tData, @NonNull LiveData<U> uData) {
        return LiveDataFunctions.combine(tData, uData, Pair::new);
    }

    public static <T, U, R> LiveData<R> combine(@NonNull LiveData<T> tData, @NonNull LiveData<U> uData, @NonNull BiFunction<T, U, R> function) {
        return new BinaryOperation<T, U, R>(tData, uData, function);
    }

    private static class BinaryOperation<T, U, R>
    extends MediatorLiveData<R> {
        @NonNull
        private final BiFunction<T, U, R> mFunction;
        private boolean mTSet;
        private boolean mUSet;
        private boolean mValueSet;
        @Nullable
        private T mTValue;
        @Nullable
        private U mUValue;

        BinaryOperation(@NonNull LiveData<T> tLiveData, @NonNull LiveData<U> uLiveData, @NonNull BiFunction<T, U, R> function) {
            this(tLiveData, uLiveData, true, true, function);
        }

        BinaryOperation(@NonNull LiveData<T> tLiveData, @NonNull LiveData<U> uLiveData, boolean requireTSet, boolean requireUSet, @NonNull BiFunction<T, U, R> function) {
            this.mFunction = function;
            if (!requireTSet) {
                this.mTSet = true;
            }
            if (!requireUSet) {
                this.mUSet = true;
            }
            if (tLiveData == uLiveData) {
                this.addSource(tLiveData, value -> {
                    this.mTSet = true;
                    this.mUSet = true;
                    this.mTValue = value;
                    this.mUValue = value;
                    this.update();
                });
            } else {
                this.addSource(Objects.requireNonNull(tLiveData), this::updateT);
                this.addSource(Objects.requireNonNull(uLiveData), this::updateU);
            }
        }

        private void updateT(@Nullable T tValue) {
            this.mTSet = true;
            this.mTValue = tValue;
            this.update();
        }

        private void updateU(@Nullable U uValue) {
            this.mUSet = true;
            this.mUValue = uValue;
            this.update();
        }

        private void update() {
            if (this.mTSet && this.mUSet) {
                R result = this.mFunction.apply(this.mTValue, this.mUValue);
                if (!this.mValueSet || result != this.getValue()) {
                    this.mValueSet = true;
                    this.setValue(result);
                }
            }
        }
    }
}

