/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common.util;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;

public final class PagedSmoothScroller
extends LinearSmoothScroller {
    private static final float MILLISECONDS_PER_INCH = 150.0f;
    private static final float DECELERATION_TIME_DIVISOR = 0.45f;
    private final Interpolator mInterpolator = new DecelerateInterpolator(1.8f);

    public PagedSmoothScroller(Context context) {
        super(context);
    }

    protected int getVerticalSnapPreference() {
        return -1;
    }

    protected void onTargetFound(View targetView, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
        int dy = this.calculateDyToMakeVisible(targetView, -1);
        if (dy == 0) {
            return;
        }
        int time = this.calculateTimeForDeceleration(dy);
        if (time > 0) {
            action.update(0, -dy, time, this.mInterpolator);
        }
    }

    protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
        return MILLISECONDS_PER_INCH / (float)displayMetrics.densityDpi;
    }

    protected int calculateTimeForDeceleration(int dx) {
        return (int)Math.ceil((float)this.calculateTimeForScrolling(dx) / DECELERATION_TIME_DIVISOR);
    }
}

