/*
 * Decompiled with CFR 0.152.
 */
package com.android.car.apps.common.util;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import java.util.ArrayList;
import java.util.List;

public class ViewUtils {
    public static void showHideViewAnimated(boolean show, @NonNull View view, int duration, @Nullable ViewAnimEndListener listener) {
        if (show) {
            ViewUtils.showViewAnimated(view, duration, listener);
        } else {
            ViewUtils.hideViewAnimated(view, duration, listener);
        }
    }

    public static void hideViewAnimated(final @NonNull View view, int duration, final @Nullable ViewAnimEndListener listener) {
        view.animate().cancel();
        if (!view.isLaidOut()) {
            view.setVisibility(8);
            return;
        }
        final Animator.AnimatorListener hider = ViewUtils.hideViewAfterAnimation(view);
        view.animate().setDuration((long)duration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                hider.onAnimationEnd(animation);
                if (listener != null) {
                    listener.onAnimationEnd(view);
                }
            }
        }).alpha(0.0f);
    }

    public static void hideViewAnimated(@NonNull View view, int duration) {
        ViewUtils.hideViewAnimated(view, duration, null);
    }

    public static Animator.AnimatorListener hideViewAfterAnimation(final View view) {
        return new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                view.setVisibility(8);
            }
        };
    }

    public static void hideViewsAnimated(@Nullable List<View> views, int duration) {
        if (views == null) {
            return;
        }
        for (View view : views) {
            if (view == null) continue;
            ViewUtils.hideViewAnimated(view, duration, null);
        }
    }

    public static void showViewAnimated(final @NonNull View view, int duration, final @Nullable ViewAnimEndListener listener) {
        view.animate().cancel();
        view.animate().setDuration((long)duration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                view.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                if (listener != null) {
                    listener.onAnimationEnd(view);
                }
            }
        }).alpha(1.0f);
    }

    public static void showViewAnimated(@NonNull View view, int duration) {
        ViewUtils.showViewAnimated(view, duration, null);
    }

    public static void showViewsAnimated(@Nullable List<View> views, int duration) {
        for (View view : views) {
            if (view == null) continue;
            ViewUtils.showViewAnimated(view, duration, null);
        }
    }

    public static boolean isVisible(@Nullable View view) {
        return view != null && view.getVisibility() == 0;
    }

    public static void setVisible(@Nullable View view, boolean visible) {
        if (view != null) {
            view.setVisibility(visible ? 0 : 8);
        }
    }

    public static void setVisible(@Nullable List<View> views, boolean visible) {
        for (View view : views) {
            ViewUtils.setVisible(view, visible);
        }
    }

    public static void setInvisible(@Nullable View view, boolean invisible) {
        if (view != null) {
            view.setVisibility(invisible ? 4 : 0);
        }
    }

    public static void setText(@Nullable TextView view, @StringRes int resId) {
        if (view != null) {
            view.setText(resId);
        }
    }

    public static void setText(@Nullable TextView view, CharSequence text) {
        if (view != null) {
            view.setText(text);
        }
    }

    public static void setEnabled(@Nullable View view, boolean enabled) {
        if (view != null) {
            view.setEnabled(enabled);
        }
    }

    public static void setActivated(@Nullable View view, boolean activated) {
        if (view != null) {
            view.setActivated(activated);
        }
    }

    public static void setOnClickListener(@Nullable View view, @Nullable View.OnClickListener l) {
        if (view != null) {
            view.setOnClickListener(l);
        }
    }

    public static <T extends View> List<T> getViewsById(@NonNull View root, @NonNull Resources res, int arrayId, @Nullable Filter filter) {
        TypedArray viewIds = res.obtainTypedArray(arrayId);
        ArrayList<View> views = new ArrayList<View>(viewIds.length());
        for (int i = 0; i < viewIds.length(); ++i) {
            View view;
            int viewId = viewIds.getResourceId(i, 0);
            if (viewId == 0 || (view = root.findViewById(viewId)) == null || filter != null && !filter.isValid(view)) continue;
            views.add(view);
        }
        viewIds.recycle();
        return views;
    }

    public static void removeFromParent(@Nullable View view) {
        ViewGroup parent;
        if (view != null && (parent = (ViewGroup)view.getParent()) != null) {
            parent.removeView(view);
        }
    }

    public static void setView(@Nullable View view, FrameLayout container) {
        if (view != null) {
            if (container.getChildCount() == 1 && container.getChildAt(0) == view) {
                return;
            }
            ViewUtils.removeFromParent(view);
            container.removeAllViews();
            container.addView(view);
            container.setVisibility(0);
        } else {
            if (container.getChildCount() != 0) {
                container.removeAllViews();
            }
            container.setVisibility(4);
        }
    }

    public static boolean isViewOccludedByKeyboard(View view) {
        boolean imeVisible;
        WindowInsetsCompat insets = ViewCompat.getRootWindowInsets((View)view);
        boolean bl = imeVisible = insets != null && insets.isVisible(WindowInsetsCompat.Type.ime());
        if (!imeVisible) {
            return false;
        }
        int imeHeight = insets.getInsets((int)WindowInsetsCompat.Type.ime()).bottom;
        Rect viewRect = new Rect();
        view.getGlobalVisibleRect(viewRect);
        return viewRect.bottom > imeHeight;
    }

    public static interface ViewAnimEndListener {
        public void onAnimationEnd(View var1);
    }

    public static interface Filter {
        public boolean isValid(View var1);
    }
}

